/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ReachabilityResponse;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReachabilityRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReachabilityRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public ReachabilityRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public ReachabilityRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public ReachabilityResponse get() throws TargomoClientException {
        Response response;
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()});
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing reachability request to URI: '%s'", target.getUri()));
        try {
            response = target.request().post(entity);
        }
        catch (ProcessingException exception) {
            target = this.client.target(this.travelOptions.getFallbackServiceUrl()).path("v1/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
            LOGGER.debug(String.format("Executing reachability request to URI: '%s'", target.getUri()));
            response = target.request().post(entity);
        }
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    private ReachabilityResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String res = (String)response.readEntity(String.class);
            return new ReachabilityResponse(this.travelOptions, JsonUtil.parseString(res), requestStart);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new ReachabilityResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), null);
    }
}

