/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.pojo.MobilityRequestOptions;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilityRequest {
    private static final Logger log = LoggerFactory.getLogger(MobilityRequest.class);
    public static final String ID = "id";
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    private final Client client;
    private final MobilityRequestOptions requestOptions;

    public MobilityRequest(Client client, MobilityRequestOptions requestOptions) {
        this.client = client;
        this.requestOptions = requestOptions;
    }

    public MobilityRequest(MobilityRequestOptions requestOptions) {
        this(ClientBuilder.newClient(), requestOptions);
    }

    public List<MobilityResult> get(Collection<Coordinate> locations) throws TargomoClientException, JSONException {
        String path = "staypoints/profile/";
        WebTarget target = this.client.target(this.requestOptions.getMobilityServiceUrl()).path(path).queryParam("hour_start", new Object[]{this.requestOptions.getHourStart()}).queryParam("hour_end", new Object[]{this.requestOptions.getHourEnd()}).queryParam("day_start", new Object[]{this.requestOptions.getDayStart()}).queryParam("day_end", new Object[]{this.requestOptions.getDayEnd()}).queryParam("day_of_year_start", new Object[]{this.requestOptions.getDayOfYearStart()}).queryParam("day_of_year_end", new Object[]{this.requestOptions.getDayOfYearEnd()}).queryParam("unique", new Object[]{this.requestOptions.getUnique()}).queryParam("return_staypoints", new Object[]{this.requestOptions.getReturnStaypoints()}).queryParam("radius", new Object[]{this.requestOptions.getRadius()});
        Entity entity = Entity.entity((Object)MobilityRequest.parseLocations(locations), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        log.debug(String.format("Executing mobility request (%s) to URI: '%s'", path, target.getUri()));
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(entity);
        return this.parseResponse(response);
    }

    private List<MobilityResult> parseResponse(Response response) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                TypeReference<List<MobilityResult>> typeRef = new TypeReference<List<MobilityResult>>(){};
                return (List)new ObjectMapper().readValue((String)response.readEntity(String.class), (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new TargomoClientRuntimeException("Couldn't parse Mobility response", e);
            }
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    private static String parseLocations(Collection<Coordinate> locations) throws JSONException {
        JSONArray locationsJson = new JSONArray();
        for (Coordinate l : locations) {
            locationsJson.put((Object)new JSONObject().put(ID, (Object)l.getId()).put(LATITUDE, l.getY()).put(LONGITUDE, l.getX()));
        }
        return locationsJson.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MobilityResult {
        private String id;
        private Double lat;
        private Integer lon;
        private Integer radius;
        @JsonProperty(value="day_start")
        private Integer dayStart;
        @JsonProperty(value="day_end")
        private Integer dayEnd;
        @JsonProperty(value="hour_start")
        private Integer hourStart;
        @JsonProperty(value="hour_end")
        private Integer hourEnd;
        @JsonProperty(value="day_of_year_start")
        private Integer dayOfYearStart;
        @JsonProperty(value="day_of_year_end")
        private Integer dayOfYearEnd;
        @JsonProperty(value="min_duration")
        private Integer minDuration;
        @JsonProperty(value="max_duration")
        private Integer maxDuration;
        private Boolean unique;
        private Integer count;

        public void setId(String id) {
            this.id = id;
        }

        public void setLat(Double lat) {
            this.lat = lat;
        }

        public void setLon(Integer lon) {
            this.lon = lon;
        }

        public void setRadius(Integer radius) {
            this.radius = radius;
        }

        public void setDayStart(Integer dayStart) {
            this.dayStart = dayStart;
        }

        public void setDayEnd(Integer dayEnd) {
            this.dayEnd = dayEnd;
        }

        public void setHourStart(Integer hourStart) {
            this.hourStart = hourStart;
        }

        public void setHourEnd(Integer hourEnd) {
            this.hourEnd = hourEnd;
        }

        public void setDayOfYearStart(Integer dayOfYearStart) {
            this.dayOfYearStart = dayOfYearStart;
        }

        public void setDayOfYearEnd(Integer dayOfYearEnd) {
            this.dayOfYearEnd = dayOfYearEnd;
        }

        public void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        public void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        public void setUnique(Boolean unique) {
            this.unique = unique;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public String getId() {
            return this.id;
        }

        public Double getLat() {
            return this.lat;
        }

        public Integer getLon() {
            return this.lon;
        }

        public Integer getRadius() {
            return this.radius;
        }

        public Integer getDayStart() {
            return this.dayStart;
        }

        public Integer getDayEnd() {
            return this.dayEnd;
        }

        public Integer getHourStart() {
            return this.hourStart;
        }

        public Integer getHourEnd() {
            return this.hourEnd;
        }

        public Integer getDayOfYearStart() {
            return this.dayOfYearStart;
        }

        public Integer getDayOfYearEnd() {
            return this.dayOfYearEnd;
        }

        public Integer getMinDuration() {
            return this.minDuration;
        }

        public Integer getMaxDuration() {
            return this.maxDuration;
        }

        public Boolean getUnique() {
            return this.unique;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

