/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.pojo.EdgeStatisticsRequestOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeStatisticsRequest {
    private static final Logger log = LoggerFactory.getLogger(EdgeStatisticsRequest.class);
    private final Client client;
    private final EdgeStatisticsRequestOptions requestOptions;
    private final MultivaluedMap<String, Object> headers;

    public EdgeStatisticsRequest(Client client, EdgeStatisticsRequestOptions requestOptions) {
        this.client = client;
        this.requestOptions = requestOptions;
        this.headers = new MultivaluedHashMap();
    }

    public EdgeStatisticsRequest(EdgeStatisticsRequestOptions requestOptions) {
        this(ClientBuilder.newClient(), requestOptions);
    }

    public EdgeStatisticsRequest(Client client, EdgeStatisticsRequestOptions requestOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.requestOptions = requestOptions;
        this.headers = headers;
    }

    public Map<String, Double> get(Collection<Coordinate> locations) throws TargomoClientException, JSONException {
        String path = EdgeStatisticsRequest.buildLocationsPath(this.requestOptions.getEdgeStatisticGroupId(), this.requestOptions.getEdgeStatisticId());
        WebTarget target = this.client.target(this.requestOptions.getServiceUrl()).path(path).queryParam("key", new Object[]{this.requestOptions.getServiceKey()}).queryParam("radius", new Object[]{this.requestOptions.getRadius()}).queryParam("travelType", new Object[]{this.requestOptions.getTravelType()}).queryParam("direction", new Object[]{this.requestOptions.getDirection()});
        if (this.requestOptions.getIgnoreRoadClasses() != null) {
            for (Integer clazz : this.requestOptions.getIgnoreRoadClasses()) {
                target = target.queryParam("ignoreRoadClass", new Object[]{clazz});
            }
        }
        Entity entity = Entity.entity((Object)EdgeStatisticsRequest.parseLocations(locations), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        log.debug(String.format("Executing edge statistics request (%s) to URI: '%s'", path, target.getUri()));
        Response response = target.request().headers(this.headers).post(entity);
        return this.parseResponse(response);
    }

    private static String buildLocationsPath(Integer edgeStatisticGroupId, Integer edgeStatisticId) {
        return StringUtils.join(Arrays.asList("locations", String.valueOf(edgeStatisticGroupId), String.valueOf(edgeStatisticId)), (String)"/");
    }

    private Map<String, Double> parseResponse(Response response) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                TypeReference<HashMap<String, Double>> typeRef = new TypeReference<HashMap<String, Double>>(){};
                return (Map)new ObjectMapper().readValue((String)response.readEntity(String.class), (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new TargomoClientRuntimeException("Couldn't parse Edge Statistics response", e);
            }
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    private static String parseLocations(Collection<Coordinate> locations) throws JSONException {
        JSONArray locationsJson = new JSONArray();
        for (Coordinate l : locations) {
            locationsJson.put((Object)new JSONObject().put("id", (Object)l.getId()).put("y", l.getY()).put("x", l.getX()));
        }
        return locationsJson.toString();
    }
}

