/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.quality.criterion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.targomo.client.api.enums.EdgeWeightType;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientRequestConfigurationException;
import com.targomo.client.api.quality.criterion.CriterionDefinition;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.apache.commons.collections.map.CaseInsensitiveMap;

@JsonDeserialize(builder=RoutingBasedCriterionDefinitionBuilderImpl.class)
public abstract class RoutingBasedCriterionDefinition
extends CriterionDefinition {
    @NonNull
    private final EdgeWeightType edgeWeight;
    @NonNull
    private final Integer maxEdgeWeight;
    @NotEmpty
    private final CaseInsensitiveMap travelMode;
    private final Boolean elevation;
    private final Map<String, Double> travelTimeFactors;
    private final Boolean reverse;
    private final Integer maxSnapDistance;
    private String coreServiceUrl;

    @JsonIgnore
    public TravelType getTravelType() {
        if (this.travelMode.get((Object)"transit") != null) {
            return TravelType.TRANSIT;
        }
        if (this.travelMode.get((Object)"car") != null) {
            return TravelType.CAR;
        }
        if (this.travelMode.get((Object)"bike") != null) {
            return TravelType.BIKE;
        }
        if (this.travelMode.get((Object)"walk") != null) {
            return TravelType.WALK;
        }
        throw new TargomoClientRequestConfigurationException("Travel type not supported");
    }

    @JsonIgnore
    public Map getTravelModeProperties() {
        Object propertiesObj = this.travelMode.get((Object)this.getTravelType());
        if (propertiesObj == null) {
            return new HashMap();
        }
        if (!(propertiesObj instanceof Map)) {
            throw new TargomoClientRequestConfigurationException(String.format("Invalid configuration for travel mode '%s'", new Object[]{this.getTravelType()}));
        }
        return (Map)propertiesObj;
    }

    protected RoutingBasedCriterionDefinition(RoutingBasedCriterionDefinitionBuilder<?, ?> b) {
        super(b);
        this.edgeWeight = ((RoutingBasedCriterionDefinitionBuilder)b).edgeWeight;
        if (this.edgeWeight == null) {
            throw new NullPointerException("edgeWeight is marked non-null but is null");
        }
        this.maxEdgeWeight = ((RoutingBasedCriterionDefinitionBuilder)b).maxEdgeWeight;
        if (this.maxEdgeWeight == null) {
            throw new NullPointerException("maxEdgeWeight is marked non-null but is null");
        }
        this.travelMode = ((RoutingBasedCriterionDefinitionBuilder)b).travelMode;
        this.elevation = ((RoutingBasedCriterionDefinitionBuilder)b).elevation;
        this.travelTimeFactors = ((RoutingBasedCriterionDefinitionBuilder)b).travelTimeFactors;
        this.reverse = ((RoutingBasedCriterionDefinitionBuilder)b).reverse;
        this.maxSnapDistance = ((RoutingBasedCriterionDefinitionBuilder)b).maxSnapDistance;
        this.coreServiceUrl = ((RoutingBasedCriterionDefinitionBuilder)b).coreServiceUrl;
    }

    @NonNull
    public EdgeWeightType getEdgeWeight() {
        return this.edgeWeight;
    }

    @NonNull
    public Integer getMaxEdgeWeight() {
        return this.maxEdgeWeight;
    }

    public CaseInsensitiveMap getTravelMode() {
        return this.travelMode;
    }

    public Boolean getElevation() {
        return this.elevation;
    }

    public Map<String, Double> getTravelTimeFactors() {
        return this.travelTimeFactors;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public Integer getMaxSnapDistance() {
        return this.maxSnapDistance;
    }

    public String getCoreServiceUrl() {
        return this.coreServiceUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoutingBasedCriterionDefinition)) {
            return false;
        }
        RoutingBasedCriterionDefinition other = (RoutingBasedCriterionDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxEdgeWeight = this.getMaxEdgeWeight();
        Integer other$maxEdgeWeight = other.getMaxEdgeWeight();
        if (this$maxEdgeWeight == null ? other$maxEdgeWeight != null : !((Object)this$maxEdgeWeight).equals(other$maxEdgeWeight)) {
            return false;
        }
        Boolean this$elevation = this.getElevation();
        Boolean other$elevation = other.getElevation();
        if (this$elevation == null ? other$elevation != null : !((Object)this$elevation).equals(other$elevation)) {
            return false;
        }
        Boolean this$reverse = this.getReverse();
        Boolean other$reverse = other.getReverse();
        if (this$reverse == null ? other$reverse != null : !((Object)this$reverse).equals(other$reverse)) {
            return false;
        }
        Integer this$maxSnapDistance = this.getMaxSnapDistance();
        Integer other$maxSnapDistance = other.getMaxSnapDistance();
        if (this$maxSnapDistance == null ? other$maxSnapDistance != null : !((Object)this$maxSnapDistance).equals(other$maxSnapDistance)) {
            return false;
        }
        EdgeWeightType this$edgeWeight = this.getEdgeWeight();
        EdgeWeightType other$edgeWeight = other.getEdgeWeight();
        if (this$edgeWeight == null ? other$edgeWeight != null : !((Object)((Object)this$edgeWeight)).equals((Object)other$edgeWeight)) {
            return false;
        }
        CaseInsensitiveMap this$travelMode = this.getTravelMode();
        CaseInsensitiveMap other$travelMode = other.getTravelMode();
        if (this$travelMode == null ? other$travelMode != null : !this$travelMode.equals(other$travelMode)) {
            return false;
        }
        Map<String, Double> this$travelTimeFactors = this.getTravelTimeFactors();
        Map<String, Double> other$travelTimeFactors = other.getTravelTimeFactors();
        if (this$travelTimeFactors == null ? other$travelTimeFactors != null : !((Object)this$travelTimeFactors).equals(other$travelTimeFactors)) {
            return false;
        }
        String this$coreServiceUrl = this.getCoreServiceUrl();
        String other$coreServiceUrl = other.getCoreServiceUrl();
        return !(this$coreServiceUrl == null ? other$coreServiceUrl != null : !this$coreServiceUrl.equals(other$coreServiceUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RoutingBasedCriterionDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxEdgeWeight = this.getMaxEdgeWeight();
        result = result * 59 + ($maxEdgeWeight == null ? 43 : ((Object)$maxEdgeWeight).hashCode());
        Boolean $elevation = this.getElevation();
        result = result * 59 + ($elevation == null ? 43 : ((Object)$elevation).hashCode());
        Boolean $reverse = this.getReverse();
        result = result * 59 + ($reverse == null ? 43 : ((Object)$reverse).hashCode());
        Integer $maxSnapDistance = this.getMaxSnapDistance();
        result = result * 59 + ($maxSnapDistance == null ? 43 : ((Object)$maxSnapDistance).hashCode());
        EdgeWeightType $edgeWeight = this.getEdgeWeight();
        result = result * 59 + ($edgeWeight == null ? 43 : ((Object)((Object)$edgeWeight)).hashCode());
        CaseInsensitiveMap $travelMode = this.getTravelMode();
        result = result * 59 + ($travelMode == null ? 43 : $travelMode.hashCode());
        Map<String, Double> $travelTimeFactors = this.getTravelTimeFactors();
        result = result * 59 + ($travelTimeFactors == null ? 43 : ((Object)$travelTimeFactors).hashCode());
        String $coreServiceUrl = this.getCoreServiceUrl();
        result = result * 59 + ($coreServiceUrl == null ? 43 : $coreServiceUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RoutingBasedCriterionDefinition(super=" + super.toString() + ", edgeWeight=" + (Object)((Object)this.getEdgeWeight()) + ", maxEdgeWeight=" + this.getMaxEdgeWeight() + ", travelMode=" + this.getTravelMode() + ", elevation=" + this.getElevation() + ", travelTimeFactors=" + this.getTravelTimeFactors() + ", reverse=" + this.getReverse() + ", maxSnapDistance=" + this.getMaxSnapDistance() + ", coreServiceUrl=" + this.getCoreServiceUrl() + ")";
    }

    public void setCoreServiceUrl(String coreServiceUrl) {
        this.coreServiceUrl = coreServiceUrl;
    }

    public static abstract class RoutingBasedCriterionDefinitionBuilder<C extends RoutingBasedCriterionDefinition, B extends RoutingBasedCriterionDefinitionBuilder<C, B>>
    extends CriterionDefinition.CriterionDefinitionBuilder<C, B> {
        private EdgeWeightType edgeWeight;
        private Integer maxEdgeWeight;
        private CaseInsensitiveMap travelMode;
        private Boolean elevation;
        private Map<String, Double> travelTimeFactors;
        private Boolean reverse;
        private Integer maxSnapDistance;
        private String coreServiceUrl;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RoutingBasedCriterionDefinitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RoutingBasedCriterionDefinition instance, RoutingBasedCriterionDefinitionBuilder<?, ?> b) {
            b.edgeWeight(instance.edgeWeight);
            b.maxEdgeWeight(instance.maxEdgeWeight);
            b.travelMode(instance.travelMode);
            b.elevation(instance.elevation);
            b.travelTimeFactors(instance.travelTimeFactors);
            b.reverse(instance.reverse);
            b.maxSnapDistance(instance.maxSnapDistance);
            b.coreServiceUrl(instance.coreServiceUrl);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B edgeWeight(@NonNull EdgeWeightType edgeWeight) {
            if (edgeWeight == null) {
                throw new NullPointerException("edgeWeight is marked non-null but is null");
            }
            this.edgeWeight = edgeWeight;
            return (B)this.self();
        }

        public B maxEdgeWeight(@NonNull Integer maxEdgeWeight) {
            if (maxEdgeWeight == null) {
                throw new NullPointerException("maxEdgeWeight is marked non-null but is null");
            }
            this.maxEdgeWeight = maxEdgeWeight;
            return (B)this.self();
        }

        public B travelMode(CaseInsensitiveMap travelMode) {
            this.travelMode = travelMode;
            return (B)this.self();
        }

        public B elevation(Boolean elevation) {
            this.elevation = elevation;
            return (B)this.self();
        }

        public B travelTimeFactors(Map<String, Double> travelTimeFactors) {
            this.travelTimeFactors = travelTimeFactors;
            return (B)this.self();
        }

        public B reverse(Boolean reverse) {
            this.reverse = reverse;
            return (B)this.self();
        }

        public B maxSnapDistance(Integer maxSnapDistance) {
            this.maxSnapDistance = maxSnapDistance;
            return (B)this.self();
        }

        public B coreServiceUrl(String coreServiceUrl) {
            this.coreServiceUrl = coreServiceUrl;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RoutingBasedCriterionDefinition.RoutingBasedCriterionDefinitionBuilder(super=" + super.toString() + ", edgeWeight=" + (Object)((Object)this.edgeWeight) + ", maxEdgeWeight=" + this.maxEdgeWeight + ", travelMode=" + this.travelMode + ", elevation=" + this.elevation + ", travelTimeFactors=" + this.travelTimeFactors + ", reverse=" + this.reverse + ", maxSnapDistance=" + this.maxSnapDistance + ", coreServiceUrl=" + this.coreServiceUrl + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class RoutingBasedCriterionDefinitionBuilderImpl
    extends RoutingBasedCriterionDefinitionBuilder {
    }
}

