/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ReachabilityResponse;
import com.targomo.client.api.util.JsonUtil;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReachabilityRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReachabilityRequest.class);
    private final Client client;
    private final TravelOptions travelOptions;
    private static final String CALLBACK = "callback";
    private final MultivaluedMap<String, Object> headers;

    public ReachabilityRequest(TravelOptions travelOptions) {
        this.headers = new MultivaluedHashMap();
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public ReachabilityRequest(Client client, TravelOptions travelOptions) {
        this.headers = new MultivaluedHashMap();
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public ReachabilityRequest(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = headers;
    }

    public ReachabilityResponse get() throws TargomoClientException, ResponseErrorException {
        return this.get(Function.identity());
    }

    public ReachabilityResponse get(Function<String, String> targetIdMapperFilter) throws TargomoClientException, ResponseErrorException {
        Response response;
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()}).queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug("Executing reachability request to URI: '{}}'", (Object)target.getUri());
        try {
            response = target.request().headers(this.headers).post(entity);
        }
        catch (ProcessingException exception) {
            target = this.client.target(this.travelOptions.getFallbackServiceUrl()).path("v1/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
            LOGGER.debug("Executing reachability request to URI: '{}'", (Object)target.getUri());
            response = target.request().headers(this.headers).post(entity);
        }
        return this.validateResponse(response, requestStart, targetIdMapperFilter);
    }

    private ReachabilityResponse validateResponse(Response response, long requestStart, Function<String, String> targetIdMapperFilter) throws TargomoClientException, ResponseErrorException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String res = (String)response.readEntity(String.class);
            return new ReachabilityResponse(this.travelOptions, JsonUtil.parseString(res), requestStart, targetIdMapperFilter);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

