/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.quality.Location;
import com.targomo.client.api.quality.criterion.CriterionDefinition;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ScoreResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScoreRequest {
    private Client client;
    private Map<String, CriterionDefinition> criteria;
    private List<Location> locations;
    private List<Location> competitors;
    private String serviceUrl;
    private String apiKey;
    private boolean showDetails = false;

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations) {
        this.serviceUrl = serviceUrl;
        this.apiKey = key;
        this.client = ClientBuilder.newClient();
        this.criteria = criteria;
        this.locations = locations;
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors) {
        this(serviceUrl, key, criteria, locations);
        this.competitors = competitors;
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors, boolean showDetails) {
        this(serviceUrl, key, criteria, locations, competitors);
        this.showDetails = showDetails;
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, boolean showDetails) {
        this(serviceUrl, key, criteria, locations);
        this.showDetails = showDetails;
    }

    public ScoreResponse get() throws TargomoClientException, ResponseErrorException {
        WebTarget request = this.client.target(this.serviceUrl).path("v1/scores").queryParam("apiKey", new Object[]{this.apiKey}).queryParam("showDetails", new Object[]{this.showDetails});
        String config = RequestConfigurator.getConfig(this.criteria, this.locations, this.competitors);
        Response response = request.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return ScoreRequest.validateResponse(response);
    }

    public static ScoreResponse validateResponse(Response response) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String message;
            JSONObject data;
            JSONObject result = JsonUtil.parseString(IOUtil.getResultString(response));
            try {
                data = result.getJSONObject("data");
                message = result.getString("message");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            JSONArray errors = new JSONArray();
            DateTime timestamp = DateTime.now();
            return new ScoreResponse(data, message, errors, timestamp);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    public ScoreRequest(Client client, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors, String serviceUrl, String apiKey, boolean showDetails) {
        this.client = client;
        this.criteria = criteria;
        this.locations = locations;
        this.competitors = competitors;
        this.serviceUrl = serviceUrl;
        this.apiKey = apiKey;
        this.showDetails = showDetails;
    }
}

