/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.TimeResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class TimeRequest {
    private static final String CALLBACK = "callback";
    private Client client;
    private TravelOptions travelOptions;

    public TimeRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public TimeRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public TimeResponse get() throws TargomoClientException, ProcessingException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/time").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        if (this.travelOptions.getInterServiceKey() != null && !this.travelOptions.getInterServiceKey().isEmpty()) {
            target = target.queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()});
        }
        if (this.travelOptions.getInterServiceRequestType() != null && !this.travelOptions.getInterServiceRequestType().isEmpty()) {
            target = target.queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        }
        String config = RequestConfigurator.getConfig(this.travelOptions);
        Response response = target.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    public String toCurl() throws TargomoClientException {
        String url = this.travelOptions.getServiceUrl().endsWith("/") ? this.travelOptions.getServiceUrl() : this.travelOptions.getServiceUrl() + "/";
        return "curl -X POST '" + url + "v1/time?cb=" + CALLBACK + "&key=" + this.travelOptions.getServiceKey() + "' -H 'content-type: application/json' -d '" + RequestConfigurator.getConfig(this.travelOptions) + "'";
    }

    private TimeResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String res = IOUtil.getResultString(response);
            return new TimeResponse(this.travelOptions, JsonUtil.parseString(res), requestStart);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new TimeResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

