/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.geo.AbstractGeometry;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.pojo.AggregationConfiguration;
import com.targomo.client.api.pojo.AggregationInputParameters;
import com.targomo.client.api.quality.Location;
import com.targomo.client.api.quality.criterion.CriterionDefinition;
import com.targomo.client.api.request.config.builder.JSONBuilder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RequestConfigurator {
    private static final Logger LOG = Logger.getLogger(RequestConfigurator.class);

    private RequestConfigurator() {
    }

    public static String getConfig(TravelOptions travelOptions) throws TargomoClientException {
        LOG.trace((Object)"Creating configuration...");
        String config = RequestConfigurator.getCommonConfig(travelOptions);
        LOG.trace((Object)"Configuration created.");
        return config;
    }

    public static String getConfig(Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors) throws TargomoClientException {
        LOG.trace((Object)"Creating configuration...");
        String config = RequestConfigurator.getCommonConfig(criteria, locations, competitors);
        LOG.trace((Object)"Configuration created.");
        return config;
    }

    public static String getConfig(List<Location> locations, List<Location> competitors) throws TargomoClientException {
        LOG.trace((Object)"Creating configuration...");
        String config = RequestConfigurator.getCommonConfig(locations, competitors);
        LOG.trace((Object)"Configuration created.");
        return config;
    }

    private static String getCommonConfig(Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors) throws TargomoClientException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        StringBuilder config = JSONBuilder.beginJson(new StringBuilder());
        try {
            JSONBuilder.append(config, "locations", ow.writeValueAsString(locations));
            if (competitors != null) {
                JSONBuilder.append(config, "competitors", ow.writeValueAsString(competitors));
            }
            JSONBuilder.appendAndEnd(config, "criteria", ow.writeValueAsString(criteria));
        }
        catch (Exception e) {
            throw new TargomoClientException("Could not generate targomo config object", e);
        }
        return config.toString();
    }

    private static String getCommonConfig(List<Location> locations, List<Location> competitors) throws TargomoClientException {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        StringBuilder config = JSONBuilder.beginJson(new StringBuilder());
        try {
            if (competitors != null) {
                JSONBuilder.append(config, "competitors", ow.writeValueAsString(competitors));
            }
            JSONBuilder.appendAndEnd(config, "locations", ow.writeValueAsString(locations));
        }
        catch (Exception e) {
            throw new TargomoClientException("Could not generate targomo config object", e);
        }
        return config.toString();
    }

    private static String getCommonConfig(TravelOptions travelOptions) throws TargomoClientException {
        StringBuilder config = JSONBuilder.beginJson(new StringBuilder());
        try {
            if (travelOptions.getTravelTimes() != null && !travelOptions.getTravelTimes().isEmpty()) {
                JSONBuilder.append(config, "polygon", RequestConfigurator.getPolygonObject(travelOptions));
            }
            if (Stream.of(new Object[]{travelOptions.getMultiGraphEdgeClasses(), travelOptions.getMultiGraphSerializationFormat(), travelOptions.getMultiGraphSerializationDecimalPrecision(), travelOptions.getMultiGraphSerializationMaxGeometryCount(), travelOptions.getMultiGraphDomainType(), travelOptions.getMultiGraphDomainEdgeAggregationType(), travelOptions.getMultiGraphAggregationType(), travelOptions.getMultiGraphAggregationIgnoreOutliers(), travelOptions.getMultiGraphAggregationOutlierPenalty(), travelOptions.getMultiGraphAggregationMinSourcesRatio(), travelOptions.getMultiGraphAggregationMinSourcesCount(), travelOptions.getMultiGraphAggregationSourceValuesLowerBound(), travelOptions.getMultiGraphAggregationSourceValuesUpperBound(), travelOptions.getMultiGraphAggregationMinResultValue(), travelOptions.getMultiGraphAggregationMinResultValueRatio(), travelOptions.getMultiGraphAggregationMaxResultValue(), travelOptions.getMultiGraphAggregationMaxResultValueRatio(), travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins(), travelOptions.getMultiGraphAggregationGravitationExponent(), travelOptions.getMultiGraphAggregationProbabilityDecay(), travelOptions.getMultiGraphAggregationInputParameters(), travelOptions.getMultiGraphAggregationPostAggregationFactor(), travelOptions.getMultiGraphAggregationMathExpression(), travelOptions.getMultiGraphPreAggregationPipeline(), travelOptions.getMultiGraphLayerType(), travelOptions.getMultiGraphDomainEdgeAggregationType(), travelOptions.getMultiGraphLayerCustomGeometryMergeAggregation(), travelOptions.getMultiGraphLayerGeometryDetailLevel(), travelOptions.getMultiGraphLayerGeometryDetailPerTile(), travelOptions.getMultiGraphLayerMaxGeometryDetailLevel(), travelOptions.getMultiGraphLayerMinGeometryDetailLevel()}).anyMatch(Objects::nonNull) || Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).allMatch(Objects::nonNull)) {
                JSONBuilder.append(config, "multigraph", RequestConfigurator.getMultiGraphObject(travelOptions));
            }
            if (travelOptions.getIntersectionMode() != null) {
                JSONBuilder.appendString(config, "intersectionMode", (Object)travelOptions.getIntersectionMode());
            }
            if (travelOptions.getSources() != null && !travelOptions.getSources().isEmpty()) {
                JSONBuilder.append(config, "sources", RequestConfigurator.getSources(travelOptions));
            }
            if (travelOptions.getSourceGeometries() != null && !travelOptions.getSourceGeometries().isEmpty()) {
                JSONBuilder.append(config, "sourceGeometries", RequestConfigurator.getSourceGeometries(travelOptions));
            }
            if (travelOptions.getTargets() != null && !travelOptions.getTargets().isEmpty()) {
                JSONBuilder.append(config, "targets", RequestConfigurator.getTargets(travelOptions));
            }
            if (travelOptions.getTargetGeohashes() != null && !travelOptions.getTargetGeohashes().isEmpty()) {
                JSONBuilder.append(config, "targetGeohashes", travelOptions.getTargetGeohashes());
            }
            if (travelOptions.getPathSerializer() != null) {
                JSONBuilder.appendString(config, "pathSerializer", travelOptions.getPathSerializer().getPathSerializerName());
            }
            if (travelOptions.isElevationEnabled() != null) {
                JSONBuilder.append(config, "elevation", travelOptions.isElevationEnabled());
            }
            if (travelOptions.getReverse() != null) {
                JSONBuilder.append(config, "reverse", travelOptions.getReverse());
            }
            if (travelOptions.getEdgeWeightType() != null) {
                JSONBuilder.appendString(config, "edgeWeight", travelOptions.getEdgeWeightType().getKey());
            }
            if (travelOptions.getStatisticGroupId() != null) {
                JSONBuilder.appendString(config, "statisticGroupId", travelOptions.getStatisticGroupId());
            }
            if (travelOptions.getServiceUrl() != null) {
                JSONBuilder.append(config, "serviceUrl", "\"" + travelOptions.getServiceUrl() + "\"");
            }
            if (travelOptions.getServiceKey() != null) {
                JSONBuilder.append(config, "serviceKey", "\"" + travelOptions.getServiceKey() + "\"");
            }
            if (travelOptions.getFormat() != null) {
                JSONBuilder.append(config, "format", "\"" + travelOptions.getFormat().toString().toLowerCase() + "\"");
            }
            if (travelOptions.getBoundingBox() != null) {
                JSONBuilder.append(config, "boundingBox", "\"" + travelOptions.getBoundingBox() + "\"");
            }
            if (travelOptions.getOsmTypes() != null) {
                ObjectMapper mapper = new ObjectMapper();
                JSONBuilder.append(config, "osmTypes", mapper.writeValueAsString(travelOptions.getOsmTypes()));
            }
            if (travelOptions.getFilterGeometryForPOIs() != null) {
                JSONObject filterGeometry = new JSONObject().put("crs", (Object)travelOptions.getFilterGeometryForPOIs().getCrs()).put("data", (Object)travelOptions.getFilterGeometryForPOIs().getData());
                JSONBuilder.append(config, "filterGeometry", filterGeometry);
            }
            if (travelOptions.getPoiGravitationExponent() != null) {
                JSONBuilder.append(config, "gravitationExponent", travelOptions.getPoiGravitationExponent());
            }
            if (travelOptions.getPoiGravitationProbabilityDecay() != null) {
                JSONBuilder.append(config, "probabilityDecay", travelOptions.getPoiGravitationProbabilityDecay());
            }
            if (travelOptions.getTravelTimeFactors() != null && !travelOptions.getTravelTimeFactors().isEmpty()) {
                JSONObject travelFactors = new JSONObject();
                for (Map.Entry<String, Double> factor : travelOptions.getTravelTimeFactors().entrySet()) {
                    travelFactors.put(factor.getKey(), (Object)factor.getValue());
                }
                JSONBuilder.append(config, "travelTimeFactors", travelFactors);
            }
            if (travelOptions.getClipGeometry() != null) {
                JSONObject clipGeometry = new JSONObject().put("crs", (Object)travelOptions.getClipGeometry().getCrs()).put("data", (Object)travelOptions.getClipGeometry().getData());
                JSONBuilder.append(config, "clipGeometry", clipGeometry);
            }
            if (travelOptions.getMaxSnapDistance() != null) {
                JSONBuilder.append(config, "maxSnapDistance", travelOptions.getMaxSnapDistance());
            }
            if (travelOptions.getNextStopsStartTime() != null) {
                JSONBuilder.append(config, "nextStopsStartTime", travelOptions.getNextStopsStartTime());
            }
            if (travelOptions.getNextStopsEndTime() != null) {
                JSONBuilder.append(config, "nextStopsEndTime", travelOptions.getNextStopsEndTime());
            }
            JSONBuilder.append(config, "onlyPrintReachablePoints", travelOptions.getOnlyPrintReachablePoints());
            JSONBuilder.append(config, "forceRecalculate", travelOptions.isForceRecalculate());
            JSONBuilder.append(config, "cacheResult", travelOptions.isCacheResult());
            JSONBuilder.appendAndEnd(config, "maxEdgeWeight", travelOptions.getMaxEdgeWeight());
        }
        catch (Exception e) {
            throw new TargomoClientException("Could not generate targomo config object", e);
        }
        return config.toString();
    }

    private static JSONObject getPolygonObject(TravelOptions travelOptions) throws JSONException {
        JSONObject polygon = new JSONObject();
        polygon.put("values", (Object)new JSONArray(travelOptions.getTravelTimes()));
        polygon.put("intersectionMode", (Object)travelOptions.getIntersectionMode());
        polygon.put("pointReduction", travelOptions.isPointReduction());
        polygon.put("minPolygonHoleSize", travelOptions.getMinPolygonHoleSize());
        if (travelOptions.getSrid() != null) {
            polygon.put("srid", (Object)travelOptions.getSrid());
        }
        if (travelOptions.getPolygonOrientationRule() != null) {
            polygon.put("polygonOrientationRule", (Object)travelOptions.getPolygonOrientationRule());
        }
        if (travelOptions.getDecimalPrecision() != null) {
            polygon.put("decimalPrecision", (Object)travelOptions.getDecimalPrecision());
        }
        if (travelOptions.getBuffer() != null) {
            polygon.put("buffer", (Object)travelOptions.getBuffer());
        }
        if (travelOptions.getSimplify() != null) {
            polygon.put("simplify", (Object)travelOptions.getSimplify());
        }
        if (travelOptions.getQuadrantSegments() != null) {
            polygon.put("quadrantSegments", (Object)travelOptions.getQuadrantSegments());
        }
        if (travelOptions.getPolygonSerializerType() != null) {
            polygon.put("serializer", (Object)travelOptions.getPolygonSerializerType().getPolygonSerializerName());
        }
        if (travelOptions.getIntersectionGeometry() != null) {
            JSONObject intersectionPolygon = new JSONObject();
            intersectionPolygon.put("crs", (Object)travelOptions.getIntersectionGeometry().getCrs());
            intersectionPolygon.put("data", (Object)travelOptions.getIntersectionGeometry().getData());
            intersectionPolygon.put("type", (Object)travelOptions.getIntersectionGeometry().getType());
            polygon.put("intersectionGeometry", (Object)intersectionPolygon);
        }
        return polygon;
    }

    private static JSONObject getMultiGraphObject(TravelOptions travelOptions) throws JSONException {
        JSONObject multiGraph = new JSONObject();
        if (travelOptions.getMultiGraphEdgeClasses() != null) {
            multiGraph.put("edgeClasses", travelOptions.getMultiGraphEdgeClasses());
        }
        RequestConfigurator.addMultiGraphDomain(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphLayer(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphTile(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphSerialization(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphAggregation(travelOptions, multiGraph);
        RequestConfigurator.addMultiGraphPreAggregationPipeline(travelOptions, multiGraph);
        return multiGraph;
    }

    private static void addMultiGraphDomain(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Enum[]{travelOptions.getMultiGraphDomainType(), travelOptions.getMultiGraphDomainEdgeAggregationType()}).anyMatch(Objects::nonNull)) {
            JSONObject multiGraphDomain = new JSONObject();
            if (travelOptions.getMultiGraphDomainType() != null) {
                multiGraphDomain.put("type", (Object)travelOptions.getMultiGraphDomainType().getKey());
            }
            if (travelOptions.getMultiGraphDomainEdgeAggregationType() != null) {
                multiGraphDomain.put("edgeAggregationType", (Object)travelOptions.getMultiGraphDomainEdgeAggregationType().getKey());
            }
            multiGraph.put("domain", (Object)multiGraphDomain);
        }
    }

    private static void addMultiGraphLayer(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Serializable[]{travelOptions.getMultiGraphLayerType(), travelOptions.getMultiGraphLayerGeometryDetailPerTile(), travelOptions.getMultiGraphLayerMinGeometryDetailLevel(), travelOptions.getMultiGraphLayerMaxGeometryDetailLevel(), travelOptions.getMultiGraphLayerGeometryDetailLevel(), travelOptions.getMultiGraphLayerCustomGeometryMergeAggregation()}).anyMatch(x$0 -> Objects.nonNull(x$0))) {
            JSONObject multiGraphLayer = new JSONObject();
            if (travelOptions.getMultiGraphLayerType() != null) {
                multiGraphLayer.put("type", (Object)travelOptions.getMultiGraphLayerType().getKey());
            }
            if (travelOptions.getMultiGraphLayerGeometryDetailPerTile() != null) {
                multiGraphLayer.put("geometryDetailPerTile", (Object)travelOptions.getMultiGraphLayerGeometryDetailPerTile());
            }
            if (travelOptions.getMultiGraphLayerMinGeometryDetailLevel() != null) {
                multiGraphLayer.put("minGeometryDetailLevel", (Object)travelOptions.getMultiGraphLayerMinGeometryDetailLevel());
            }
            if (travelOptions.getMultiGraphLayerMaxGeometryDetailLevel() != null) {
                multiGraphLayer.put("maxGeometryDetailLevel", (Object)travelOptions.getMultiGraphLayerMaxGeometryDetailLevel());
            }
            if (travelOptions.getMultiGraphLayerGeometryDetailLevel() != null) {
                multiGraphLayer.put("geometryDetailLevel", (Object)travelOptions.getMultiGraphLayerGeometryDetailLevel());
            }
            if (travelOptions.getMultiGraphLayerCustomGeometryMergeAggregation() != null) {
                multiGraphLayer.put("customGeometryMergeAggregation", (Object)travelOptions.getMultiGraphLayerCustomGeometryMergeAggregation().getKey());
            }
            multiGraph.put("layer", (Object)multiGraphLayer);
        }
    }

    private static void addMultiGraphTile(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).allMatch(Objects::nonNull)) {
            JSONObject multiGraphTile = new JSONObject();
            multiGraphTile.put("zoom", (Object)travelOptions.getMultiGraphTileZoom());
            multiGraphTile.put("x", (Object)travelOptions.getMultiGraphTileX());
            multiGraphTile.put("y", (Object)travelOptions.getMultiGraphTileY());
            multiGraph.put("tile", (Object)multiGraphTile);
        } else if (Stream.of(travelOptions.getMultiGraphTileZoom(), travelOptions.getMultiGraphTileX(), travelOptions.getMultiGraphTileY()).anyMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("None or all elements in the multiGraphTile definition have to be set (zoom, x and y).");
        }
    }

    private static void addMultiGraphSerialization(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Serializable[]{travelOptions.getMultiGraphSerializationFormat(), travelOptions.getMultiGraphSerializationDecimalPrecision()}).anyMatch(x$0 -> Objects.nonNull(x$0))) {
            JSONObject multiGraphSerialization = new JSONObject();
            if (travelOptions.getMultiGraphSerializationFormat() != null) {
                multiGraphSerialization.put("format", (Object)travelOptions.getMultiGraphSerializationFormat().getKey());
            }
            if (travelOptions.getMultiGraphSerializationDecimalPrecision() != null) {
                multiGraphSerialization.put("decimalPrecision", (Object)travelOptions.getMultiGraphSerializationDecimalPrecision());
            }
            if (travelOptions.getMultiGraphSerializationMaxGeometryCount() != null) {
                multiGraphSerialization.put("maxGeometryCount", (Object)travelOptions.getMultiGraphSerializationMaxGeometryCount());
            }
            multiGraph.put("serialization", (Object)multiGraphSerialization);
        }
    }

    private static void addMultiGraphAggregation(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (Stream.of(new Object[]{travelOptions.getMultiGraphAggregationType(), travelOptions.getMultiGraphAggregationIgnoreOutliers(), travelOptions.getMultiGraphAggregationOutlierPenalty(), travelOptions.getMultiGraphAggregationMinSourcesCount(), travelOptions.getMultiGraphAggregationSourceValuesLowerBound(), travelOptions.getMultiGraphAggregationSourceValuesUpperBound(), travelOptions.getMultiGraphAggregationMinSourcesRatio(), travelOptions.getMultiGraphAggregationMaxResultValue(), travelOptions.getMultiGraphAggregationMaxResultValueRatio(), travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins(), travelOptions.getMultiGraphAggregationGravitationExponent(), travelOptions.getMultiGraphAggregationProbabilityDecay(), travelOptions.getMultiGraphAggregationLogitBetaAttractionStrength(), travelOptions.getMultiGraphAggregationLogitBetaTravelTime(), travelOptions.getMultiGraphAggregationPostAggregationFactor()}).anyMatch(Objects::nonNull)) {
            JSONObject multiGraphAggregation = new JSONObject();
            AggregationConfiguration aggregationConfiguration = new AggregationConfiguration.AggregationConfigurationBuilder(travelOptions, false).build();
            RequestConfigurator.fillJsonAggregationConfig(aggregationConfiguration, multiGraphAggregation);
            multiGraph.put("aggregation", (Object)multiGraphAggregation);
        }
    }

    private static void addMultiGraphPreAggregationPipeline(TravelOptions travelOptions, JSONObject multiGraph) throws JSONException {
        if (travelOptions.getMultiGraphPreAggregationPipeline() != null) {
            LinkedHashMap<String, JSONObject> preAggregationPipelineMap = new LinkedHashMap<String, JSONObject>();
            for (Map.Entry<String, AggregationConfiguration> entry : travelOptions.getMultiGraphPreAggregationPipeline().entrySet()) {
                String aggregationName = entry.getKey();
                AggregationConfiguration aggregationConfiguration = entry.getValue();
                JSONObject multiGraphAggregation = new JSONObject();
                RequestConfigurator.fillJsonAggregationConfig(aggregationConfiguration, multiGraphAggregation);
                preAggregationPipelineMap.put(aggregationName, multiGraphAggregation);
            }
            multiGraph.put("preAggregationPipeline", preAggregationPipelineMap);
        }
    }

    private static void fillJsonAggregationConfig(AggregationConfiguration aggregationConfiguration, JSONObject multiGraphAggregation) throws JSONException {
        if (aggregationConfiguration.getType() != null) {
            multiGraphAggregation.put("type", (Object)aggregationConfiguration.getType().getKey());
        }
        if (aggregationConfiguration.getIgnoreOutliers() != null) {
            multiGraphAggregation.put("ignoreOutliers", (Object)aggregationConfiguration.getIgnoreOutliers());
        }
        if (aggregationConfiguration.getOutlierPenalty() != null) {
            multiGraphAggregation.put("outlierPenalty", (Object)aggregationConfiguration.getOutlierPenalty());
        }
        if (aggregationConfiguration.getMinSourcesRatio() != null) {
            multiGraphAggregation.put("minSourcesRatio", (Object)aggregationConfiguration.getMinSourcesRatio());
        }
        if (aggregationConfiguration.getMinSourcesCount() != null) {
            multiGraphAggregation.put("minSourcesCount", (Object)aggregationConfiguration.getMinSourcesCount());
        }
        if (aggregationConfiguration.getSourceValuesLowerBound() != null) {
            multiGraphAggregation.put("sourceValuesLowerBound", (Object)aggregationConfiguration.getSourceValuesLowerBound());
        }
        if (aggregationConfiguration.getSourceValuesUpperBound() != null) {
            multiGraphAggregation.put("sourceValuesUpperBound", (Object)aggregationConfiguration.getSourceValuesUpperBound());
        }
        if (aggregationConfiguration.getMinResultValueRatio() != null) {
            multiGraphAggregation.put("minResultValueRatio", (Object)aggregationConfiguration.getMinResultValueRatio());
        }
        if (aggregationConfiguration.getMinResultValue() != null) {
            multiGraphAggregation.put("minResultValue", (Object)aggregationConfiguration.getMinResultValue());
        }
        if (aggregationConfiguration.getMaxResultValueRatio() != null) {
            multiGraphAggregation.put("maxResultValueRatio", (Object)aggregationConfiguration.getMaxResultValueRatio());
        }
        if (aggregationConfiguration.getMaxResultValue() != null) {
            multiGraphAggregation.put("maxResultValue", (Object)aggregationConfiguration.getMaxResultValue());
        }
        if (aggregationConfiguration.getPostAggregationFactor() != null) {
            multiGraphAggregation.put("postAggregationFactor", (Object)aggregationConfiguration.getPostAggregationFactor());
        }
        if (aggregationConfiguration.getGravitationExponent() != null) {
            multiGraphAggregation.put("gravitationExponent", (Object)aggregationConfiguration.getGravitationExponent());
        }
        if (aggregationConfiguration.getProbabilityDecay() != null) {
            multiGraphAggregation.put("probabilityDecay", (Object)aggregationConfiguration.getProbabilityDecay());
        }
        if (aggregationConfiguration.getLogitBetaAttractionStrength() != null) {
            multiGraphAggregation.put("logitBetaAttractionStrength", (Object)aggregationConfiguration.getLogitBetaAttractionStrength());
        }
        if (aggregationConfiguration.getLogitBetaTravelTime() != null) {
            multiGraphAggregation.put("logitBetaTravelTime", (Object)aggregationConfiguration.getLogitBetaTravelTime());
        }
        if (aggregationConfiguration.getFilterValuesForSourceOrigins() != null) {
            multiGraphAggregation.put("filterValuesForSourceOrigins", aggregationConfiguration.getFilterValuesForSourceOrigins());
        }
        if (aggregationConfiguration.getAggregationInputParameters() != null) {
            multiGraphAggregation.put("aggregationInputParameters", (Object)RequestConfigurator.buildAggregationInputParameters(aggregationConfiguration.getAggregationInputParameters()));
        }
        if (aggregationConfiguration.getMathExpression() != null) {
            multiGraphAggregation.put("mathExpression", (Object)aggregationConfiguration.getMathExpression());
        }
    }

    private static JSONObject buildAggregationInputParameters(Map<String, AggregationInputParameters> aggregationInputParameters) throws JSONException {
        JSONObject aggregationInputParams = new JSONObject();
        if (aggregationInputParameters != null) {
            for (Map.Entry<String, AggregationInputParameters> entry : aggregationInputParameters.entrySet()) {
                String name = entry.getKey();
                AggregationInputParameters param = entry.getValue();
                JSONObject sourceParam = new JSONObject();
                if (param.getInputFactor() != null) {
                    sourceParam.put("inputFactor", (Object)param.getInputFactor());
                }
                if (param.getGravitationAttractionStrength() != null) {
                    sourceParam.put("gravitationAttractionStrength", (Object)param.getGravitationAttractionStrength());
                }
                if (param.getGravitationPositiveInfluence() != null) {
                    sourceParam.put("gravitationPositiveInfluence", (Object)param.getGravitationPositiveInfluence());
                }
                if (param.getGravitationCompetingPositiveInfluence() != null) {
                    sourceParam.put("gravitationCompetingPositiveInfluence", (Object)param.getGravitationCompetingPositiveInfluence());
                }
                aggregationInputParams.put(name, (Object)sourceParam);
            }
        }
        return aggregationInputParams;
    }

    private static JSONArray getSources(TravelOptions travelOptions) throws JSONException {
        JSONArray sources = new JSONArray();
        for (Coordinate src : travelOptions.getSources().values()) {
            JSONObject source = RequestConfigurator.getSourceObject(travelOptions, src);
            sources.put((Object)source);
        }
        return sources;
    }

    private static JSONArray getSourceGeometries(TravelOptions travelOptions) throws JSONException {
        JSONArray sourceGeometries = new JSONArray();
        for (AbstractGeometry src : travelOptions.getSourceGeometries().values()) {
            JSONObject source = RequestConfigurator.getSourceObject(travelOptions, src);
            sourceGeometries.put((Object)source);
        }
        return sourceGeometries;
    }

    private static StringBuilder getTargets(TravelOptions travelOptions) {
        StringBuilder targetsBuilder = new StringBuilder().append("[");
        for (Coordinate trg : travelOptions.getTargets().values()) {
            RequestConfigurator.buildTarget(targetsBuilder, trg).append(",");
        }
        targetsBuilder.deleteCharAt(targetsBuilder.length() - 1);
        targetsBuilder.append("]");
        return targetsBuilder;
    }

    private static StringBuilder buildTarget(StringBuilder targetsBuilder, Coordinate trg) {
        JSONBuilder.beginJson(targetsBuilder);
        JSONBuilder.appendString(targetsBuilder, "id", trg.getId());
        JSONBuilder.append(targetsBuilder, "lat", trg.getY());
        JSONBuilder.appendAndEnd(targetsBuilder, "lng", trg.getX());
        return targetsBuilder;
    }

    private static JSONObject getTravelMode(TravelOptions travelOptions, TravelType travelType) throws JSONException {
        JSONObject travelMode = new JSONObject();
        if (travelOptions.getTrafficJunctionPenalty() != null) {
            travelMode.put("trafficJunctionPenalty", (Object)travelOptions.getTrafficJunctionPenalty());
        }
        if (travelOptions.getTrafficSignalPenalty() != null) {
            travelMode.put("trafficSignalPenalty", (Object)travelOptions.getTrafficSignalPenalty());
        }
        if (travelOptions.getTrafficLeftTurnPenalty() != null) {
            travelMode.put("trafficLeftTurnPenalty", (Object)travelOptions.getTrafficLeftTurnPenalty());
        }
        if (travelOptions.getTrafficRightTurnPenalty() != null) {
            travelMode.put("trafficRightTurnPenalty", (Object)travelOptions.getTrafficRightTurnPenalty());
        }
        switch (travelType) {
            case WALKTRANSIT: 
            case TRANSIT: {
                travelMode.put("frame", (Object)new JSONObject().put("time", (Object)travelOptions.getTime()).put("date", (Object)travelOptions.getDate()).put("duration", (Object)travelOptions.getFrame()).put("earliestArrival", (Object)travelOptions.getEarliestArrival()));
                if (travelOptions.getMaxTransfers() != null && travelOptions.getMaxTransfers() >= 0) {
                    travelMode.put("maxTransfers", (Object)travelOptions.getMaxTransfers());
                }
                if (travelOptions.getMaxWalkingTimeFromSource() != null && travelOptions.getMaxWalkingTimeFromSource() >= 0) {
                    travelMode.put("maxWalkingTimeFromSource", (Object)travelOptions.getMaxWalkingTimeFromSource());
                }
                if (travelOptions.getMaxWalkingTimeToTarget() != null && travelOptions.getMaxWalkingTimeToTarget() >= 0) {
                    travelMode.put("maxWalkingTimeToTarget", (Object)travelOptions.getMaxWalkingTimeToTarget());
                }
                if (travelOptions.getAvoidTransitRouteTypes() != null && !travelOptions.getAvoidTransitRouteTypes().isEmpty()) {
                    travelMode.put("avoidTransitRouteTypes", travelOptions.getAvoidTransitRouteTypes());
                }
                travelMode.put("recommendations", travelOptions.getRecommendations());
                travelMode.put("speed", travelOptions.getWalkSpeed());
                travelMode.put("uphill", travelOptions.getWalkUphill());
                travelMode.put("downhill", travelOptions.getWalkDownhill());
                break;
            }
            case WALK: {
                travelMode.put("speed", travelOptions.getWalkSpeed());
                travelMode.put("uphill", travelOptions.getWalkUphill());
                travelMode.put("downhill", travelOptions.getWalkDownhill());
                break;
            }
            case BIKE: {
                travelMode.put("speed", travelOptions.getBikeSpeed());
                travelMode.put("uphill", travelOptions.getBikeUphill());
                travelMode.put("downhill", travelOptions.getBikeDownhill());
                break;
            }
            case CAR: {
                travelMode.put("rushHour", travelOptions.getRushHour());
                if (travelOptions.getDate() != null) {
                    travelMode.put("date", (Object)travelOptions.getDate());
                }
                if (travelOptions.getTime() == null) break;
                travelMode.put("time", (Object)travelOptions.getTime());
                break;
            }
        }
        if (travelOptions.getIncludeSnapDistance() != null) {
            travelMode.put("includeSnapDistance", (Object)travelOptions.getIncludeSnapDistance());
        }
        if (travelOptions.getUseAreaSnapping() != null) {
            travelMode.put("useAreaSnapping", (Object)travelOptions.getUseAreaSnapping());
        }
        if (travelOptions.getUseAreaSnapping() != null) {
            travelMode.put("snapRadius", (Object)travelOptions.getSnapRadius());
        }
        if (travelOptions.getExcludeEdgeClassesFromSnapping() != null) {
            travelMode.put("excludeEdgeClassesFromSnapping", (Object)new JSONArray(travelOptions.getExcludeEdgeClassesFromSnapping()));
        }
        return travelMode;
    }

    private static TravelType getTravelType(TravelOptions travelOptions, com.targomo.client.api.geo.Location src) {
        TravelType travelType = travelOptions.getTravelType();
        if (src.getTravelType() != null && src.getTravelType() != travelType && src.getTravelType() != TravelType.UNSPECIFIED) {
            travelType = src.getTravelType();
        }
        return travelType;
    }

    private static JSONObject getSourceObject(TravelOptions travelOptions, com.targomo.client.api.geo.Location src) throws JSONException {
        TravelType travelType = RequestConfigurator.getTravelType(travelOptions, src);
        JSONObject travelMode = RequestConfigurator.getTravelMode(travelOptions, travelType);
        JSONObject source = new JSONObject().put("id", (Object)src.getId());
        if (src instanceof Coordinate) {
            Coordinate coordinate = (Coordinate)src;
            source.put("lat", coordinate.getY()).put("lng", coordinate.getX());
        } else if (src instanceof AbstractGeometry) {
            AbstractGeometry geometry = (AbstractGeometry)src;
            source.put("crs", (Object)geometry.getCrs()).put("data", (Object)geometry.getData()).put("routeFromCentroid", geometry.isRouteFromCentroid());
        }
        source.put("tm", (Object)new JSONObject().put(travelType.toString(), (Object)travelMode));
        if (src.getProperties() != null) {
            source.put("properties", (Object)new JSONObject().put("inputFactor", (Object)src.getProperties().getInputFactor()).put("gravitationAttractionStrength", (Object)src.getProperties().getGravitationAttractionStrength()).put("gravitationPositiveInfluence", (Object)src.getProperties().getGravitationPositiveInfluence()));
        }
        if (travelOptions.getReverse() != null) {
            source.put("reverse", (Object)travelOptions.getReverse());
        }
        return source;
    }
}

