/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.targomo.client.api.enums.EdgeWeightType;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.enums.MultiGraphAggregationType;
import com.targomo.client.api.enums.MultiGraphDomainEdgeAggregationType;
import com.targomo.client.api.enums.MultiGraphDomainType;
import com.targomo.client.api.enums.MultiGraphLayerCustomGeometryMergeAggregation;
import com.targomo.client.api.enums.MultiGraphLayerType;
import com.targomo.client.api.enums.MultiGraphSerializationFormat;
import com.targomo.client.api.enums.PathSerializerType;
import com.targomo.client.api.enums.PolygonIntersectionMode;
import com.targomo.client.api.enums.PolygonOrientationRule;
import com.targomo.client.api.enums.PolygonSerializerType;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractGeometry;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.geo.DefaultSourceGeometry;
import com.targomo.client.api.geo.DefaultTargetCoordinate;
import com.targomo.client.api.json.DefaultSourceCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultSourceCoordinateMapSerializer;
import com.targomo.client.api.json.DefaultSourceGeometriesMapDeserializer;
import com.targomo.client.api.json.DefaultSourceGeometriesMapSerializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultTargetCoordinateMapSerializer;
import com.targomo.client.api.pojo.AggregationConfiguration;
import com.targomo.client.api.pojo.AggregationInputParameters;
import com.targomo.client.api.pojo.Geometry;
import com.targomo.client.api.statistic.PoiType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="travel_option")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TravelOptions
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private Integer id;
    @JsonDeserialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> sources = new HashMap<String, Coordinate>();
    @JsonDeserialize(contentAs=DefaultSourceGeometry.class, using=DefaultSourceGeometriesMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceGeometry.class, using=DefaultSourceGeometriesMapSerializer.class)
    @Transient
    private Map<String, AbstractGeometry> sourceGeometries = new HashMap<String, AbstractGeometry>();
    @JsonDeserialize(contentAs=DefaultTargetCoordinate.class, using=DefaultTargetCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultTargetCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> targets = new HashMap<String, Coordinate>();
    @Transient
    private List<String> targetGeohashes = new ArrayList<String>();
    @Column(name="bike_speed")
    private double bikeSpeed = 15.0;
    @Column(name="bike_uphill")
    private double bikeUphill = 20.0;
    @Column(name="bike_downhill")
    private double bikeDownhill = -10.0;
    @Column(name="walk_speed")
    private double walkSpeed = 5.0;
    @Column(name="walk_uphill")
    private double walkUphill = 10.0;
    @Column(name="walk_downhill")
    private double walkDownhill = 0.0;
    @Column(name="rush_hour")
    private Boolean rushHour = false;
    @Transient
    private Integer trafficJunctionPenalty = null;
    @Transient
    private Integer trafficSignalPenalty = null;
    @Transient
    private Integer trafficLeftTurnPenalty = null;
    @Transient
    private Integer trafficRightTurnPenalty = null;
    @Transient
    private List<Integer> travelTimes = Arrays.asList(600, 1200, 1800);
    @Column(name="travel_type")
    private TravelType travelType = TravelType.UNSPECIFIED;
    @Transient
    private Map<String, Double> travelTimeFactors = new HashMap<String, Double>();
    @Column(name="elevation_enabled")
    private Boolean elevationEnabled = true;
    @Transient
    private Boolean appendTravelTimes = false;
    @Transient
    private Boolean pointReduction = true;
    @Transient
    private Boolean reverse = false;
    @Transient
    private Long minPolygonHoleSize = 100000000L;
    @Column(name="time")
    private Integer time = null;
    @Column(name="date")
    private Integer date = null;
    @Column(name="frame")
    private Integer frame = null;
    @Column(name="earliestArrival")
    private Boolean earliestArrival = false;
    @Transient
    private Integer maxWalkingTimeFromSource = null;
    @Transient
    private Integer maxWalkingTimeToTarget = null;
    @Transient
    private Integer recommendations = 0;
    @Transient
    private Integer srid = null;
    @Transient
    private PolygonOrientationRule polygonOrientationRule = null;
    @Transient
    private Integer decimalPrecision = null;
    @Column(name="max_transfers")
    private Integer maxTransfers = null;
    @Transient
    private List<Integer> avoidTransitRouteTypes = Collections.emptyList();
    @Transient
    private Double buffer = null;
    @Transient
    private Double simplify = null;
    @Transient
    private Integer quadrantSegments = null;
    @Transient
    private PolygonIntersectionMode intersectionMode = PolygonIntersectionMode.UNION;
    @Transient
    private PathSerializerType pathSerializer = PathSerializerType.COMPACT_PATH_SERIALIZER;
    @Transient
    private PolygonSerializerType polygonSerializerType = PolygonSerializerType.JSON_POLYGON_SERIALIZER;
    @Transient
    private Integer maxSnapDistance = null;
    @Transient
    private Set<Integer> multiGraphEdgeClasses = null;
    @Transient
    private MultiGraphDomainType multiGraphDomainType = null;
    @Transient
    private MultiGraphDomainEdgeAggregationType multiGraphDomainEdgeAggregationType = null;
    @Transient
    private MultiGraphSerializationFormat multiGraphSerializationFormat = null;
    @Transient
    private Integer multiGraphSerializationDecimalPrecision = null;
    @Transient
    private Integer multiGraphSerializationMaxGeometryCount = null;
    @Transient
    private MultiGraphAggregationType multiGraphAggregationType = null;
    @Transient
    private Boolean multiGraphAggregationIgnoreOutliers = null;
    @Transient
    private Float multiGraphAggregationOutlierPenalty = null;
    @Transient
    private Double multiGraphAggregationMinSourcesRatio = null;
    @Transient
    private Integer multiGraphAggregationMinSourcesCount = null;
    @Transient
    private Float multiGraphAggregationSourceValuesLowerBound = null;
    @Transient
    private Float multiGraphAggregationSourceValuesUpperBound = null;
    @Transient
    private Double multiGraphAggregationMinResultValueRatio = null;
    @Transient
    private Float multiGraphAggregationMinResultValue = null;
    @Transient
    private Double multiGraphAggregationMaxResultValueRatio = null;
    @Transient
    private Float multiGraphAggregationMaxResultValue = null;
    @Transient
    private String multiGraphAggregationMathExpression = null;
    @Transient
    private Set<String> multiGraphAggregationFilterValuesForSourceOrigins = null;
    @Transient
    private Double multiGraphAggregationGravitationExponent = null;
    @Transient
    private Double multiGraphAggregationProbabilityDecay = null;
    @Transient
    private Double multiGraphAggregationLogitBetaAttractionStrength = null;
    @Transient
    private Double multiGraphAggregationLogitBetaTravelTime = null;
    @Transient
    private Float multiGraphAggregationPostAggregationFactor = null;
    @Transient
    private Map<String, AggregationInputParameters> multiGraphAggregationInputParameters = null;
    @Transient
    private LinkedHashMap<String, AggregationConfiguration> multiGraphPreAggregationPipeline = null;
    @Transient
    private MultiGraphLayerType multiGraphLayerType = null;
    @Transient
    private Integer multiGraphLayerGeometryDetailPerTile = null;
    @Transient
    private Integer multiGraphLayerMinGeometryDetailLevel = null;
    @Transient
    private Integer multiGraphLayerMaxGeometryDetailLevel = null;
    @Transient
    private Integer multiGraphLayerGeometryDetailLevel = null;
    @Transient
    private MultiGraphLayerCustomGeometryMergeAggregation multiGraphLayerCustomGeometryMergeAggregation = null;
    @Transient
    private Integer multiGraphTileZoom = null;
    @Transient
    private Integer multiGraphTileX = null;
    @Transient
    private Integer multiGraphTileY = null;
    @Transient
    private Geometry clipGeometry = null;
    @Column(name="max_edge_weight")
    private Integer maxEdgeWeight = 1800;
    @Column(name="service_url")
    private String serviceUrl = "";
    @Column(name="fallback_service_url")
    private String fallbackServiceUrl = "";
    @Column(name="service_key")
    private String serviceKey = "";
    @Transient
    private boolean onlyPrintReachablePoints = true;
    @JsonProperty(value="edgeWeight")
    @Column(name="edge_weight_type")
    private EdgeWeightType edgeWeightType = EdgeWeightType.TIME;
    @Column(name="statistic_group_id")
    private Integer statisticGroupId;
    @Column(name="statistic_service_url")
    private String statisticServiceUrl = "https://api.targomo.com/statistics/";
    @Column(name="poi_service_url")
    private String pointOfInterestServiceUrl = "https://api.targomo.com/pointofinterest/";
    @Column(name="overpass_query")
    private String overpassQuery;
    @Column(name="overpass_service_url")
    private String overpassServiceUrl = "https://api.targomo.com/overpass/";
    @Column(name="inter_service_key")
    private String interServiceKey = "";
    @Transient
    private String interServiceRequestType = "";
    @Transient
    private Format format;
    @Transient
    private Geometry intersectionGeometry;
    @Transient
    private Geometry exclusionGeometry;
    @Transient
    private String boundingBox;
    @Transient
    private Set<TravelType> travelTypes = new HashSet<TravelType>();
    @Transient
    private Set<PoiType> osmTypes = new HashSet<PoiType>();
    @Transient
    private Set<PoiType> customPois = new HashSet<PoiType>();
    @Transient
    @JsonProperty(value="filterGeometry")
    private AbstractGeometry filterGeometryForPOIs;
    @Transient
    @JsonProperty(value="gravitationExponent")
    private Double poiGravitationExponent;
    @Transient
    @JsonProperty(value="probabilityDecay")
    private Double poiGravitationProbabilityDecay;
    @Transient
    private boolean forceRecalculate = false;
    @Transient
    private boolean cacheResult = true;
    @Transient
    private Integer nextStopsStartTime;
    @Transient
    private Integer nextStopsEndTime;
    @Transient
    private Boolean includeSnapDistance;
    @Transient
    private Boolean useAreaSnapping;
    @Transient
    private Integer snapRadius;
    @Transient
    private List<Integer> excludeEdgeClassesFromSnapping;

    public String getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(String boundingBox) {
        this.boundingBox = boundingBox;
    }

    public Set<PoiType> getCustomPois() {
        return this.customPois;
    }

    public void setCustomPois(Set<PoiType> customPois) {
        this.customPois = customPois;
    }

    public Set<TravelType> getTravelTypes() {
        return this.travelTypes;
    }

    public void setTravelTypes(Set<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    public Set<PoiType> getOsmTypes() {
        return this.osmTypes;
    }

    public void setOsmTypes(Set<PoiType> osmTypes) {
        this.osmTypes = osmTypes;
    }

    public AbstractGeometry getFilterGeometryForPOIs() {
        return this.filterGeometryForPOIs;
    }

    public void setFilterGeometryForPOIs(AbstractGeometry geometry) {
        this.filterGeometryForPOIs = geometry;
    }

    public Double getPoiGravitationExponent() {
        return this.poiGravitationExponent;
    }

    public void setPoiGravitationExponent(Double poiGravitationExponent) {
        this.poiGravitationExponent = poiGravitationExponent;
    }

    public Double getPoiGravitationProbabilityDecay() {
        return this.poiGravitationProbabilityDecay;
    }

    public void setPoiGravitationProbabilityDecay(Double poiGravitationProbabilityDecay) {
        this.poiGravitationProbabilityDecay = poiGravitationProbabilityDecay;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonIgnore
    public double[][] getSourceCoordinates() {
        return this.getCoordinates(this.sources);
    }

    @JsonIgnore
    public double[][] getTargetCoordinates() {
        return this.getCoordinates(this.targets);
    }

    private double[][] getCoordinates(Map<String, Coordinate> points) {
        Coordinate[] pointList = points.values().toArray(new Coordinate[0]);
        double[][] coordinates = new double[points.size()][];
        for (int i = 0; i < points.size(); ++i) {
            coordinates[i] = new double[]{pointList[i].getX(), pointList[i].getY()};
        }
        return coordinates;
    }

    public Map<String, Coordinate> getSources() {
        return this.sources;
    }

    public Map<String, AbstractGeometry> getSourceGeometries() {
        return this.sourceGeometries;
    }

    public void setSources(Map<String, Coordinate> sources) {
        this.sources = sources;
    }

    public void setSourceGeometries(Map<String, AbstractGeometry> sourceGeometries) {
        this.sourceGeometries = sourceGeometries;
    }

    public Map<String, Coordinate> getTargets() {
        return this.targets;
    }

    public List<String> getTargetGeohashes() {
        return this.targetGeohashes;
    }

    public void setTargets(Map<String, Coordinate> targets) {
        this.targets = targets;
    }

    public void setTargetGeohashes(List<String> targetGeohashes) {
        this.targetGeohashes = targetGeohashes;
    }

    public void addAllTargets(Map<String, Coordinate> targets) {
        this.targets.putAll(targets);
    }

    public void addAllTargets(Collection<Coordinate> targets) {
        this.targets = targets.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity()));
    }

    public void addAllTargetGeohashes(List<String> geohashes) {
        this.targetGeohashes.addAll(geohashes);
    }

    public double getBikeSpeed() {
        return this.bikeSpeed;
    }

    public void setBikeSpeed(double bikeSpeed) {
        this.bikeSpeed = bikeSpeed;
    }

    public double getBikeUphill() {
        return this.bikeUphill;
    }

    public void setBikeUphill(double bikeUphill) {
        this.bikeUphill = bikeUphill;
    }

    public double getBikeDownhill() {
        return this.bikeDownhill;
    }

    public void setBikeDownhill(double bikeDownhill) {
        this.bikeDownhill = bikeDownhill;
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public double getWalkUphill() {
        return this.walkUphill;
    }

    public void setWalkUphill(double walkUphill) {
        this.walkUphill = walkUphill;
    }

    public double getWalkDownhill() {
        return this.walkDownhill;
    }

    public void setWalkDownhill(double walkDownhill) {
        this.walkDownhill = walkDownhill;
    }

    public void setRushHour(boolean rushHourEnabled) {
        this.rushHour = rushHourEnabled;
    }

    public boolean getRushHour() {
        return this.rushHour;
    }

    public List<Integer> getTravelTimes() {
        return this.travelTimes;
    }

    public void setTravelTimes(List<Integer> travelTimes) {
        this.travelTimes = travelTimes;
    }

    public TravelType getTravelType() {
        return this.travelType;
    }

    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    public Boolean isElevationEnabled() {
        return this.elevationEnabled;
    }

    public void setElevationEnabled(Boolean elevationEnabled) {
        this.elevationEnabled = elevationEnabled;
    }

    public long getMinPolygonHoleSize() {
        return this.minPolygonHoleSize;
    }

    public void setMinPolygonHoleSize(long minPolygonHoleSize) {
        this.minPolygonHoleSize = minPolygonHoleSize;
    }

    public Integer getTime() {
        return this.time;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public Integer getDate() {
        return this.date;
    }

    public void setDate(Integer date) {
        this.date = date;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public void setFrame(Integer frame) {
        this.frame = frame;
    }

    public Boolean getEarliestArrival() {
        return this.earliestArrival;
    }

    public void setEarliestArrival(Boolean earliestArrival) {
        this.earliestArrival = earliestArrival;
    }

    public Integer getMaxWalkingTimeFromSource() {
        return this.maxWalkingTimeFromSource;
    }

    public void setMaxWalkingTimeFromSource(Integer maxWalkingTimeFromSource) {
        this.maxWalkingTimeFromSource = maxWalkingTimeFromSource;
    }

    public Integer getMaxWalkingTimeToTarget() {
        return this.maxWalkingTimeToTarget;
    }

    public void setMaxWalkingTimeToTarget(Integer maxWalkingTimeToTarget) {
        this.maxWalkingTimeToTarget = maxWalkingTimeToTarget;
    }

    public int getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(int recommendations) {
        this.recommendations = recommendations;
    }

    public PolygonIntersectionMode getIntersectionMode() {
        return this.intersectionMode;
    }

    public void setIntersectionMode(PolygonIntersectionMode intersectionMode) {
        this.intersectionMode = intersectionMode;
    }

    public PathSerializerType getPathSerializer() {
        return this.pathSerializer;
    }

    public void setPathSerializer(PathSerializerType pathSerializer) {
        this.pathSerializer = pathSerializer;
    }

    public PolygonSerializerType getPolygonSerializerType() {
        return this.polygonSerializerType;
    }

    public void setPolygonSerializerType(PolygonSerializerType polygonSerializerType) {
        this.polygonSerializerType = polygonSerializerType;
    }

    public Integer getMaxSnapDistance() {
        return this.maxSnapDistance;
    }

    public void setMaxSnapDistance(Integer maxSnapDistance) {
        this.maxSnapDistance = maxSnapDistance;
    }

    public boolean isPointReduction() {
        return this.pointReduction;
    }

    public void setPointReduction(boolean pointReduction) {
        this.pointReduction = pointReduction;
    }

    @JsonIgnore
    @Deprecated
    public int getMaxRoutingTime() {
        if (this.edgeWeightType == EdgeWeightType.TIME) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingTime(int maxRoutingTime) {
        this.maxEdgeWeight = maxRoutingTime;
        this.edgeWeightType = EdgeWeightType.TIME;
    }

    @JsonIgnore
    @Deprecated
    public Integer getMaxRoutingLength() {
        if (this.edgeWeightType == EdgeWeightType.DISTANCE) {
            return this.maxEdgeWeight;
        }
        return 0;
    }

    @JsonIgnore
    @Deprecated
    public void setMaxRoutingLength(Integer maxRoutingLength) {
        this.maxEdgeWeight = maxRoutingLength;
        this.edgeWeightType = EdgeWeightType.DISTANCE;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void addSource(Coordinate source) {
        this.sources.put(source.getId(), source);
    }

    public void addSourceGeometry(AbstractGeometry source) {
        this.sourceGeometries.put(source.getId(), source);
    }

    public void addTarget(Coordinate target) {
        this.targets.put(target.getId(), target);
    }

    public void addTargetGeohash(String geoHash) {
        this.targetGeohashes.add(geoHash);
    }

    public Map<String, AggregationInputParameters> getMultiGraphAggregationInputParameters() {
        return this.multiGraphAggregationInputParameters;
    }

    public void setMultiGraphAggregationInputParameters(Map<String, AggregationInputParameters> multiGraphAggregationInputParameters) {
        this.multiGraphAggregationInputParameters = multiGraphAggregationInputParameters;
    }

    public LinkedHashMap<String, AggregationConfiguration> getMultiGraphPreAggregationPipeline() {
        return this.multiGraphPreAggregationPipeline;
    }

    public void setMultiGraphPreAggregationPipeline(LinkedHashMap<String, AggregationConfiguration> multiGraphPreAggregationPipeline) {
        this.multiGraphPreAggregationPipeline = multiGraphPreAggregationPipeline;
    }

    public String getMultiGraphAggregationMathExpression() {
        return this.multiGraphAggregationMathExpression;
    }

    public void setMultiGraphAggregationMathExpression(String multiGraphAggregationMathExpression) {
        this.multiGraphAggregationMathExpression = multiGraphAggregationMathExpression;
    }

    public MultiGraphLayerCustomGeometryMergeAggregation getMultiGraphLayerCustomGeometryMergeAggregation() {
        return this.multiGraphLayerCustomGeometryMergeAggregation;
    }

    public void setMultiGraphLayerCustomGeometryMergeAggregation(MultiGraphLayerCustomGeometryMergeAggregation multiGraphLayerCustomGeometryMergeAggregation) {
        this.multiGraphLayerCustomGeometryMergeAggregation = multiGraphLayerCustomGeometryMergeAggregation;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TravelOptions)) {
            return false;
        }
        TravelOptions that = (TravelOptions)o;
        return Double.compare(that.bikeSpeed, this.bikeSpeed) == 0 && Double.compare(that.bikeUphill, this.bikeUphill) == 0 && Double.compare(that.bikeDownhill, this.bikeDownhill) == 0 && Double.compare(that.walkSpeed, this.walkSpeed) == 0 && Double.compare(that.walkUphill, this.walkUphill) == 0 && Double.compare(that.walkDownhill, this.walkDownhill) == 0 && Objects.equals(that.trafficJunctionPenalty, this.trafficJunctionPenalty) && Objects.equals(that.trafficSignalPenalty, this.trafficSignalPenalty) && Objects.equals(that.trafficLeftTurnPenalty, this.trafficLeftTurnPenalty) && Objects.equals(that.trafficRightTurnPenalty, this.trafficRightTurnPenalty) && this.onlyPrintReachablePoints == that.onlyPrintReachablePoints && Objects.equals(this.sources, that.sources) && Objects.equals(this.sourceGeometries, that.sourceGeometries) && Objects.equals(this.targets, that.targets) && Objects.equals(this.targetGeohashes, that.targetGeohashes) && Objects.equals(this.rushHour, that.rushHour) && Objects.equals(this.travelTimes, that.travelTimes) && this.travelType == that.travelType && Objects.equals(this.elevationEnabled, that.elevationEnabled) && Objects.equals(this.pointReduction, that.pointReduction) && Objects.equals(this.reverse, that.reverse) && Objects.equals(this.minPolygonHoleSize, that.minPolygonHoleSize) && Objects.equals(this.time, that.time) && Objects.equals(this.date, that.date) && Objects.equals(this.frame, that.frame) && Objects.equals(this.intersectionGeometry, that.intersectionGeometry) && Objects.equals(this.exclusionGeometry, that.exclusionGeometry) && Objects.equals(this.recommendations, that.recommendations) && Objects.equals(this.srid, that.srid) && Objects.equals((Object)this.polygonOrientationRule, (Object)that.polygonOrientationRule) && Objects.equals(this.decimalPrecision, that.decimalPrecision) && Objects.equals(this.buffer, that.buffer) && Objects.equals(this.simplify, that.simplify) && this.intersectionMode == that.intersectionMode && this.pathSerializer == that.pathSerializer && this.polygonSerializerType == that.polygonSerializerType && Objects.equals(this.maxSnapDistance, that.maxSnapDistance) && Objects.equals(this.multiGraphEdgeClasses, that.multiGraphEdgeClasses) && this.multiGraphSerializationFormat == that.multiGraphSerializationFormat && Objects.equals(this.multiGraphSerializationDecimalPrecision, that.multiGraphSerializationDecimalPrecision) && Objects.equals(this.multiGraphSerializationMaxGeometryCount, that.multiGraphSerializationMaxGeometryCount) && this.multiGraphAggregationType == that.multiGraphAggregationType && Objects.equals(this.multiGraphAggregationIgnoreOutliers, that.multiGraphAggregationIgnoreOutliers) && Objects.equals(this.multiGraphAggregationOutlierPenalty, that.multiGraphAggregationOutlierPenalty) && Objects.equals(this.multiGraphAggregationMinSourcesRatio, that.multiGraphAggregationMinSourcesRatio) && Objects.equals(this.multiGraphAggregationMinSourcesCount, that.multiGraphAggregationMinSourcesCount) && Objects.equals(this.multiGraphAggregationSourceValuesLowerBound, that.multiGraphAggregationSourceValuesLowerBound) && Objects.equals(this.multiGraphAggregationSourceValuesUpperBound, that.multiGraphAggregationSourceValuesUpperBound) && Objects.equals(this.multiGraphAggregationMinResultValueRatio, that.multiGraphAggregationMinResultValueRatio) && Objects.equals(this.multiGraphAggregationMinResultValue, that.multiGraphAggregationMinResultValue) && Objects.equals(this.multiGraphAggregationMaxResultValueRatio, that.multiGraphAggregationMaxResultValueRatio) && Objects.equals(this.multiGraphAggregationMaxResultValue, that.multiGraphAggregationMaxResultValue) && Objects.equals(this.multiGraphAggregationFilterValuesForSourceOrigins, that.multiGraphAggregationFilterValuesForSourceOrigins) && Objects.equals(this.multiGraphAggregationGravitationExponent, that.multiGraphAggregationGravitationExponent) && Objects.equals(this.multiGraphAggregationProbabilityDecay, that.multiGraphAggregationProbabilityDecay) && Objects.equals(this.multiGraphAggregationLogitBetaAttractionStrength, that.multiGraphAggregationLogitBetaAttractionStrength) && Objects.equals(this.multiGraphAggregationLogitBetaTravelTime, that.multiGraphAggregationLogitBetaTravelTime) && Objects.equals(this.multiGraphAggregationInputParameters, that.multiGraphAggregationInputParameters) && Objects.equals(this.multiGraphAggregationMathExpression, that.multiGraphAggregationMathExpression) && Objects.equals((Object)this.multiGraphLayerCustomGeometryMergeAggregation, (Object)that.multiGraphLayerCustomGeometryMergeAggregation) && Objects.equals(this.multiGraphAggregationPostAggregationFactor, that.multiGraphAggregationPostAggregationFactor) && this.multiGraphLayerType == that.multiGraphLayerType && Objects.equals((Object)this.multiGraphDomainType, (Object)that.multiGraphDomainType) && this.multiGraphDomainEdgeAggregationType == that.multiGraphDomainEdgeAggregationType && Objects.equals(this.multiGraphLayerGeometryDetailPerTile, that.multiGraphLayerGeometryDetailPerTile) && Objects.equals(this.multiGraphLayerMinGeometryDetailLevel, that.multiGraphLayerMinGeometryDetailLevel) && Objects.equals(this.multiGraphLayerMaxGeometryDetailLevel, that.multiGraphLayerMaxGeometryDetailLevel) && Objects.equals(this.multiGraphLayerGeometryDetailLevel, that.multiGraphLayerGeometryDetailLevel) && Objects.equals(this.multiGraphTileZoom, that.multiGraphTileZoom) && Objects.equals(this.multiGraphTileX, that.multiGraphTileX) && Objects.equals(this.multiGraphTileY, that.multiGraphTileY) && Objects.equals(this.clipGeometry, that.clipGeometry) && Objects.equals(this.maxEdgeWeight, that.maxEdgeWeight) && Objects.equals(this.serviceUrl, that.serviceUrl) && Objects.equals(this.fallbackServiceUrl, that.fallbackServiceUrl) && Objects.equals(this.serviceKey, that.serviceKey) && this.edgeWeightType == that.edgeWeightType && Objects.equals(this.statisticGroupId, that.statisticGroupId) && Objects.equals(this.statisticServiceUrl, that.statisticServiceUrl) && Objects.equals(this.pointOfInterestServiceUrl, that.pointOfInterestServiceUrl) && Objects.equals(this.overpassQuery, that.overpassQuery) && Objects.equals(this.overpassServiceUrl, that.overpassServiceUrl) && Objects.equals(this.interServiceKey, that.interServiceKey) && Objects.equals(this.interServiceRequestType, that.interServiceRequestType) && this.format == that.format && Objects.equals(this.boundingBox, that.boundingBox) && Objects.equals(this.travelTypes, that.travelTypes) && Objects.equals(this.osmTypes, that.osmTypes) && Objects.equals(this.customPois, that.customPois) && Objects.equals(this.filterGeometryForPOIs, that.filterGeometryForPOIs) && Objects.equals(this.poiGravitationExponent, that.poiGravitationExponent) && Objects.equals(this.poiGravitationProbabilityDecay, that.poiGravitationProbabilityDecay) && Objects.equals(this.travelTimeFactors, that.travelTimeFactors) && Objects.equals(this.maxTransfers, that.maxTransfers) && Objects.equals(this.avoidTransitRouteTypes, that.avoidTransitRouteTypes) && Objects.equals(this.multiGraphPreAggregationPipeline, that.multiGraphPreAggregationPipeline) && Objects.equals(this.maxWalkingTimeFromSource, that.maxWalkingTimeFromSource) && Objects.equals(this.maxWalkingTimeToTarget, that.maxWalkingTimeToTarget) && Objects.equals(this.nextStopsStartTime, that.nextStopsStartTime) && Objects.equals(this.nextStopsEndTime, that.nextStopsEndTime) && Objects.equals(this.includeSnapDistance, that.includeSnapDistance) && Objects.equals(this.useAreaSnapping, that.useAreaSnapping) && Objects.equals(this.snapRadius, that.snapRadius) && Objects.equals(this.excludeEdgeClassesFromSnapping, that.excludeEdgeClassesFromSnapping);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sources, this.sourceGeometries, this.targets, this.targetGeohashes, this.bikeSpeed, this.bikeUphill, this.bikeDownhill, this.walkSpeed, this.walkUphill, this.walkDownhill, this.rushHour, this.travelTimes, this.travelType, this.elevationEnabled, this.appendTravelTimes, this.pointReduction, this.reverse, this.minPolygonHoleSize, this.time, this.date, this.frame, this.recommendations, this.srid, this.polygonOrientationRule, this.decimalPrecision, this.buffer, this.simplify, this.intersectionMode, this.pathSerializer, this.polygonSerializerType, this.maxSnapDistance, this.intersectionGeometry, this.exclusionGeometry, this.multiGraphEdgeClasses, this.multiGraphSerializationFormat, this.multiGraphSerializationDecimalPrecision, this.multiGraphSerializationMaxGeometryCount, this.multiGraphAggregationType, this.multiGraphAggregationIgnoreOutliers, this.multiGraphAggregationOutlierPenalty, this.multiGraphAggregationMinSourcesRatio, this.multiGraphAggregationMinSourcesCount, this.multiGraphAggregationSourceValuesLowerBound, this.multiGraphAggregationSourceValuesUpperBound, this.multiGraphAggregationMinResultValueRatio, this.multiGraphAggregationMinResultValue, this.multiGraphAggregationMaxResultValueRatio, this.multiGraphAggregationMaxResultValue, this.multiGraphAggregationGravitationExponent, this.multiGraphAggregationProbabilityDecay, this.multiGraphAggregationLogitBetaAttractionStrength, this.multiGraphAggregationLogitBetaTravelTime, this.multiGraphLayerCustomGeometryMergeAggregation, this.multiGraphAggregationInputParameters, this.multiGraphAggregationFilterValuesForSourceOrigins, this.multiGraphPreAggregationPipeline, this.multiGraphAggregationMathExpression, this.multiGraphLayerType, this.multiGraphDomainType, this.multiGraphDomainEdgeAggregationType, this.multiGraphLayerGeometryDetailPerTile, this.multiGraphLayerMinGeometryDetailLevel, this.multiGraphLayerMaxGeometryDetailLevel, this.multiGraphLayerGeometryDetailLevel, this.multiGraphTileZoom, this.multiGraphTileX, this.multiGraphTileY, this.multiGraphAggregationPostAggregationFactor, this.clipGeometry, this.maxEdgeWeight, this.serviceUrl, this.fallbackServiceUrl, this.serviceKey, this.onlyPrintReachablePoints, this.edgeWeightType, this.statisticGroupId, this.statisticServiceUrl, this.pointOfInterestServiceUrl, this.overpassQuery, this.overpassServiceUrl, this.interServiceKey, this.interServiceRequestType, this.format, this.boundingBox, this.travelTypes, this.osmTypes, this.customPois, this.filterGeometryForPOIs, this.poiGravitationExponent, this.poiGravitationProbabilityDecay, this.travelTimeFactors, this.maxTransfers, this.avoidTransitRouteTypes, this.trafficJunctionPenalty, this.trafficSignalPenalty, this.trafficLeftTurnPenalty, this.trafficRightTurnPenalty, this.maxWalkingTimeFromSource, this.maxWalkingTimeToTarget, this.nextStopsStartTime, this.nextStopsEndTime, this.includeSnapDistance, this.useAreaSnapping, this.snapRadius, this.excludeEdgeClassesFromSnapping});
    }

    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("\n\tid: ");
        builder.append(this.id);
        builder.append("\n\tforceRecalculate: ");
        builder.append(this.forceRecalculate);
        builder.append("\n\tcacheResult: ");
        builder.append(this.cacheResult);
        builder.append("\n\tintersectionGeometry: ");
        builder.append(this.intersectionGeometry != null ? this.intersectionGeometry.toString() : null);
        builder.append("\n\texclusionGeometry: ");
        builder.append(this.exclusionGeometry != null ? this.exclusionGeometry.toString() : null);
        builder.append(" {\n\tsources: ");
        builder.append(this.sources != null ? this.toString(this.sources.entrySet(), 5) : null);
        builder.append(" {\n\tsourceGeometries: ");
        builder.append(this.sourceGeometries != null ? this.toString(this.sourceGeometries.entrySet(), 5) : null);
        builder.append("\n\ttargets: ");
        builder.append(this.targets != null ? this.toString(this.targets.entrySet(), 5) : null);
        builder.append("\n\ttargetGeohashes: ");
        builder.append(this.targetGeohashes != null ? this.toString(this.targetGeohashes, 5) : null);
        builder.append("\n\tbikeSpeed: ");
        builder.append(this.bikeSpeed);
        builder.append("\n\tbikeUphill: ");
        builder.append(this.bikeUphill);
        builder.append("\n\tbikeDownhill: ");
        builder.append(this.bikeDownhill);
        builder.append("\n\twalkSpeed: ");
        builder.append(this.walkSpeed);
        builder.append("\n\twalkUphill: ");
        builder.append(this.walkUphill);
        builder.append("\n\twalkDownhill: ");
        builder.append(this.walkDownhill);
        builder.append("\n\ttrafficJunctionPenalty: ");
        builder.append(this.trafficJunctionPenalty);
        builder.append("\n\ttrafficSignalPenalty: ");
        builder.append(this.trafficSignalPenalty);
        builder.append("\n\ttrafficLeftTurnPenalty: ");
        builder.append(this.trafficLeftTurnPenalty);
        builder.append("\n\ttrafficRightTurnPenalty: ");
        builder.append(this.trafficRightTurnPenalty);
        builder.append("\n\trushHour: ");
        builder.append(this.rushHour);
        builder.append("\n\ttravelTimes: ");
        builder.append(this.travelTimes != null ? this.toString(this.travelTimes, 5) : null);
        builder.append("\n\ttravelType: ");
        builder.append((Object)this.travelType);
        builder.append("\n\televationEnabled: ");
        builder.append(this.elevationEnabled);
        builder.append("\n\tappendTravelTimes: ");
        builder.append(this.appendTravelTimes);
        builder.append("\n\tpointReduction: ");
        builder.append(this.pointReduction);
        builder.append("\n\treverse: ");
        builder.append(this.reverse);
        builder.append("\n\tminPolygonHoleSize: ");
        builder.append(this.minPolygonHoleSize);
        builder.append("\n\ttime: ");
        builder.append(this.time);
        builder.append("\n\tdate: ");
        builder.append(this.date);
        builder.append("\n\tframe: ");
        builder.append(this.frame);
        builder.append("\n\trecommendations: ");
        builder.append(this.recommendations);
        builder.append("\n\tsrid: ");
        builder.append(this.srid);
        builder.append("\n\tpolygonOrientationRule: ");
        builder.append((Object)this.polygonOrientationRule);
        builder.append("\n\tdecimalPrecision: ");
        builder.append(this.decimalPrecision);
        builder.append("\n\tbuffer: ");
        builder.append(this.buffer);
        builder.append("\n\tsimplify: ");
        builder.append(this.simplify);
        builder.append("\n\tintersectionMode: ");
        builder.append((Object)this.intersectionMode);
        builder.append("\n\tpathSerializer: ");
        builder.append((Object)this.pathSerializer);
        builder.append("\n\tpolygonSerializerType: ");
        builder.append((Object)this.polygonSerializerType);
        builder.append("\n\tmaxSnapDistance: ");
        builder.append(this.maxSnapDistance);
        builder.append("\n\tmultiGraphEdgeClasses: ");
        builder.append(this.multiGraphEdgeClasses);
        builder.append("\n\tmultiGraphSerializationFormat: ");
        builder.append((Object)this.multiGraphSerializationFormat);
        builder.append("\n\tmultiGraphSerializationDecimalPrecision: ");
        builder.append(this.multiGraphSerializationDecimalPrecision);
        builder.append("\n\tmultiGraphSerializationMaxGeometryCount: ");
        builder.append(this.multiGraphSerializationMaxGeometryCount);
        builder.append("\n\tmultiGraphDomainType: ");
        builder.append((Object)this.multiGraphDomainType);
        builder.append("\n\tmultiGraphDomainEdgeAggregationType: ");
        builder.append((Object)this.multiGraphDomainEdgeAggregationType);
        builder.append("\n\tmultiGraphAggregationType: ");
        builder.append((Object)this.multiGraphAggregationType);
        builder.append("\n\tmultiGraphAggregationIgnoreOutliers: ");
        builder.append(this.multiGraphAggregationIgnoreOutliers);
        builder.append("\n\tmultiGraphAggregationOutlierPenalty: ");
        builder.append(this.multiGraphAggregationOutlierPenalty);
        builder.append("\n\tmultiGraphAggregationMinSourcesRatio: ");
        builder.append(this.multiGraphAggregationMinSourcesRatio);
        builder.append("\n\tmultiGraphAggregationMinSourcesCount: ");
        builder.append(this.multiGraphAggregationMinSourcesCount);
        builder.append("\n\tmultiGraphAggregationSourceValuesLowerBound: ");
        builder.append(this.multiGraphAggregationSourceValuesLowerBound);
        builder.append("\n\tmultiGraphAggregationSourceValuesUpperBound: ");
        builder.append(this.multiGraphAggregationSourceValuesUpperBound);
        builder.append("\n\tmultiGraphAggregationMinResultValueRatio: ");
        builder.append(this.multiGraphAggregationMinResultValueRatio);
        builder.append("\n\tmultiGraphAggregationMinResultValue: ");
        builder.append(this.multiGraphAggregationMinResultValue);
        builder.append("\n\tmultiGraphAggregationMaxResultValueRatio: ");
        builder.append(this.multiGraphAggregationMaxResultValueRatio);
        builder.append("\n\tmultiGraphAggregationMaxResultValue: ");
        builder.append(this.multiGraphAggregationMaxResultValue);
        builder.append("\n\tmultiGraphAggregationMathExpression: ");
        builder.append(this.multiGraphAggregationMathExpression);
        builder.append("\n\tmultiGraphLayerCustomGeometryMergeAggregation: ");
        builder.append((Object)this.multiGraphLayerCustomGeometryMergeAggregation);
        builder.append("\n\tmultiGraphAggregationPostAggregationFactor: ");
        builder.append(this.multiGraphAggregationPostAggregationFactor);
        builder.append("\n\tmultiGraphAggregationGravitationExponent: ");
        builder.append(this.multiGraphAggregationGravitationExponent);
        builder.append("\n\tmultiGraphAggregationProbabilityDecay: ");
        builder.append(this.multiGraphAggregationProbabilityDecay);
        builder.append("\n\tmultiGraphAggregationLogitBetaAttractionStrength: ");
        builder.append(this.multiGraphAggregationLogitBetaAttractionStrength);
        builder.append("\n\tmultiGraphAggregationLogitBetaTravelTime: ");
        builder.append(this.multiGraphAggregationLogitBetaTravelTime);
        builder.append("\n\tmultiGraphAggregationInputParameters: ");
        builder.append(this.multiGraphAggregationInputParameters);
        builder.append("\n\tmultiGraphAggregationFilterValuesForSourceOrigins: ");
        builder.append(this.multiGraphAggregationFilterValuesForSourceOrigins);
        builder.append("\n\tmultiGraphPreAggregationPipeline: ");
        builder.append(this.multiGraphPreAggregationPipeline);
        builder.append("\n\tmultiGraphLayerType: ");
        builder.append((Object)this.multiGraphLayerType);
        builder.append("\n\tmultiGraphLayerGeometryDetailPerTile: ");
        builder.append(this.multiGraphLayerGeometryDetailPerTile);
        builder.append("\n\tmultiGraphLayerMinGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerMinGeometryDetailLevel);
        builder.append("\n\tmultiGraphLayerMaxGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerMaxGeometryDetailLevel);
        builder.append("\n\tmultiGraphLayerGeometryDetailLevel: ");
        builder.append(this.multiGraphLayerGeometryDetailLevel);
        builder.append("\n\tmultiGraphTileZoom: ");
        builder.append(this.multiGraphTileZoom);
        builder.append("\n\tmultiGraphTileX: ");
        builder.append(this.multiGraphTileX);
        builder.append("\n\tmultiGraphTileY: ");
        builder.append(this.multiGraphTileY);
        builder.append("\n\tclipGeometry: ");
        builder.append(this.clipGeometry != null ? this.clipGeometry.toString() : null);
        builder.append("\n\tmaxEdgeWeight: ");
        builder.append(this.maxEdgeWeight);
        builder.append("\n\tserviceUrl: ");
        builder.append(this.serviceUrl);
        builder.append("\n\tserviceKey: ");
        builder.append(this.serviceKey);
        builder.append("\n\tfallbackServiceUrl: ");
        builder.append(this.fallbackServiceUrl);
        builder.append("\n\tonlyPrintReachablePoints: ");
        builder.append(this.onlyPrintReachablePoints);
        builder.append("\n\tedgeWeightType: ");
        builder.append((Object)this.edgeWeightType);
        builder.append("\n\tstatisticGroupId: ");
        builder.append(this.statisticGroupId);
        builder.append("\n\tstatisticServiceUrl: ");
        builder.append(this.statisticServiceUrl);
        builder.append("\n\tpointOfInterestServiceUrl: ");
        builder.append(this.pointOfInterestServiceUrl);
        builder.append("\n\toverpassQuery: ");
        builder.append(this.overpassQuery);
        builder.append("\n\toverpassServiceUrl: ");
        builder.append(this.overpassServiceUrl);
        builder.append("\n\tinterServiceKey: ");
        builder.append(this.interServiceKey);
        builder.append("\n\tinterServiceRequestType: ");
        builder.append(this.interServiceRequestType);
        builder.append("\n\tformat: ");
        builder.append((Object)this.format);
        builder.append("\n\tboundingBox: ");
        builder.append(this.boundingBox);
        builder.append("\n\ttravelTypes: ");
        builder.append(this.travelTypes != null ? this.toString(this.travelTypes, 5) : null);
        builder.append("\n\tosmTypes: ");
        builder.append(this.osmTypes != null ? this.toString(this.osmTypes, 5) : null);
        builder.append("\n\tcustomPois: ");
        builder.append(this.customPois != null ? this.toString(this.customPois, 5) : null);
        builder.append("\n\tfilterGeometry: ");
        builder.append(this.filterGeometryForPOIs);
        builder.append("\n\tpoiGravitationExponent: ");
        builder.append(this.poiGravitationExponent);
        builder.append("\n\tpoiGravitationProbabilityDecay: ");
        builder.append(this.poiGravitationProbabilityDecay);
        builder.append("\n\ttravelTimeFactors: ");
        builder.append(this.travelTimeFactors != null ? this.toString(this.travelTimeFactors.entrySet(), 5) : null);
        builder.append("\n\tmaxTransfers: ");
        builder.append(this.maxTransfers);
        builder.append("\n\tavoidTransitRouteTypes: ");
        builder.append(this.avoidTransitRouteTypes != null ? this.toString(this.avoidTransitRouteTypes, 5) : null);
        builder.append("\n\tmaxWalkingTimeFromSource: ");
        builder.append(this.maxWalkingTimeFromSource);
        builder.append("\n\tmaxWalkingTimeToTarget: ");
        builder.append(this.maxWalkingTimeToTarget);
        builder.append("\n\tnextStopsStartTime: ");
        builder.append(this.nextStopsStartTime);
        builder.append("\n\tnextStopsEndTime: ");
        builder.append(this.nextStopsEndTime);
        builder.append("\n\tincludeSnapDistance: ");
        builder.append(this.includeSnapDistance);
        builder.append("\n\tuseAreaSnapping: ");
        builder.append(this.useAreaSnapping);
        builder.append("\n\tsnapRadius: ");
        builder.append(this.snapRadius);
        builder.append("\n\texcludeEdgeClassesFromSnapping: ");
        builder.append(this.excludeEdgeClassesFromSnapping != null ? this.toString(this.excludeEdgeClassesFromSnapping, 5) : null);
        builder.append("\n}\n");
        return builder.toString();
    }

    public Coordinate getSource(String id) {
        return this.sources.get(id);
    }

    public AbstractGeometry getSourcegeometry(String id) {
        return this.sourceGeometries.get(id);
    }

    public Coordinate getTarget(String id) {
        return this.targets.get(id);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setOnlyPrintReachablePoints(boolean onlyPrintReachablePoints) {
        this.onlyPrintReachablePoints = onlyPrintReachablePoints;
    }

    public boolean getOnlyPrintReachablePoints() {
        return this.onlyPrintReachablePoints;
    }

    public Double getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Double buffer) {
        this.buffer = buffer;
    }

    public Double getSimplify() {
        return this.simplify;
    }

    public void setSimplify(Double simplify) {
        this.simplify = simplify;
    }

    public Integer getQuadrantSegments() {
        return this.quadrantSegments;
    }

    public void setQuadrantSegments(Integer quadrantSegments) {
        this.quadrantSegments = quadrantSegments;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public PolygonOrientationRule getPolygonOrientationRule() {
        return this.polygonOrientationRule;
    }

    public void setPolygonOrientationRule(PolygonOrientationRule polygonOrientationRule) {
        this.polygonOrientationRule = polygonOrientationRule;
    }

    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public Boolean getAppendTravelTimes() {
        return this.appendTravelTimes;
    }

    public Set<Integer> getMultiGraphEdgeClasses() {
        return this.multiGraphEdgeClasses;
    }

    public void setMultiGraphEdgeClasses(Set<Integer> multiGraphEdgeClasses) {
        this.multiGraphEdgeClasses = multiGraphEdgeClasses;
    }

    public MultiGraphSerializationFormat getMultiGraphSerializationFormat() {
        return this.multiGraphSerializationFormat;
    }

    public void setMultiGraphSerializationFormat(MultiGraphSerializationFormat multiGraphSerializationFormat) {
        this.multiGraphSerializationFormat = multiGraphSerializationFormat;
    }

    public Integer getMultiGraphSerializationDecimalPrecision() {
        return this.multiGraphSerializationDecimalPrecision;
    }

    public void setMultiGraphSerializationDecimalPrecision(Integer multiGraphSerializationDecimalPrecision) {
        this.multiGraphSerializationDecimalPrecision = multiGraphSerializationDecimalPrecision;
    }

    public Integer getMultiGraphSerializationMaxGeometryCount() {
        return this.multiGraphSerializationMaxGeometryCount;
    }

    public void setMultiGraphSerializationMaxGeometryCount(Integer multiGraphSerializationMaxGeometryCount) {
        this.multiGraphSerializationMaxGeometryCount = multiGraphSerializationMaxGeometryCount;
    }

    public MultiGraphAggregationType getMultiGraphAggregationType() {
        return this.multiGraphAggregationType;
    }

    public void setMultiGraphAggregationType(MultiGraphAggregationType multiGraphAggregationType) {
        this.multiGraphAggregationType = multiGraphAggregationType;
    }

    public Boolean getMultiGraphAggregationIgnoreOutliers() {
        return this.multiGraphAggregationIgnoreOutliers;
    }

    public void setMultiGraphAggregationIgnoreOutliers(Boolean multiGraphAggregationIgnoreOutliers) {
        this.multiGraphAggregationIgnoreOutliers = multiGraphAggregationIgnoreOutliers;
    }

    public Float getMultiGraphAggregationOutlierPenalty() {
        return this.multiGraphAggregationOutlierPenalty;
    }

    public void setMultiGraphAggregationOutlierPenalty(Float multiGraphAggregationOutlierPenalty) {
        this.multiGraphAggregationOutlierPenalty = multiGraphAggregationOutlierPenalty;
    }

    public Double getMultiGraphAggregationMinSourcesRatio() {
        return this.multiGraphAggregationMinSourcesRatio;
    }

    public void setMultiGraphAggregationMinSourcesRatio(Double multiGraphAggregationMinSourcesRatio) {
        this.multiGraphAggregationMinSourcesRatio = multiGraphAggregationMinSourcesRatio;
    }

    public Integer getMultiGraphAggregationMinSourcesCount() {
        return this.multiGraphAggregationMinSourcesCount;
    }

    public void setMultiGraphAggregationMinSourcesCount(Integer multiGraphAggregationMinSourcesCount) {
        this.multiGraphAggregationMinSourcesCount = multiGraphAggregationMinSourcesCount;
    }

    public Float getMultiGraphAggregationSourceValuesLowerBound() {
        return this.multiGraphAggregationSourceValuesLowerBound;
    }

    public void setMultiGraphAggregationSourceValuesLowerBound(Float multiGraphAggregationSourceValuesLowerBound) {
        this.multiGraphAggregationSourceValuesLowerBound = multiGraphAggregationSourceValuesLowerBound;
    }

    public Float getMultiGraphAggregationSourceValuesUpperBound() {
        return this.multiGraphAggregationSourceValuesUpperBound;
    }

    public void setMultiGraphAggregationSourceValuesUpperBound(Float multiGraphAggregationSourceValuesUpperBound) {
        this.multiGraphAggregationSourceValuesUpperBound = multiGraphAggregationSourceValuesUpperBound;
    }

    public Double getMultiGraphAggregationMinResultValueRatio() {
        return this.multiGraphAggregationMinResultValueRatio;
    }

    public void setMultiGraphAggregationMinResultValueRatio(Double multiGraphAggregationMinResultValueRatio) {
        this.multiGraphAggregationMinResultValueRatio = multiGraphAggregationMinResultValueRatio;
    }

    public Float getMultiGraphAggregationMinResultValue() {
        return this.multiGraphAggregationMinResultValue;
    }

    public void setMultiGraphAggregationMinResultValue(Float multiGraphAggregationMinResultValue) {
        this.multiGraphAggregationMinResultValue = multiGraphAggregationMinResultValue;
    }

    public Double getMultiGraphAggregationMaxResultValueRatio() {
        return this.multiGraphAggregationMaxResultValueRatio;
    }

    public void setMultiGraphAggregationMaxResultValueRatio(Double multiGraphAggregationMaxResultValueRatio) {
        this.multiGraphAggregationMaxResultValueRatio = multiGraphAggregationMaxResultValueRatio;
    }

    public Float getMultiGraphAggregationMaxResultValue() {
        return this.multiGraphAggregationMaxResultValue;
    }

    public void setMultiGraphAggregationMaxResultValue(Float multiGraphAggregationMaxResultValue) {
        this.multiGraphAggregationMaxResultValue = multiGraphAggregationMaxResultValue;
    }

    public Double getMultiGraphAggregationGravitationExponent() {
        return this.multiGraphAggregationGravitationExponent;
    }

    public void setMultiGraphAggregationGravitationExponent(Double multiGraphAggregationGravitationExponent) {
        this.multiGraphAggregationGravitationExponent = multiGraphAggregationGravitationExponent;
    }

    public Double getMultiGraphAggregationProbabilityDecay() {
        return this.multiGraphAggregationProbabilityDecay;
    }

    public void setMultiGraphAggregationProbabilityDecay(Double multiGraphAggregationProbabilityDecay) {
        this.multiGraphAggregationProbabilityDecay = multiGraphAggregationProbabilityDecay;
    }

    public Double getMultiGraphAggregationLogitBetaAttractionStrength() {
        return this.multiGraphAggregationLogitBetaAttractionStrength;
    }

    public void setMultiGraphAggregationLogitBetaAttractionStrength(Double multiGraphAggregationLogitBetaAttractionStrength) {
        this.multiGraphAggregationLogitBetaAttractionStrength = multiGraphAggregationLogitBetaAttractionStrength;
    }

    public Double getMultiGraphAggregationLogitBetaTravelTime() {
        return this.multiGraphAggregationLogitBetaTravelTime;
    }

    public void setMultiGraphAggregationLogitBetaTravelTime(Double multiGraphAggregationLogitBetaTravelTime) {
        this.multiGraphAggregationLogitBetaTravelTime = multiGraphAggregationLogitBetaTravelTime;
    }

    public Set<String> getMultiGraphAggregationFilterValuesForSourceOrigins() {
        return this.multiGraphAggregationFilterValuesForSourceOrigins;
    }

    public void setMultiGraphAggregationFilterValuesForSourceOrigins(Set<String> multiGraphAggregationFilterValuesForSourceOrigins) {
        this.multiGraphAggregationFilterValuesForSourceOrigins = multiGraphAggregationFilterValuesForSourceOrigins;
    }

    public MultiGraphLayerType getMultiGraphLayerType() {
        return this.multiGraphLayerType;
    }

    public void setMultiGraphLayerType(MultiGraphLayerType multiGraphLayerType) {
        this.multiGraphLayerType = multiGraphLayerType;
    }

    public MultiGraphDomainEdgeAggregationType getMultiGraphDomainEdgeAggregationType() {
        return this.multiGraphDomainEdgeAggregationType;
    }

    public void setMultiGraphDomainEdgeAggregationType(MultiGraphDomainEdgeAggregationType multiGraphDomainEdgeAggregationType) {
        this.multiGraphDomainEdgeAggregationType = multiGraphDomainEdgeAggregationType;
    }

    public MultiGraphDomainType getMultiGraphDomainType() {
        return this.multiGraphDomainType;
    }

    public void setMultiGraphDomainType(MultiGraphDomainType multiGraphDomainType) {
        this.multiGraphDomainType = multiGraphDomainType;
    }

    public Integer getMultiGraphLayerGeometryDetailPerTile() {
        return this.multiGraphLayerGeometryDetailPerTile;
    }

    public void setMultiGraphLayerGeometryDetailPerTile(Integer multiGraphLayerGeometryDetailPerTile) {
        this.multiGraphLayerGeometryDetailPerTile = multiGraphLayerGeometryDetailPerTile;
    }

    public Integer getMultiGraphLayerMinGeometryDetailLevel() {
        return this.multiGraphLayerMinGeometryDetailLevel;
    }

    public void setMultiGraphLayerMinGeometryDetailLevel(Integer multiGraphLayerMinGeometryDetailLevel) {
        this.multiGraphLayerMinGeometryDetailLevel = multiGraphLayerMinGeometryDetailLevel;
    }

    public Integer getMultiGraphLayerMaxGeometryDetailLevel() {
        return this.multiGraphLayerMaxGeometryDetailLevel;
    }

    public void setMultiGraphLayerMaxGeometryDetailLevel(Integer multiGraphLayerMaxGeometryDetailLevel) {
        this.multiGraphLayerMaxGeometryDetailLevel = multiGraphLayerMaxGeometryDetailLevel;
    }

    public Integer getMultiGraphLayerGeometryDetailLevel() {
        return this.multiGraphLayerGeometryDetailLevel;
    }

    public void setMultiGraphLayerGeometryDetailLevel(Integer multiGraphLayerGeometryDetailLevel) {
        this.multiGraphLayerGeometryDetailLevel = multiGraphLayerGeometryDetailLevel;
    }

    public Integer getMultiGraphTileZoom() {
        return this.multiGraphTileZoom;
    }

    public void setMultiGraphTileZoom(Integer multiGraphTileZoom) {
        this.multiGraphTileZoom = multiGraphTileZoom;
    }

    public Integer getMultiGraphTileX() {
        return this.multiGraphTileX;
    }

    public void setMultiGraphTileX(Integer multiGraphTileX) {
        this.multiGraphTileX = multiGraphTileX;
    }

    public Integer getMultiGraphTileY() {
        return this.multiGraphTileY;
    }

    public void setMultiGraphTileY(Integer multiGraphTileY) {
        this.multiGraphTileY = multiGraphTileY;
    }

    public Float getMultiGraphAggregationPostAggregationFactor() {
        return this.multiGraphAggregationPostAggregationFactor;
    }

    public void setMultiGraphAggregationPostAggregationFactor(Float multiGraphAggregationPostAggregationFactor) {
        this.multiGraphAggregationPostAggregationFactor = multiGraphAggregationPostAggregationFactor;
    }

    public Geometry getClipGeometry() {
        return this.clipGeometry;
    }

    public void setClipGeometry(Geometry clipGeometry) {
        this.clipGeometry = clipGeometry;
    }

    public EdgeWeightType getEdgeWeightType() {
        return this.edgeWeightType;
    }

    public void setEdgeWeightType(EdgeWeightType edgeWeightType) {
        this.edgeWeightType = edgeWeightType;
    }

    public void setAppendTravelTimes(Boolean appendTravelTimes) {
        this.appendTravelTimes = appendTravelTimes;
    }

    public String getStatisticServiceUrl() {
        return this.statisticServiceUrl;
    }

    public void setStatisticServiceUrl(String statisticServiceUrl) {
        this.statisticServiceUrl = statisticServiceUrl;
    }

    public Integer getStatisticGroupId() {
        return this.statisticGroupId;
    }

    public void setStatisticGroupId(Integer statisticGroupId) {
        this.statisticGroupId = statisticGroupId;
    }

    public Integer getMaxEdgeWeight() {
        return this.maxEdgeWeight;
    }

    public void setMaxEdgeWeight(Integer maxEdgeWeight) {
        this.maxEdgeWeight = maxEdgeWeight;
    }

    public void addAllSources(Map<String, Coordinate> sources) {
        this.sources.putAll(sources);
    }

    public void addAllSourceGeometries(Map<String, AbstractGeometry> sourceGeometries) {
        this.sourceGeometries.putAll(sourceGeometries);
    }

    public void clearAndAddSource(String id, Coordinate source) {
        this.sources.clear();
        this.sources.put(id, source);
    }

    public void clearAndAddSource(String id, AbstractGeometry source) {
        this.sourceGeometries.clear();
        this.sourceGeometries.put(id, source);
    }

    public String getFallbackServiceUrl() {
        return this.fallbackServiceUrl;
    }

    public void setFallbackServiceUrl(String fallbackServiceUrl) {
        this.fallbackServiceUrl = fallbackServiceUrl;
    }

    public String getPointOfInterestServiceUrl() {
        return this.pointOfInterestServiceUrl;
    }

    public void setPointOfInterestServiceUrl(String pointOfInterestServiceUrl) {
        this.pointOfInterestServiceUrl = pointOfInterestServiceUrl;
    }

    public String getOverpassServiceUrl() {
        return this.overpassServiceUrl;
    }

    public void setOverpassServiceUrl(String overpassServiceUrl) {
        this.overpassServiceUrl = overpassServiceUrl;
    }

    public String getOverpassQuery() {
        return this.overpassQuery;
    }

    public void setOverpassQuery(String overpassQuery) {
        this.overpassQuery = overpassQuery;
    }

    public String getInterServiceKey() {
        return this.interServiceKey;
    }

    public void setInterServiceKey(String interServiceKey) {
        this.interServiceKey = interServiceKey;
    }

    public Integer getMaxTransfers() {
        return this.maxTransfers;
    }

    public void setMaxTransfers(Integer maxTransfers) {
        this.maxTransfers = maxTransfers;
    }

    public Map<String, Double> getTravelTimeFactors() {
        return this.travelTimeFactors;
    }

    public void setTravelTimeFactors(Map<String, Double> travelTimeFactors) {
        this.travelTimeFactors = travelTimeFactors;
    }

    public Geometry getIntersectionGeometry() {
        return this.intersectionGeometry;
    }

    public void setIntersectionGeometry(Geometry intersectionGeometry) {
        this.intersectionGeometry = intersectionGeometry;
    }

    public Geometry getExclusionGeometry() {
        return this.exclusionGeometry;
    }

    public void setExclusionGeometry(Geometry exclusionGeometry) {
        this.exclusionGeometry = exclusionGeometry;
    }

    public boolean isForceRecalculate() {
        return this.forceRecalculate;
    }

    public void setForceRecalculate(boolean forceRecalculate) {
        this.forceRecalculate = forceRecalculate;
    }

    public boolean isCacheResult() {
        return this.cacheResult;
    }

    public void setCacheResult(boolean cacheResult) {
        this.cacheResult = cacheResult;
    }

    public List<Integer> getAvoidTransitRouteTypes() {
        return this.avoidTransitRouteTypes;
    }

    public void setAvoidTransitRouteTypes(List<Integer> avoidTransitRouteTypes) {
        this.avoidTransitRouteTypes = avoidTransitRouteTypes;
    }

    public Integer getNextStopsStartTime() {
        return this.nextStopsStartTime;
    }

    public void setNextStopsStartTime(Integer nextStopsStartTime) {
        this.nextStopsStartTime = nextStopsStartTime;
    }

    public Integer getNextStopsEndTime() {
        return this.nextStopsEndTime;
    }

    public void setNextStopsEndTime(Integer nextStopsEndTime) {
        this.nextStopsEndTime = nextStopsEndTime;
    }

    public Integer getTrafficJunctionPenalty() {
        return this.trafficJunctionPenalty;
    }

    public void setTrafficJunctionPenalty(Integer trafficJunctionPenalty) {
        this.trafficJunctionPenalty = trafficJunctionPenalty;
    }

    public Integer getTrafficSignalPenalty() {
        return this.trafficSignalPenalty;
    }

    public void setTrafficSignalPenalty(Integer trafficSignalPenalty) {
        this.trafficSignalPenalty = trafficSignalPenalty;
    }

    public Integer getTrafficLeftTurnPenalty() {
        return this.trafficLeftTurnPenalty;
    }

    public void setTrafficLeftTurnPenalty(Integer trafficLeftTurnPenalty) {
        this.trafficLeftTurnPenalty = trafficLeftTurnPenalty;
    }

    public Integer getTrafficRightTurnPenalty() {
        return this.trafficRightTurnPenalty;
    }

    public void setTrafficRightTurnPenalty(Integer trafficRightTurnPenalty) {
        this.trafficRightTurnPenalty = trafficRightTurnPenalty;
    }

    public String getInterServiceRequestType() {
        return this.interServiceRequestType;
    }

    public void setInterServiceRequestType(String interServiceRequestType) {
        this.interServiceRequestType = interServiceRequestType;
    }

    public Boolean getIncludeSnapDistance() {
        return this.includeSnapDistance;
    }

    public void setIncludeSnapDistance(Boolean includeSnapDistance) {
        this.includeSnapDistance = includeSnapDistance;
    }

    public Boolean getUseAreaSnapping() {
        return this.useAreaSnapping;
    }

    public void setUseAreaSnapping(Boolean useAreaSnapping) {
        this.useAreaSnapping = useAreaSnapping;
    }

    public Integer getSnapRadius() {
        return this.snapRadius;
    }

    public void setSnapRadius(Integer snapRadius) {
        this.snapRadius = snapRadius;
    }

    public List<Integer> getExcludeEdgeClassesFromSnapping() {
        return this.excludeEdgeClassesFromSnapping;
    }

    public void setExcludeEdgeClassesFromSnapping(List<Integer> excludeEdgeClassesFromSnapping) {
        this.excludeEdgeClassesFromSnapping = excludeEdgeClassesFromSnapping;
    }
}

