/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.databind.Module;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.MultiGraphSerializationFormat;
import com.targomo.client.api.enums.MultiGraphSerializationH3IdFormat;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.TargomoRequest;
import com.targomo.client.api.response.MultiGraphResponse;
import com.targomo.jackson.datatype.trove.TroveModule;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class MultiGraphRequest<R extends MultiGraphResponse<?>>
extends TargomoRequest<R> {
    private static final String HTTP_METHOD = "POST";
    private static final String PATH = "v1/multigraph";

    public MultiGraphRequest(Client client, TravelOptions travelOptions, Class<R> responseClass, MultivaluedMap<String, Object> headers) {
        super(client, travelOptions, PATH, HTTP_METHOD, responseClass, headers);
        if (responseClass == MultiGraphResponse.MultiGraphJsonResponse.class && !MultiGraphSerializationFormat.JSON.equals((Object)travelOptions.getMultiGraphSerializationFormat()) || responseClass == MultiGraphResponse.MultiGraphGeoJsonResponse.class && !MultiGraphSerializationFormat.GEOJSON.equals((Object)travelOptions.getMultiGraphSerializationFormat())) {
            throw new IllegalArgumentException("MultiGraph serialization type JSON must be requested to expect MultiGraphJsonResponse");
        }
    }

    public MultiGraphRequest(Client client, TravelOptions travelOptions, Class<R> responseClass) {
        this(client, travelOptions, responseClass, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public static MultiGraphResponse.MultiGraphJsonResponse executeRequestJson(TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        return (MultiGraphResponse.MultiGraphJsonResponse)TargomoRequest.executeRequest((client, tO) -> new MultiGraphRequest<MultiGraphResponse.MultiGraphJsonResponse>((Client)client, (TravelOptions)tO, MultiGraphResponse.MultiGraphJsonResponse.class, headers), travelOptions);
    }

    public static MultiGraphResponse.MultiGraphJsonResponse executeRequestJson(TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestJson(travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public static MultiGraphResponse.MultiGraphGeoJsonResponse executeRequestGeoJson(TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        return (MultiGraphResponse.MultiGraphGeoJsonResponse)TargomoRequest.executeRequest((client, tO) -> new MultiGraphRequest<MultiGraphResponse.MultiGraphGeoJsonResponse>((Client)client, (TravelOptions)tO, MultiGraphResponse.MultiGraphGeoJsonResponse.class, headers), travelOptions);
    }

    public static MultiGraphResponse.MultiGraphGeoJsonResponse executeRequestGeoJson(TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestGeoJson(travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public static MultiGraphResponse.MultiGraphJsonResponse executeRequestJson(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        if (!MultiGraphSerializationFormat.JSON.equals((Object)travelOptions.getMultiGraphSerializationFormat())) {
            throw new IllegalArgumentException("MultiGraph serialization type JSON must be requested to expect MultiGraphJsonResponse");
        }
        return (MultiGraphResponse.MultiGraphJsonResponse)new MultiGraphRequest<MultiGraphResponse.MultiGraphJsonResponse>(client, travelOptions, MultiGraphResponse.MultiGraphJsonResponse.class, headers).get();
    }

    public static MultiGraphResponse.MultiGraphJsonResponse executeRequestJson(Client client, TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestJson(client, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public static MultiGraphResponse.MultiGraphGeoJsonResponse executeRequestGeoJson(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        if (!MultiGraphSerializationFormat.GEOJSON.equals((Object)travelOptions.getMultiGraphSerializationFormat())) {
            throw new IllegalArgumentException("MultiGraph serialization type GEOJSON must be requested to expect MultiGraphGeoJsonResponse");
        }
        return (MultiGraphResponse.MultiGraphGeoJsonResponse)new MultiGraphRequest<MultiGraphResponse.MultiGraphGeoJsonResponse>(client, travelOptions, MultiGraphResponse.MultiGraphGeoJsonResponse.class, headers).get();
    }

    public static MultiGraphResponse.MultiGraphGeoJsonResponse executeRequestGeoJson(Client client, TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestGeoJson(client, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    private static <T> MultiGraphResponse.MultiGraphH3JsonResponse<T> executeRequestH3Json(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        if (!MultiGraphSerializationFormat.JSON.equals((Object)travelOptions.getMultiGraphSerializationFormat())) {
            throw new IllegalArgumentException("MultiGraph serialization type JSON must be requested to expect MultiGraphH3JsonResponse");
        }
        return (MultiGraphResponse.MultiGraphH3JsonResponse)new MultiGraphRequest<MultiGraphResponse.MultiGraphH3JsonResponse>(client, travelOptions, MultiGraphResponse.MultiGraphH3JsonResponse.class, headers).get();
    }

    public static MultiGraphResponse.MultiGraphH3JsonResponse<String> executeRequestH3StringJson(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        if (!MultiGraphSerializationH3IdFormat.STRING.equals((Object)travelOptions.getMultiGraphSerializationH3IdFormat())) {
            throw new IllegalArgumentException("H3 Id format STRING must be requested to expect MultiGraphH3JsonResponse<String>");
        }
        return MultiGraphRequest.executeRequestH3Json(client, travelOptions, headers);
    }

    public static MultiGraphResponse.MultiGraphH3JsonResponse<String> executeRequestH3StringJson(Client client, TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestH3StringJson(client, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public static MultiGraphResponse.MultiGraphH3JsonResponse<Long> executeRequestH3NumericJson(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) throws TargomoClientException, ResponseErrorException {
        if (!MultiGraphSerializationH3IdFormat.NUMERIC.equals((Object)travelOptions.getMultiGraphSerializationH3IdFormat())) {
            throw new IllegalArgumentException("H3 Id format NUMERIC must be requested to expect MultiGraphH3JsonResponse<Long>");
        }
        return MultiGraphRequest.executeRequestH3Json(client, travelOptions, headers);
    }

    public static MultiGraphResponse.MultiGraphH3JsonResponse<Long> executeRequestH3NumericJson(Client client, TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        return MultiGraphRequest.executeRequestH3NumericJson(client, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    static {
        MAPPER.registerModule((Module)new TroveModule(Integer.MIN_VALUE, -3.4028235E38f));
    }
}

