/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wololo.geojson.Feature;
import org.wololo.geojson.FeatureCollection;
import org.wololo.geojson.GeoJSON;
import org.wololo.jts2geojson.GeoJSONReader;
import org.wololo.jts2geojson.GeoJSONWriter;

public class GeojsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeojsonUtil.class);
    private static final String FILE_ENDING = ".geojson";

    private GeojsonUtil() {
    }

    public static List<Feature> transformGeometry(MathTransform transformer, Feature ... featuresToTransform) throws TransformException {
        ArrayList<Feature> featureList = new ArrayList<Feature>(featuresToTransform.length);
        for (Feature feature : featuresToTransform) {
            GeoJSONReader reader = new GeoJSONReader();
            Geometry geometry = reader.read((GeoJSON)feature.getGeometry());
            geometry = JTS.transform((Geometry)geometry, (MathTransform)transformer);
            GeoJSONWriter writer = new GeoJSONWriter();
            org.wololo.geojson.Geometry json = writer.write(geometry);
            featureList.add(new Feature(json, feature.getProperties()));
        }
        return featureList;
    }

    public static void openGeoJsonInBrowserWithGeojsonIO(String gitHubUser, String githubTokenForGistUpload, Map<String, FeatureCollection> featureCollections) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, ImmutableMap> fileMap = new HashMap<String, ImmutableMap>(featureCollections.size());
        for (Map.Entry<String, FeatureCollection> entry : featureCollections.entrySet()) {
            String fileName = entry.getKey().endsWith(FILE_ENDING) ? entry.getKey() : entry.getKey() + FILE_ENDING;
            String featureCollectionAsString = mapper.writeValueAsString((Object)entry.getValue());
            fileMap.put(fileName, ImmutableMap.builder().put((Object)"content", (Object)featureCollectionAsString).build());
        }
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("https://api.github.com/").path("gists");
        String authForUploadingGists = Base64.getEncoder().encodeToString((gitHubUser + ":" + githubTokenForGistUpload).getBytes());
        for (Map.Entry geojsonFile : fileMap.entrySet()) {
            String requestAsString = mapper.writeValueAsString((Object)ImmutableMap.builder().put((Object)"public", (Object)true).put((Object)"files", geojsonFile).build());
            Response response = target.request().header("Authorization", (Object)("Basic " + authForUploadingGists)).buildPost(Entity.entity((Object)requestAsString, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
            String responseString = (String)response.readEntity(String.class);
            String idString = Stream.of(responseString.split(",")).filter(val -> val.startsWith("\"id\":\"")).findFirst().orElseThrow(() -> new RuntimeException("Request returned unexpected: " + responseString));
            GeojsonUtil.displayURLInBrowser("http://geojson.io/#id=gist:anonymous/" + idString.substring(6, idString.length() - 1));
        }
    }

    public static void openGeoJsonInBrowserWithGitHubGist(String gitHubUser, String githubTokenForGistUpload, Map<String, FeatureCollection> featureCollections) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, ImmutableMap> fileMap = new HashMap<String, ImmutableMap>(featureCollections.size());
        for (Map.Entry<String, FeatureCollection> entry : featureCollections.entrySet()) {
            String fileName = entry.getKey().endsWith(FILE_ENDING) ? entry.getKey() : entry.getKey() + FILE_ENDING;
            String featureCollectionAsString = mapper.writeValueAsString((Object)entry.getValue());
            fileMap.put(fileName, ImmutableMap.builder().put((Object)"content", (Object)featureCollectionAsString).build());
        }
        String requestAsString = mapper.writeValueAsString((Object)ImmutableMap.builder().put((Object)"public", (Object)true).put((Object)"files", fileMap).build());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("https://api.github.com/").path("gists");
        String authForUploadingGists = Base64.getEncoder().encodeToString((gitHubUser + ":" + githubTokenForGistUpload).getBytes());
        Response response = target.request().header("Authorization", (Object)("Basic " + authForUploadingGists)).buildPost(Entity.entity((Object)requestAsString, (MediaType)MediaType.APPLICATION_JSON_TYPE)).invoke();
        String responseString = (String)response.readEntity(String.class);
        String url = Stream.of(responseString.split(",")).filter(val -> val.startsWith("\"html_url\":\"")).findFirst().orElseThrow(() -> new RuntimeException("Request returned unexpected: " + responseString));
        GeojsonUtil.displayURLInBrowser(url.substring(12, url.length() - 1));
    }

    private static void displayURLInBrowser(String url) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error occurred while trying to open the browser", (Throwable)e);
            }
        } else {
            Runtime.getRuntime().exec("xdg-open " + url);
        }
    }
}

