/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractLocation;
import com.targomo.client.api.geo.Location;
import com.targomo.client.api.pojo.LocationProperties;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public class DefaultSourceAddress
extends AbstractLocation
implements Location {
    @Id
    @Column(name="identifier")
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long identifier;
    @Column(name="travel_type")
    private TravelType travelType;
    private String h3Address;

    public DefaultSourceAddress() {
    }

    public DefaultSourceAddress(String h3Address, TravelType travelType, LocationProperties locationProperties) {
        super(null, locationProperties);
        this.h3Address = h3Address;
        this.travelType = travelType;
    }

    public DefaultSourceAddress(String h3Address, LocationProperties locationProperties) {
        this(h3Address, null, locationProperties);
    }

    public DefaultSourceAddress(String h3Address, TravelType travelType) {
        this(h3Address, travelType, null);
    }

    public DefaultSourceAddress(String h3Address) {
        this(h3Address, null, null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\th3Address: ");
        builder.append(this.h3Address);
        builder.append("\n}\n");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSourceAddress that = (DefaultSourceAddress)o;
        return Objects.equals(this.h3Address, that.h3Address);
    }

    public int hashCode() {
        return this.h3Address.hashCode();
    }

    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public TravelType getTravelType() {
        return this.travelType;
    }

    public String getH3Address() {
        return this.h3Address;
    }

    public void setIdentifier(long identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    public void setH3Address(String h3Address) {
        this.h3Address = h3Address;
    }
}

