/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.quality.Location;
import com.targomo.client.api.request.ScoreRequest;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ScoreResponse;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RatingRequest {
    private final Client client;
    private final List<Location> locations;
    private final List<Location> competitors;
    private final String serviceUrl;
    private final String apiKey;
    private final Boolean showDetails;
    private final Boolean forceRecalculate;
    private final Boolean cacheResult;
    private final String ratingId;

    public RatingRequest(String serviceUrl, String apiKey, String ratingId, List<Location> locations) {
        this(ClientBuilder.newClient(), locations, null, serviceUrl, apiKey, null, null, null, ratingId);
    }

    public RatingRequest(String serviceUrl, String key, String ratingId, List<Location> locations, List<Location> competitors) {
        this(ClientBuilder.newClient(), locations, competitors, serviceUrl, key, null, null, null, ratingId);
    }

    public RatingRequest(String serviceUrl, String key, String ratingId, List<Location> locations, List<Location> competitors, boolean showDetails, boolean forceRecalculate, boolean cacheResult) {
        this(ClientBuilder.newClient(), locations, competitors, serviceUrl, key, showDetails, forceRecalculate, cacheResult, ratingId);
    }

    public RatingRequest(String serviceUrl, String key, String ratingId, List<Location> locations, boolean showDetails, boolean forceRecalculate, boolean cacheResult) {
        this(ClientBuilder.newClient(), locations, null, serviceUrl, key, showDetails, forceRecalculate, cacheResult, ratingId);
    }

    public ScoreResponse get() throws TargomoClientException {
        WebTarget request = this.client.target(this.serviceUrl).path("v1/rating").path(this.ratingId).path("/location").queryParam("apiKey", new Object[]{this.apiKey});
        if (this.showDetails != null) {
            request = request.queryParam("showDetails", new Object[]{this.showDetails});
        }
        if (this.forceRecalculate != null) {
            request = request.queryParam("forceRecalculate", new Object[]{this.forceRecalculate});
        }
        if (this.cacheResult != null) {
            request = request.queryParam("cacheResult", new Object[]{this.cacheResult});
        }
        String config = RequestConfigurator.getConfig(this.locations, this.competitors);
        Response response = request.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return ScoreRequest.validateResponse(response);
    }

    public RatingRequest(Client client, List<Location> locations, List<Location> competitors, String serviceUrl, String apiKey, Boolean showDetails, Boolean forceRecalculate, Boolean cacheResult, String ratingId) {
        this.client = client;
        this.locations = locations;
        this.competitors = competitors;
        this.serviceUrl = serviceUrl;
        this.apiKey = apiKey;
        this.showDetails = showDetails;
        this.forceRecalculate = forceRecalculate;
        this.cacheResult = cacheResult;
        this.ratingId = ratingId;
    }
}

