/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.StatisticTravelOptions;
import com.targomo.client.api.enums.EdgeWeightType;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.request.config.JacksonRequestConfigurator;
import com.targomo.client.api.request.enums.StatisticMethod;
import com.targomo.client.api.response.StatisticsGeometryValuesResponse;
import com.targomo.client.api.response.StatisticsResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsRequest.class);
    private static final String VALUES_GEOMETRY = "values/geometry";
    private final Client client;
    private final StatisticTravelOptions travelOptions;
    private final MultivaluedMap<String, Object> headers;

    public StatisticsRequest(StatisticTravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
        this.headers = new MultivaluedHashMap();
    }

    public StatisticsRequest(Client client, StatisticTravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = new MultivaluedHashMap();
    }

    public StatisticsRequest(Client client, StatisticTravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = headers;
    }

    public StatisticsResponse get(StatisticMethod method) throws TargomoClientException {
        return this.get(method.getPath(), this::validateResponse);
    }

    public StatisticsGeometryValuesResponse getValuesGeometry() throws TargomoClientException {
        return this.get(VALUES_GEOMETRY, this::validateGeometryValuesResponse);
    }

    public <T> T get(String path, ResponseValidator<T> responseValidator) throws TargomoClientException {
        Response response;
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getStatisticServiceUrl()).path(path).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("serviceUrl", new Object[]{this.travelOptions.getServiceUrl()});
        if (this.travelOptions.getInterServiceKey() != null) {
            target = target.queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()});
        }
        if (this.travelOptions.getInterServiceRequestType() != null) {
            target = target.queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        }
        if (VALUES_GEOMETRY.equals(path) && this.travelOptions.getStatisticIds() != null && this.travelOptions.getValuesGeometryAggregation() != null) {
            for (Short statisticId : this.travelOptions.getStatisticIds()) {
                target = target.queryParam("aggregations", new Object[]{statisticId + "-" + this.travelOptions.getValuesGeometryAggregation()});
            }
        }
        Entity entity = Entity.entity((Object)JacksonRequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug("Executing statistics request ({}) to URI: '{}'", (Object)path, (Object)target.getUri());
        try {
            response = target.request().headers(this.headers).post(entity);
        }
        catch (ProcessingException exception) {
            LOGGER.error("Error executing statistics request ({}) to URI: '{}'", new Object[]{path, target.getUri(), exception});
            target = this.client.target(this.travelOptions.getFallbackServiceUrl()).path(path).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
            if (this.travelOptions.getInterServiceKey() != null) {
                target = target.queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()});
            }
            if (this.travelOptions.getInterServiceRequestType() != null) {
                target = target.queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
            }
            LOGGER.debug("Executing statistics request ({}) to URI: '{}'", (Object)path, (Object)target.getUri());
            response = target.request().headers(this.headers).post(entity);
        }
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return responseValidator.validateResponse(response, requestStart, roundTripTime);
    }

    public static void main(String[] args) throws TargomoClientException {
        StatisticTravelOptions options = new StatisticTravelOptions();
        options.setMaxEdgeWeight(1800);
        options.setEdgeWeightType(EdgeWeightType.TIME);
        options.setTravelType(TravelType.WALK);
        options.addSource(new DefaultSourceCoordinate("1asda", 13.405, 52.52));
        options.setServiceUrl("http://localhost:8081/");
        options.setFallbackServiceUrl("http://localhost:8081/");
        options.setStatisticServiceUrl("http://localhost:8080/");
        options.setServiceKey("uhWrWpUhyZQy8rPfiC7X");
        options.setDate(20150812);
        options.setTime(43200);
        options.setAppendTravelTimes(true);
        options.setStatisticIds(Arrays.asList((short)0, (short)1));
        options.setStatisticGroupId(1);
        StatisticsResponse response = new StatisticsRequest(options).get(StatisticMethod.CHARTS_DEPENDENT);
        LOGGER.info("{}", (Object)response.getStatisticResult());
    }

    private <T> T validateResponse(Response response, Supplier<T> responseSupplier, Supplier<T> gatewayTimeOutResponseSupplier) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return responseSupplier.get();
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return gatewayTimeOutResponseSupplier.get();
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    private StatisticsResponse validateResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        return this.validateResponse(response, () -> new StatisticsResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart), () -> new StatisticsResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart));
    }

    private StatisticsGeometryValuesResponse validateGeometryValuesResponse(Response response, long requestStart, long roundTripTime) throws TargomoClientException {
        return this.validateResponse(response, () -> new StatisticsGeometryValuesResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart), () -> new StatisticsGeometryValuesResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart));
    }

    @FunctionalInterface
    public static interface ResponseValidator<T> {
        public T validateResponse(Response var1, long var2, long var4) throws TargomoClientException;
    }
}

