/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractCoordinate;
import com.targomo.client.api.pojo.LocationProperties;
import com.targomo.client.api.util.SerializationUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="source_coordinate")
public class DefaultSourceCoordinate
extends AbstractCoordinate {
    @Id
    @Column(name="identifier")
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long identifier;
    @Column(name="travel_types")
    private List<TravelType> travelTypes;

    public DefaultSourceCoordinate() {
    }

    public DefaultSourceCoordinate(String id, double x, double y, List<TravelType> travelTypes, LocationProperties locationProperties) {
        super(id, x, y, locationProperties);
        this.travelTypes = travelTypes;
    }

    public DefaultSourceCoordinate(String id, double x, double y, TravelType travelType, LocationProperties locationProperties) {
        this(id, x, y, travelType == null ? Collections.emptyList() : Collections.singletonList(travelType), locationProperties);
    }

    public DefaultSourceCoordinate(String id, double x, double y, TravelType travelType) {
        this(id, x, y, travelType, null);
    }

    public DefaultSourceCoordinate(String id, double x, double y) {
        this(id, x, y, Collections.emptyList(), null);
    }

    public DefaultSourceCoordinate(String id, double x, double y, LocationProperties locationProperties) {
        this(id, x, y, Collections.emptyList(), locationProperties);
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long id) {
        this.identifier = id;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" { id: ");
        builder.append(this.getId());
        builder.append(", x: ");
        builder.append(this.getX());
        builder.append(", y: ");
        builder.append(this.getY());
        builder.append(", travelTypes: ");
        builder.append(SerializationUtil.travelTypeListToString(this.travelTypes));
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSourceCoordinate that = (DefaultSourceCoordinate)o;
        return Objects.equals(this.travelTypes, that.travelTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.travelTypes != null ? this.travelTypes.hashCode() : 0);
        return result;
    }

    @Override
    public void setTravelTypes(List<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    @Override
    public List<TravelType> getTravelTypes() {
        return this.travelTypes;
    }
}

