/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.PointOfInterestGravitationResponse;
import com.targomo.client.api.response.PointOfInterestResponse;
import com.targomo.client.api.response.PointOfInterestSummaryResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointOfInterestRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointOfInterestRequest.class);
    private final Client client;
    private final TravelOptions travelOptions;
    private final MultivaluedMap<String, Object> headers;

    public PointOfInterestRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
        this.headers = new MultivaluedHashMap();
    }

    public PointOfInterestRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = new MultivaluedHashMap();
    }

    public PointOfInterestRequest(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = headers;
    }

    public PointOfInterestResponse get() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/reachability");
        return this.validateResponse(response, requestStart, true);
    }

    public PointOfInterestSummaryResponse getSummary() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/reachability/summary");
        return this.validateSummaryResponse(response, requestStart);
    }

    public PointOfInterestResponse getPOIsWithinGeometry() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/geometry");
        return this.validateResponse(response, requestStart, false);
    }

    public PointOfInterestSummaryResponse getPOIsWithinGeometrySummary() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/geometry/summary");
        return this.validateSummaryResponse(response, requestStart);
    }

    public PointOfInterestGravitationResponse getGravitationAnalysis() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        Response response = this.getResponse("/gravitation");
        return this.validateGravitationResponse(response, requestStart);
    }

    private Response getResponse(String path) throws TargomoClientException {
        WebTarget target = this.client.target(this.travelOptions.getPointOfInterestServiceUrl()).path(path).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("forceRecalculate", new Object[]{this.travelOptions.isForceRecalculate()}).queryParam("cacheResult", new Object[]{this.travelOptions.isCacheResult()});
        if (this.travelOptions.getInterServiceKey() != null) {
            target = target.queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()});
        }
        if (this.travelOptions.getInterServiceRequestType() != null) {
            target = target.queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        }
        if (this.travelOptions.getFormat() == null) {
            this.travelOptions.setFormat(Format.JSON);
        }
        LOGGER.debug("Executing POI request to URI: '{}}'", (Object)target.getUri());
        String config = RequestConfigurator.getConfig(this.travelOptions);
        Entity entity = Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        return target.request().headers(this.headers).post(entity);
    }

    private PointOfInterestResponse validateResponse(Response response, long requestStart, boolean resultContainsEdgeWeights) throws TargomoClientException {
        return this.validateResponse(response, () -> new PointOfInterestResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), resultContainsEdgeWeights, requestStart));
    }

    private PointOfInterestSummaryResponse validateSummaryResponse(Response response, long requestStart) throws TargomoClientException {
        return this.validateResponse(response, () -> new PointOfInterestSummaryResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart));
    }

    private PointOfInterestGravitationResponse validateGravitationResponse(Response response, long requestStart) throws TargomoClientException {
        return this.validateResponse(response, () -> new PointOfInterestGravitationResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart));
    }

    private <T> T validateResponse(Response response, Supplier<T> responseSupplier) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return responseSupplier.get();
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

