/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractLocation;
import com.targomo.client.api.geo.Location;
import com.targomo.client.api.pojo.LocationProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public class DefaultSourceAddress
extends AbstractLocation
implements Location {
    @Id
    @Column(name="identifier")
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long identifier;
    @Column(name="travel_types")
    private List<TravelType> travelTypes;
    private String h3Address;

    public DefaultSourceAddress() {
    }

    public DefaultSourceAddress(String h3Address, List<TravelType> travelTypes, LocationProperties locationProperties) {
        super(null, locationProperties);
        this.h3Address = h3Address;
        this.travelTypes = travelTypes;
    }

    public DefaultSourceAddress(String h3Address, TravelType travelType, LocationProperties locationProperties) {
        this(h3Address, Collections.singletonList(travelType), locationProperties);
    }

    public DefaultSourceAddress(String h3Address, LocationProperties locationProperties) {
        this(h3Address, Collections.emptyList(), locationProperties);
    }

    public DefaultSourceAddress(String h3Address, TravelType travelType) {
        this(h3Address, travelType, null);
    }

    public DefaultSourceAddress(String h3Address) {
        this(h3Address, Collections.emptyList(), null);
    }

    @Override
    public void setTravelType(TravelType travelType) {
        this.setTravelTypes(travelType == null ? Collections.emptyList() : Collections.singletonList(travelType));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\th3Address: ");
        builder.append(this.h3Address);
        builder.append("\n}\n");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSourceAddress that = (DefaultSourceAddress)o;
        return Objects.equals(this.travelTypes, that.travelTypes) && Objects.equals(this.h3Address, that.h3Address);
    }

    public int hashCode() {
        int result = this.h3Address.hashCode();
        result = 31 * result + (this.travelTypes != null ? this.travelTypes.hashCode() : 0);
        return result;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<TravelType> getTravelTypes() {
        return this.travelTypes;
    }

    public String getH3Address() {
        return this.h3Address;
    }

    public void setIdentifier(long identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setTravelTypes(List<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    public void setH3Address(String h3Address) {
        this.h3Address = h3Address;
    }
}

