/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.quality;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.targomo.client.api.pojo.LocationProperties;
import org.geojson.GeoJsonObject;

public class Location {
    private String id;
    private final Double lat;
    private final Double lng;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer crs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final GeoJsonObject geometry;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String collectionId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final LocationProperties properties;
    @JsonIgnore
    private final boolean point;
    @JsonIgnore
    private final boolean reference;
    @JsonIgnore
    private boolean competitor;
    @JsonIgnore
    private boolean potential;

    public Location(String id, Double lat, Double lng, LocationProperties properties) {
        this(id, lat, lng, null, null, null, properties, true, false, false, false);
    }

    protected Location(LocationBuilder<?, ?> b) {
        this.id = ((LocationBuilder)b).id;
        this.lat = ((LocationBuilder)b).lat;
        this.lng = ((LocationBuilder)b).lng;
        this.crs = ((LocationBuilder)b).crs;
        this.geometry = ((LocationBuilder)b).geometry;
        this.collectionId = ((LocationBuilder)b).collectionId;
        this.properties = ((LocationBuilder)b).properties;
        this.point = ((LocationBuilder)b).point;
        this.reference = ((LocationBuilder)b).reference;
        this.competitor = ((LocationBuilder)b).competitor;
        this.potential = ((LocationBuilder)b).potential;
    }

    public static LocationBuilder<?, ?> builder() {
        return new LocationBuilderImpl();
    }

    public LocationBuilder<?, ?> toBuilder() {
        return new LocationBuilderImpl().$fillValuesFrom(this);
    }

    public String getId() {
        return this.id;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLng() {
        return this.lng;
    }

    public Integer getCrs() {
        return this.crs;
    }

    public GeoJsonObject getGeometry() {
        return this.geometry;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public LocationProperties getProperties() {
        return this.properties;
    }

    public boolean isPoint() {
        return this.point;
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isCompetitor() {
        return this.competitor;
    }

    public boolean isPotential() {
        return this.potential;
    }

    public Location(String id, Double lat, Double lng, Integer crs, GeoJsonObject geometry, String collectionId, LocationProperties properties, boolean point, boolean reference, boolean competitor, boolean potential) {
        this.id = id;
        this.lat = lat;
        this.lng = lng;
        this.crs = crs;
        this.geometry = geometry;
        this.collectionId = collectionId;
        this.properties = properties;
        this.point = point;
        this.reference = reference;
        this.competitor = competitor;
        this.potential = potential;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPoint() != other.isPoint()) {
            return false;
        }
        if (this.isReference() != other.isReference()) {
            return false;
        }
        if (this.isCompetitor() != other.isCompetitor()) {
            return false;
        }
        if (this.isPotential() != other.isPotential()) {
            return false;
        }
        Double this$lat = this.getLat();
        Double other$lat = other.getLat();
        if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
            return false;
        }
        Double this$lng = this.getLng();
        Double other$lng = other.getLng();
        if (this$lng == null ? other$lng != null : !((Object)this$lng).equals(other$lng)) {
            return false;
        }
        Integer this$crs = this.getCrs();
        Integer other$crs = other.getCrs();
        if (this$crs == null ? other$crs != null : !((Object)this$crs).equals(other$crs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        GeoJsonObject this$geometry = this.getGeometry();
        GeoJsonObject other$geometry = other.getGeometry();
        if (this$geometry == null ? other$geometry != null : !this$geometry.equals(other$geometry)) {
            return false;
        }
        String this$collectionId = this.getCollectionId();
        String other$collectionId = other.getCollectionId();
        if (this$collectionId == null ? other$collectionId != null : !this$collectionId.equals(other$collectionId)) {
            return false;
        }
        LocationProperties this$properties = this.getProperties();
        LocationProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPoint() ? 79 : 97);
        result = result * 59 + (this.isReference() ? 79 : 97);
        result = result * 59 + (this.isCompetitor() ? 79 : 97);
        result = result * 59 + (this.isPotential() ? 79 : 97);
        Double $lat = this.getLat();
        result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
        Double $lng = this.getLng();
        result = result * 59 + ($lng == null ? 43 : ((Object)$lng).hashCode());
        Integer $crs = this.getCrs();
        result = result * 59 + ($crs == null ? 43 : ((Object)$crs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        GeoJsonObject $geometry = this.getGeometry();
        result = result * 59 + ($geometry == null ? 43 : $geometry.hashCode());
        String $collectionId = this.getCollectionId();
        result = result * 59 + ($collectionId == null ? 43 : $collectionId.hashCode());
        LocationProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCrs(Integer crs) {
        this.crs = crs;
    }

    @JsonIgnore
    public void setCompetitor(boolean competitor) {
        this.competitor = competitor;
    }

    @JsonIgnore
    public void setPotential(boolean potential) {
        this.potential = potential;
    }

    public static abstract class LocationBuilder<C extends Location, B extends LocationBuilder<C, B>> {
        private String id;
        private Double lat;
        private Double lng;
        private Integer crs;
        private GeoJsonObject geometry;
        private String collectionId;
        private LocationProperties properties;
        private boolean point;
        private boolean reference;
        private boolean competitor;
        private boolean potential;

        protected B $fillValuesFrom(C instance) {
            LocationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Location instance, LocationBuilder<?, ?> b) {
            b.id(instance.id);
            b.lat(instance.lat);
            b.lng(instance.lng);
            b.crs(instance.crs);
            b.geometry(instance.geometry);
            b.collectionId(instance.collectionId);
            b.properties(instance.properties);
            b.point(instance.point);
            b.reference(instance.reference);
            b.competitor(instance.competitor);
            b.potential(instance.potential);
        }

        protected abstract B self();

        public abstract C build();

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B lat(Double lat) {
            this.lat = lat;
            return this.self();
        }

        public B lng(Double lng) {
            this.lng = lng;
            return this.self();
        }

        public B crs(Integer crs) {
            this.crs = crs;
            return this.self();
        }

        public B geometry(GeoJsonObject geometry) {
            this.geometry = geometry;
            return this.self();
        }

        public B collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this.self();
        }

        public B properties(LocationProperties properties) {
            this.properties = properties;
            return this.self();
        }

        @JsonIgnore
        public B point(boolean point) {
            this.point = point;
            return this.self();
        }

        @JsonIgnore
        public B reference(boolean reference) {
            this.reference = reference;
            return this.self();
        }

        @JsonIgnore
        public B competitor(boolean competitor) {
            this.competitor = competitor;
            return this.self();
        }

        @JsonIgnore
        public B potential(boolean potential) {
            this.potential = potential;
            return this.self();
        }

        public String toString() {
            return "Location.LocationBuilder(id=" + this.id + ", lat=" + this.lat + ", lng=" + this.lng + ", crs=" + this.crs + ", geometry=" + this.geometry + ", collectionId=" + this.collectionId + ", properties=" + this.properties + ", point=" + this.point + ", reference=" + this.reference + ", competitor=" + this.competitor + ", potential=" + this.potential + ")";
        }
    }

    private static final class LocationBuilderImpl
    extends LocationBuilder<Location, LocationBuilderImpl> {
        private LocationBuilderImpl() {
        }

        @Override
        protected LocationBuilderImpl self() {
            return this;
        }

        @Override
        public Location build() {
            return new Location(this);
        }
    }
}

