/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ResponseCode;
import com.targomo.client.api.response.RouteResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class RouteRequest {
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public RouteRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public RouteRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public RouteResponse get() throws TargomoClientException, ResponseErrorException {
        long requestStart = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path("v1/route").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("cfg", new Object[]{IOUtil.encode(RequestConfigurator.getConfig(this.travelOptions))});
        Response response = request.request().get();
        return this.validateResponse(response);
    }

    public String toCurl() throws TargomoClientException {
        String url = this.travelOptions.getServiceUrl().endsWith("/") ? this.travelOptions.getServiceUrl() : this.travelOptions.getServiceUrl() + "/";
        return "curl -X GET '" + url + "v1/route?cb=" + CALLBACK + "&key=" + this.travelOptions.getServiceKey() + "&cfg=" + IOUtil.encode(RequestConfigurator.getConfig(this.travelOptions)) + "'";
    }

    private RouteResponse validateResponse(Response response) throws TargomoClientException, ResponseErrorException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String message;
            JSONObject result = JsonUtil.parseString(IOUtil.getResultString(response));
            ResponseCode code = ResponseCode.fromString(JsonUtil.getString(result, "code"));
            String string = message = result.has("message") ? JsonUtil.getString(result, "message") : "";
            if (code != ResponseCode.OK) {
                String msg = "Route request returned an error";
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    msg = msg + ": " + message;
                }
                throw new ResponseErrorException(code, msg);
            }
            return new RouteResponse(this.travelOptions, JsonUtil.getJsonArray(JsonUtil.getJSONObject(result, "data"), "routes"), code, result.has("requestTime") ? (long)JsonUtil.getInt(result, "requestTime").intValue() : -1L);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

