/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.request.ssl.SslClientGenerator;
import com.targomo.client.api.response.DefaultResponse;
import com.targomo.client.api.response.ResponseCode;
import com.targomo.client.api.util.IOUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class TargomoRequest<R extends DefaultResponse<?, ?>> {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CALLBACK = "callback";
    private final Class<R> clazz;
    private final String httpMethod;
    private final String path;
    private final Client client;
    private final TravelOptions travelOptions;
    private final MultivaluedMap<String, Object> headers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <O extends DefaultResponse<?, ?>, C extends TargomoRequest<O>> O executeRequest(BiFunction<Client, TravelOptions, C> constructor, TravelOptions travelOptions) throws TargomoClientException, ResponseErrorException {
        try (Client client = SslClientGenerator.initClient();){
            Object r = ((TargomoRequest)constructor.apply(client, travelOptions)).get();
            return (O)r;
        }
    }

    TargomoRequest(Client client, TravelOptions travelOptions, String path, String httpMethod, Class<R> clazz, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.path = path;
        this.httpMethod = httpMethod;
        this.clazz = clazz;
        this.headers = headers;
    }

    public String toCurl() throws TargomoClientException {
        String url = this.travelOptions.getServiceUrl().endsWith("/") ? this.travelOptions.getServiceUrl() : this.travelOptions.getServiceUrl() + "/";
        return "curl -X " + this.httpMethod + " '" + url + this.path + "?cb=" + CALLBACK + "&key=" + this.travelOptions.getServiceKey() + "' -H 'content-type: application/json' " + this.headers.entrySet().stream().map(entry -> "-H '" + (String)entry.getKey() + ": " + ((List)entry.getValue()).stream().map(Objects::toString).collect(Collectors.joining(", ")) + "' ").collect(Collectors.joining()) + "-d '" + RequestConfigurator.getConfig(this.travelOptions) + "'";
    }

    public R get() throws TargomoClientException, ResponseErrorException {
        Response response;
        long startTimeMillis = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path(this.path).queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()}).queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        String config = RequestConfigurator.getConfig(this.travelOptions);
        if ("GET".equals(this.httpMethod)) {
            request = request.queryParam("cfg", new Object[]{IOUtil.encode(config)});
            Invocation.Builder invocationBuilder = request.request();
            if (!this.headers.isEmpty()) {
                invocationBuilder = request.request().headers(this.headers);
            }
            response = invocationBuilder.get();
        } else if ("POST".equals(this.httpMethod)) {
            Invocation.Builder invocationBuilder = request.request();
            if (!this.headers.isEmpty()) {
                invocationBuilder = request.request().headers(this.headers);
            }
            response = invocationBuilder.post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        } else {
            throw new TargomoClientException("HTTP Method not supported: " + this.httpMethod);
        }
        return this.validateResponse(response, System.currentTimeMillis() - startTimeMillis);
    }

    private R validateResponse(Response response, long roundTripTimeMillis) throws TargomoClientException, ResponseErrorException {
        DefaultResponse parsedResponse = null;
        long startParsing = System.currentTimeMillis();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String resultString = IOUtil.getResultString(response);
            try {
                parsedResponse = (DefaultResponse)MAPPER.readValue(resultString, this.clazz);
            }
            catch (IOException e) {
                throw new TargomoClientException("Exception occurred for result: " + resultString, e, response.getStatus());
            }
        } else {
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new TargomoClientException(String.format("Service not found: %s", this.travelOptions.getServiceUrl()), response.getStatus());
            }
            throw new TargomoClientException(String.format("Request failed with %s: %s", response.getStatus(), response.readEntity(String.class)), response.getStatus());
        }
        if (parsedResponse.getCode() != ResponseCode.OK) {
            String msg = "Request returned an error";
            if (!StringUtils.isEmpty((CharSequence)parsedResponse.getMessage())) {
                msg = msg + ": " + parsedResponse.getMessage();
            }
            throw new ResponseErrorException(parsedResponse.getCode(), msg);
        }
        parsedResponse.finishDeserialization(this.travelOptions, roundTripTimeMillis, System.currentTimeMillis() - startParsing);
        return (R)parsedResponse;
    }
}

