/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request.esri;

import javax.annotation.Nonnull;

public class ESRIAuthenticationDetails {
    private static final Integer MAX_TOKEN_EXPIRATION = 20160;
    private final String clientID;
    private final String clientSecret;
    private final Integer tokenExpirationInMinutes;

    public ESRIAuthenticationDetails(@Nonnull String clientID, @Nonnull String clientSecret) {
        this(clientID, clientSecret, MAX_TOKEN_EXPIRATION);
    }

    public ESRIAuthenticationDetails(@Nonnull String clientID, @Nonnull String clientSecret, @Nonnull Integer tokenExpirationInMinutes) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        if (tokenExpirationInMinutes < 1) {
            throw new IllegalArgumentException("tokenExpirationInMinutes has to be a positive number, but was " + tokenExpirationInMinutes);
        }
        this.tokenExpirationInMinutes = tokenExpirationInMinutes;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Integer getTokenExpirationInMinutes() {
        return this.tokenExpirationInMinutes;
    }
}

