/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractGeometry;
import com.targomo.client.api.pojo.LocationProperties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="source_geometry")
public class DefaultSourceGeometry
extends AbstractGeometry {
    @Id
    @Column(name="identifier")
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long identifier;
    @Column(name="travel_type")
    private TravelType travelType;

    private DefaultSourceGeometry() {
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType, LocationProperties locationProperties) {
        super(id, crs, geojson, locationProperties);
        this.travelType = travelType;
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType) {
        this(id, geojson, crs, travelType, null);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs) {
        this(id, geojson, crs, null, null);
    }

    @Override
    public TravelType getTravelType() {
        return this.travelType;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long id) {
        this.identifier = id;
    }

    @Override
    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" { id: ");
        builder.append(this.getId());
        builder.append(", data: ");
        builder.append(this.getData());
        builder.append(", crs: ");
        builder.append(this.getCrs());
        builder.append(", travelType: ");
        builder.append((Object)this.travelType);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSourceGeometry that = (DefaultSourceGeometry)o;
        return this.travelType == that.travelType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.travelType != null ? this.travelType.hashCode() : 0);
        return result;
    }
}

