/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.MultiGraphTravelTimeApproximation;
import com.targomo.client.api.enums.RoutingAggregationType;
import com.targomo.client.api.geo.AbstractGeometry;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.geo.DefaultSourceAddress;
import com.targomo.client.api.geo.DefaultSourceCoordinate;
import com.targomo.client.api.geo.DefaultSourceGeometry;
import com.targomo.client.api.json.DefaultSourceAddressMapDeserializer;
import com.targomo.client.api.json.DefaultSourceAddressMapSerializer;
import com.targomo.client.api.json.DefaultSourceCoordinateMapDeserializer;
import com.targomo.client.api.json.DefaultSourceCoordinateMapSerializer;
import com.targomo.client.api.json.DefaultSourceGeometriesMapDeserializer;
import com.targomo.client.api.json.DefaultSourceGeometriesMapSerializer;
import com.targomo.client.api.pojo.CompetingRoutingOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="statistic_travel_option")
@JsonIgnoreProperties(ignoreUnknown=true)
public class StatisticTravelOptions
extends TravelOptions {
    @JsonDeserialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapSerializer.class)
    @Transient
    private Map<String, Coordinate> inactiveSources = new HashMap<String, Coordinate>();
    @JsonDeserialize(contentAs=DefaultSourceAddress.class, using=DefaultSourceAddressMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceAddress.class, using=DefaultSourceAddressMapSerializer.class)
    @Transient
    private Map<String, DefaultSourceAddress> inactiveSourceAddresses = new HashMap<String, DefaultSourceAddress>();
    @JsonDeserialize(contentAs=DefaultSourceGeometry.class, using=DefaultSourceGeometriesMapDeserializer.class)
    @JsonSerialize(contentAs=DefaultSourceGeometry.class, using=DefaultSourceGeometriesMapSerializer.class)
    @Transient
    private Map<String, AbstractGeometry> inactiveGeometrySources = new HashMap<String, AbstractGeometry>();
    @Column(name="get_closest_sources")
    private boolean getClosestSources = false;
    @Column(name="omit_individual_statistics")
    private boolean omitIndividualStatistics = false;
    @Transient
    private List<Integer> cellIds = new ArrayList<Integer>();
    @Transient
    private Map<String, Short> multiGraphReferencedStatisticIds = null;
    @Transient
    private MultiGraphTravelTimeApproximation multiGraphTravelTimeApproximation = null;
    @Transient
    private Integer multiGraphDomainStatisticGroupId = null;
    @Transient
    private Integer multiGraphDomainStatisticCollectionId = null;
    @Transient
    private Boolean multiGraphLayerUnboundedStatistics = null;
    @Transient
    private List<Short> statisticIds;
    @Transient
    private Integer chartInterval;
    @Transient
    private Integer statisticCollectionId;
    @Transient
    private List<CompetingRoutingOption> competingRoutingOptions;
    @Transient
    private RoutingAggregationType routingAggregationType = RoutingAggregationType.MIN;
    @Transient
    private String valuesGeometryAggregation;
    @Transient
    private Double filterStatsValuesByPercentile;
    @Transient
    private boolean multigraphCalculateGravitationPerReferenceId = true;
    @Transient
    private Boolean returnOriginId = false;
    @Transient
    private Boolean multiGraphIgnoreRoutingErrorMessages = false;
    @Transient
    private boolean useStatisticTargets = false;
    @Transient
    private String customGeometryCollectionId;
    @Transient
    private List<String> customGeometryFeatureIds = new ArrayList<String>();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatisticTravelOptions)) {
            return false;
        }
        StatisticTravelOptions that = (StatisticTravelOptions)o;
        return super.equals(o) && Objects.equals(this.useStatisticTargets, that.useStatisticTargets) && Objects.equals(this.getClosestSources, that.getClosestSources) && Objects.equals(this.omitIndividualStatistics, that.omitIndividualStatistics) && Objects.equals(this.inactiveSources, that.inactiveSources) && Objects.equals(this.inactiveGeometrySources, that.inactiveGeometrySources) && Objects.equals(this.inactiveSourceAddresses, that.inactiveSourceAddresses) && Objects.equals(this.cellIds, that.cellIds) && Objects.equals(this.multiGraphDomainStatisticGroupId, that.multiGraphDomainStatisticGroupId) && Objects.equals(this.multiGraphDomainStatisticCollectionId, that.multiGraphDomainStatisticCollectionId) && Objects.equals(this.multiGraphLayerUnboundedStatistics, that.multiGraphLayerUnboundedStatistics) && Objects.equals(this.multiGraphReferencedStatisticIds, that.multiGraphReferencedStatisticIds) && this.multiGraphTravelTimeApproximation == that.multiGraphTravelTimeApproximation && Objects.equals(this.statisticIds, that.statisticIds) && Objects.equals(this.chartInterval, that.chartInterval) && Objects.equals(this.statisticCollectionId, that.statisticCollectionId) && Objects.equals(this.multigraphCalculateGravitationPerReferenceId, that.multigraphCalculateGravitationPerReferenceId) && Objects.equals(this.returnOriginId, that.returnOriginId) && Objects.equals(this.customGeometryCollectionId, that.customGeometryCollectionId) && Objects.equals(this.customGeometryFeatureIds, that.customGeometryFeatureIds) && Objects.equals(this.competingRoutingOptions, that.competingRoutingOptions) && Objects.equals((Object)this.routingAggregationType, (Object)that.routingAggregationType) && Objects.equals(this.multiGraphIgnoreRoutingErrorMessages, that.multiGraphIgnoreRoutingErrorMessages) && Objects.equals(this.valuesGeometryAggregation, that.valuesGeometryAggregation) && Objects.equals(this.filterStatsValuesByPercentile, that.filterStatsValuesByPercentile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.inactiveSources, this.inactiveGeometrySources, this.inactiveSourceAddresses, this.useStatisticTargets, this.getClosestSources, this.omitIndividualStatistics, this.cellIds, this.multiGraphDomainStatisticGroupId, this.multiGraphDomainStatisticCollectionId, this.multiGraphLayerUnboundedStatistics, this.multiGraphReferencedStatisticIds, this.multiGraphTravelTimeApproximation, this.statisticIds, this.chartInterval, this.statisticCollectionId, this.multigraphCalculateGravitationPerReferenceId, this.returnOriginId, this.customGeometryCollectionId, this.customGeometryFeatureIds, this.competingRoutingOptions, this.routingAggregationType.ordinal(), this.multiGraphIgnoreRoutingErrorMessages, this.valuesGeometryAggregation, this.filterStatsValuesByPercentile});
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(this.getClass().getName());
        builder.append("\n\tinactiveSources: ");
        builder.append(Arrays.toString(this.inactiveSources.entrySet().toArray()));
        builder.append("\n\tinactiveGeometrySources: ");
        builder.append(Arrays.toString(this.inactiveGeometrySources.entrySet().toArray()));
        builder.append("\n\tinactiveSourceAddresses: ");
        builder.append(Arrays.toString(this.inactiveSourceAddresses.entrySet().toArray()));
        builder.append("\n\tomitIndividualStatistics: ");
        builder.append(this.omitIndividualStatistics);
        builder.append("\n\tcellIds: ");
        builder.append(this.cellIds != null ? this.cellIds.toString() : "[]");
        builder.append("\n\tmultiGraphReferencedStatisticIds: ");
        builder.append(this.multiGraphReferencedStatisticIds != null ? this.multiGraphReferencedStatisticIds.toString() : "[]");
        builder.append("\n\tmultiGraphDomainStatisticGroupId: ");
        builder.append(this.multiGraphDomainStatisticGroupId);
        builder.append("\n\tmultiGraphDomainStatisticCollectionId: ");
        builder.append(this.multiGraphDomainStatisticCollectionId);
        builder.append("\n\tmultiGraphLayerUnboundedStatistics: ");
        builder.append(this.multiGraphLayerUnboundedStatistics);
        builder.append("\n\tmultiGraphTravelTimeApproximation: ");
        builder.append((Object)this.multiGraphTravelTimeApproximation);
        builder.append("\n\tstatisticIds: ");
        builder.append(this.statisticIds != null ? this.statisticIds.toString() : "[]");
        builder.append("\n\tchartInterval: ");
        builder.append(this.chartInterval);
        builder.append("\n\tstatisticsCollectionId: ");
        builder.append(this.statisticCollectionId);
        builder.append("\n\tmultigraphCalculateGravitationPerReferenceId: ");
        builder.append(this.multigraphCalculateGravitationPerReferenceId);
        builder.append("\n\treturnOriginId: ");
        builder.append(this.returnOriginId);
        builder.append("\n\tcustomGeometryCollectionId: ");
        builder.append(this.customGeometryCollectionId);
        builder.append("\n\tcustomGeometryFeatureIds: ");
        builder.append(this.customGeometryFeatureIds != null ? this.customGeometryFeatureIds.toString() : "[]");
        builder.append("\n\tcompetingRoutingOptions: ");
        builder.append(this.competingRoutingOptions);
        builder.append("\n\troutingAggregationType: ");
        builder.append((Object)this.routingAggregationType);
        builder.append("\n\tmultiGraphIgnoreRoutingErrorMessages: ");
        builder.append(this.multiGraphIgnoreRoutingErrorMessages);
        builder.append("\n\tuseStatisticTargets: ");
        builder.append(this.useStatisticTargets);
        builder.append("\n\tvaluesGeometryAggregation: ");
        builder.append(this.valuesGeometryAggregation);
        builder.append("\n\tfilterStatsValuesByPercentile: ");
        builder.append(this.filterStatsValuesByPercentile);
        builder.append("\n}\n");
        return builder.toString();
    }

    public Map<String, Coordinate> getInactiveSources() {
        return this.inactiveSources;
    }

    public Map<String, DefaultSourceAddress> getInactiveSourceAddresses() {
        return this.inactiveSourceAddresses;
    }

    public Map<String, AbstractGeometry> getInactiveGeometrySources() {
        return this.inactiveGeometrySources;
    }

    public boolean isGetClosestSources() {
        return this.getClosestSources;
    }

    public boolean isOmitIndividualStatistics() {
        return this.omitIndividualStatistics;
    }

    public List<Integer> getCellIds() {
        return this.cellIds;
    }

    public Map<String, Short> getMultiGraphReferencedStatisticIds() {
        return this.multiGraphReferencedStatisticIds;
    }

    public MultiGraphTravelTimeApproximation getMultiGraphTravelTimeApproximation() {
        return this.multiGraphTravelTimeApproximation;
    }

    public Integer getMultiGraphDomainStatisticGroupId() {
        return this.multiGraphDomainStatisticGroupId;
    }

    public Integer getMultiGraphDomainStatisticCollectionId() {
        return this.multiGraphDomainStatisticCollectionId;
    }

    public Boolean getMultiGraphLayerUnboundedStatistics() {
        return this.multiGraphLayerUnboundedStatistics;
    }

    public List<Short> getStatisticIds() {
        return this.statisticIds;
    }

    public Integer getChartInterval() {
        return this.chartInterval;
    }

    public Integer getStatisticCollectionId() {
        return this.statisticCollectionId;
    }

    public List<CompetingRoutingOption> getCompetingRoutingOptions() {
        return this.competingRoutingOptions;
    }

    public RoutingAggregationType getRoutingAggregationType() {
        return this.routingAggregationType;
    }

    public String getValuesGeometryAggregation() {
        return this.valuesGeometryAggregation;
    }

    public Double getFilterStatsValuesByPercentile() {
        return this.filterStatsValuesByPercentile;
    }

    public boolean isMultigraphCalculateGravitationPerReferenceId() {
        return this.multigraphCalculateGravitationPerReferenceId;
    }

    public Boolean getReturnOriginId() {
        return this.returnOriginId;
    }

    public Boolean getMultiGraphIgnoreRoutingErrorMessages() {
        return this.multiGraphIgnoreRoutingErrorMessages;
    }

    public boolean isUseStatisticTargets() {
        return this.useStatisticTargets;
    }

    public String getCustomGeometryCollectionId() {
        return this.customGeometryCollectionId;
    }

    public List<String> getCustomGeometryFeatureIds() {
        return this.customGeometryFeatureIds;
    }

    @JsonDeserialize(contentAs=DefaultSourceCoordinate.class, using=DefaultSourceCoordinateMapDeserializer.class)
    public void setInactiveSources(Map<String, Coordinate> inactiveSources) {
        this.inactiveSources = inactiveSources;
    }

    @JsonDeserialize(contentAs=DefaultSourceAddress.class, using=DefaultSourceAddressMapDeserializer.class)
    public void setInactiveSourceAddresses(Map<String, DefaultSourceAddress> inactiveSourceAddresses) {
        this.inactiveSourceAddresses = inactiveSourceAddresses;
    }

    @JsonDeserialize(contentAs=DefaultSourceGeometry.class, using=DefaultSourceGeometriesMapDeserializer.class)
    public void setInactiveGeometrySources(Map<String, AbstractGeometry> inactiveGeometrySources) {
        this.inactiveGeometrySources = inactiveGeometrySources;
    }

    public void setGetClosestSources(boolean getClosestSources) {
        this.getClosestSources = getClosestSources;
    }

    public void setOmitIndividualStatistics(boolean omitIndividualStatistics) {
        this.omitIndividualStatistics = omitIndividualStatistics;
    }

    public void setCellIds(List<Integer> cellIds) {
        this.cellIds = cellIds;
    }

    public void setMultiGraphReferencedStatisticIds(Map<String, Short> multiGraphReferencedStatisticIds) {
        this.multiGraphReferencedStatisticIds = multiGraphReferencedStatisticIds;
    }

    public void setMultiGraphTravelTimeApproximation(MultiGraphTravelTimeApproximation multiGraphTravelTimeApproximation) {
        this.multiGraphTravelTimeApproximation = multiGraphTravelTimeApproximation;
    }

    public void setMultiGraphDomainStatisticGroupId(Integer multiGraphDomainStatisticGroupId) {
        this.multiGraphDomainStatisticGroupId = multiGraphDomainStatisticGroupId;
    }

    public void setMultiGraphDomainStatisticCollectionId(Integer multiGraphDomainStatisticCollectionId) {
        this.multiGraphDomainStatisticCollectionId = multiGraphDomainStatisticCollectionId;
    }

    public void setMultiGraphLayerUnboundedStatistics(Boolean multiGraphLayerUnboundedStatistics) {
        this.multiGraphLayerUnboundedStatistics = multiGraphLayerUnboundedStatistics;
    }

    public void setStatisticIds(List<Short> statisticIds) {
        this.statisticIds = statisticIds;
    }

    public void setChartInterval(Integer chartInterval) {
        this.chartInterval = chartInterval;
    }

    public void setStatisticCollectionId(Integer statisticCollectionId) {
        this.statisticCollectionId = statisticCollectionId;
    }

    public void setCompetingRoutingOptions(List<CompetingRoutingOption> competingRoutingOptions) {
        this.competingRoutingOptions = competingRoutingOptions;
    }

    public void setRoutingAggregationType(RoutingAggregationType routingAggregationType) {
        this.routingAggregationType = routingAggregationType;
    }

    public void setValuesGeometryAggregation(String valuesGeometryAggregation) {
        this.valuesGeometryAggregation = valuesGeometryAggregation;
    }

    public void setFilterStatsValuesByPercentile(Double filterStatsValuesByPercentile) {
        this.filterStatsValuesByPercentile = filterStatsValuesByPercentile;
    }

    public void setMultigraphCalculateGravitationPerReferenceId(boolean multigraphCalculateGravitationPerReferenceId) {
        this.multigraphCalculateGravitationPerReferenceId = multigraphCalculateGravitationPerReferenceId;
    }

    public void setReturnOriginId(Boolean returnOriginId) {
        this.returnOriginId = returnOriginId;
    }

    public void setMultiGraphIgnoreRoutingErrorMessages(Boolean multiGraphIgnoreRoutingErrorMessages) {
        this.multiGraphIgnoreRoutingErrorMessages = multiGraphIgnoreRoutingErrorMessages;
    }

    public void setUseStatisticTargets(boolean useStatisticTargets) {
        this.useStatisticTargets = useStatisticTargets;
    }

    public void setCustomGeometryCollectionId(String customGeometryCollectionId) {
        this.customGeometryCollectionId = customGeometryCollectionId;
    }

    public void setCustomGeometryFeatureIds(List<String> customGeometryFeatureIds) {
        this.customGeometryFeatureIds = customGeometryFeatureIds;
    }
}

