/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.pojo.EdgeStatisticsReachabilityRequestOptions;
import com.targomo.client.api.response.EdgeStatisticsReachabilityResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeStatisticsReachabilityRequest {
    private static final Logger log = LoggerFactory.getLogger(EdgeStatisticsReachabilityRequest.class);
    private final Client client;
    private final MultivaluedMap<String, Object> headers;
    int edgeStatisticCollectionId;
    EdgeStatisticsReachabilityRequestOptions requestOptions;

    public EdgeStatisticsReachabilityRequest(Client client, int edgeStatisticCollectionId, EdgeStatisticsReachabilityRequestOptions requestOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.headers = headers;
        this.edgeStatisticCollectionId = edgeStatisticCollectionId;
        this.requestOptions = requestOptions;
    }

    public EdgeStatisticsReachabilityRequest(Client client, int edgeStatisticCollectionId, Set<Integer> edgeStatisticIds, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this(client, edgeStatisticCollectionId, new EdgeStatisticsReachabilityRequestOptions(edgeStatisticIds, new HashMap<String, List<Integer>>(), null, travelOptions), headers);
    }

    public EdgeStatisticsReachabilityRequest(Client client, int edgeStatisticCollectionId, Set<Integer> edgeStatisticIds, TravelOptions travelOptions) {
        this(client, edgeStatisticCollectionId, edgeStatisticIds, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public EdgeStatisticsReachabilityRequest(int edgeStatisticCollectionId, Set<Integer> edgeStatisticIds, TravelOptions travelOptions) {
        this(ClientBuilder.newClient(), edgeStatisticCollectionId, edgeStatisticIds, travelOptions);
    }

    public EdgeStatisticsReachabilityResponse get() throws TargomoClientException, JsonProcessingException {
        String path = StringUtils.join(Arrays.asList(String.valueOf(this.edgeStatisticCollectionId), "reachability"), (String)"/");
        WebTarget target = this.client.target(this.requestOptions.getRoutingOptions().getServiceUrl()).path(path).queryParam("key", new Object[]{this.requestOptions.getRoutingOptions().getServiceKey()});
        log.debug(String.format("Executing edge statistics reachability request (%s) to URI: '%s'", path, target.getUri()));
        String requestBody = new ObjectMapper().writeValueAsString((Object)this.requestOptions);
        Entity entity = Entity.entity((Object)requestBody, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response response = target.request().headers(this.headers).post(entity);
        return this.parseResponse(response);
    }

    private EdgeStatisticsReachabilityResponse parseResponse(Response response) throws TargomoClientException {
        String responseStr = (String)response.readEntity(String.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                TypeReference<EdgeStatisticsReachabilityResponse> typeRef = new TypeReference<EdgeStatisticsReachabilityResponse>(){};
                return (EdgeStatisticsReachabilityResponse)new ObjectMapper().readValue(responseStr, (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new TargomoClientRuntimeException("Couldn't parse Edge Statistics reachability response", e);
            }
        }
        throw new TargomoClientException(responseStr, response.getStatus());
    }
}

