/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.pojo.EdgeStatisticsRequestOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeStatisticsRequest {
    private static final Logger log = LoggerFactory.getLogger(EdgeStatisticsRequest.class);
    private final Client client;
    private final MultivaluedMap<String, Object> headers;
    String serviceUrl;
    String serviceKey;
    int edgeStatisticCollectionId;
    private final EdgeStatisticsRequestOptions requestOptions;

    public EdgeStatisticsRequest(Client client, String serviceUrl, String serviceKey, int edgeStatisticCollectionId, EdgeStatisticsRequestOptions requestOptions) {
        this(client, serviceUrl, serviceKey, edgeStatisticCollectionId, requestOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public EdgeStatisticsRequest(String serviceUrl, String serviceKey, int edgeStatisticCollectionId, EdgeStatisticsRequestOptions requestOptions) {
        this(ClientBuilder.newClient(), serviceUrl, serviceKey, edgeStatisticCollectionId, requestOptions);
    }

    public EdgeStatisticsRequest(Client client, String serviceUrl, String serviceKey, int edgeStatisticCollectionId, EdgeStatisticsRequestOptions requestOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.requestOptions = requestOptions;
        this.headers = headers;
        this.serviceUrl = serviceUrl;
        this.serviceKey = serviceKey;
        this.edgeStatisticCollectionId = edgeStatisticCollectionId;
    }

    public Map<String, Map<String, Double>> get() throws TargomoClientException, JsonProcessingException {
        String path = StringUtils.join(Arrays.asList(String.valueOf(this.edgeStatisticCollectionId), "locations"), (String)"/");
        WebTarget target = this.client.target(this.serviceUrl).path(path).queryParam("key", new Object[]{this.serviceKey});
        log.debug(String.format("Executing edge statistics request (%s) to URI: '%s'", path, target.getUri()));
        Entity entity = Entity.entity((Object)new ObjectMapper().writeValueAsString((Object)this.requestOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response response = target.request().headers(this.headers).post(entity);
        return this.parseResponse(response);
    }

    private Map<String, Map<String, Double>> parseResponse(Response response) throws TargomoClientException {
        String responseStr = (String)response.readEntity(String.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                TypeReference<HashMap<String, Map<String, Double>>> typeRef = new TypeReference<HashMap<String, Map<String, Double>>>(){};
                return (Map)new ObjectMapper().readValue(responseStr, (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                throw new TargomoClientRuntimeException("Couldn't parse Edge Statistics response", e);
            }
        }
        throw new TargomoClientException(responseStr, response.getStatus());
    }
}

