/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.geo.Location;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLocationMapDeserializer<K extends Location>
extends JsonDeserializer<Map<String, K>> {
    private static final ObjectMapper mapper = new ObjectMapper();

    public Map<String, K> deserialize(String key, JsonParser jsonParser, Class<K> deserializationClass) throws IOException {
        JsonNode locationArray = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        HashMap<String, Location> locations = new HashMap<String, Location>();
        for (JsonNode coordinateNode : locationArray) {
            locations.put(coordinateNode.get(key).asText(), (Location)mapper.readValue(coordinateNode.toString(), deserializationClass));
        }
        return locations;
    }
}

