/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.pojo;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.MultiGraphAggregationType;
import com.targomo.client.api.pojo.AggregationInputParameters;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregationConfiguration {
    private MultiGraphAggregationType type;
    private Boolean ignoreOutliers;
    private Float outlierPenalty;
    private Double minSourcesRatio;
    private Integer minSourcesCount;
    private Float sourceValuesLowerBound;
    private Float sourceValuesUpperBound;
    private Float sourceValuesModifier;
    private Double minResultValueRatio;
    private Float minResultValue;
    private Double maxResultValueRatio;
    private Float maxResultValue;
    private Float postAggregationFactor;
    private Set<String> filterValuesForSourceOrigins;
    private Double gravitationExponent;
    private Double probabilityDecay;
    private Double logitBetaAttractionStrength;
    private Double logitBetaTravelTime;
    private Boolean useProbabilityBasedWeightedAverage;
    private Map<String, AggregationInputParameters> aggregationInputParameters;
    private String mathExpression;
    private Integer learntMaxEdgeWeight;

    public MultiGraphAggregationType getType() {
        return this.type;
    }

    public Boolean getIgnoreOutliers() {
        return this.ignoreOutliers;
    }

    public Float getOutlierPenalty() {
        return this.outlierPenalty;
    }

    public Double getMinSourcesRatio() {
        return this.minSourcesRatio;
    }

    public Integer getMinSourcesCount() {
        return this.minSourcesCount;
    }

    public Float getSourceValuesLowerBound() {
        return this.sourceValuesLowerBound;
    }

    public Float getSourceValuesUpperBound() {
        return this.sourceValuesUpperBound;
    }

    public Float getSourceValuesModifier() {
        return this.sourceValuesModifier;
    }

    public Double getMinResultValueRatio() {
        return this.minResultValueRatio;
    }

    public Float getMinResultValue() {
        return this.minResultValue;
    }

    public Double getMaxResultValueRatio() {
        return this.maxResultValueRatio;
    }

    public Float getMaxResultValue() {
        return this.maxResultValue;
    }

    public Float getPostAggregationFactor() {
        return this.postAggregationFactor;
    }

    public Set<String> getFilterValuesForSourceOrigins() {
        return this.filterValuesForSourceOrigins;
    }

    public Double getGravitationExponent() {
        return this.gravitationExponent;
    }

    public Double getProbabilityDecay() {
        return this.probabilityDecay;
    }

    public Double getLogitBetaAttractionStrength() {
        return this.logitBetaAttractionStrength;
    }

    public Double getLogitBetaTravelTime() {
        return this.logitBetaTravelTime;
    }

    public Boolean getUseProbabilityBasedWeightedAverage() {
        return this.useProbabilityBasedWeightedAverage;
    }

    public Map<String, AggregationInputParameters> getAggregationInputParameters() {
        return this.aggregationInputParameters;
    }

    public String getMathExpression() {
        return this.mathExpression;
    }

    public Integer getLearntMaxEdgeWeight() {
        return this.learntMaxEdgeWeight;
    }

    public void setType(MultiGraphAggregationType type) {
        this.type = type;
    }

    public void setIgnoreOutliers(Boolean ignoreOutliers) {
        this.ignoreOutliers = ignoreOutliers;
    }

    public void setOutlierPenalty(Float outlierPenalty) {
        this.outlierPenalty = outlierPenalty;
    }

    public void setMinSourcesRatio(Double minSourcesRatio) {
        this.minSourcesRatio = minSourcesRatio;
    }

    public void setMinSourcesCount(Integer minSourcesCount) {
        this.minSourcesCount = minSourcesCount;
    }

    public void setSourceValuesLowerBound(Float sourceValuesLowerBound) {
        this.sourceValuesLowerBound = sourceValuesLowerBound;
    }

    public void setSourceValuesUpperBound(Float sourceValuesUpperBound) {
        this.sourceValuesUpperBound = sourceValuesUpperBound;
    }

    public void setSourceValuesModifier(Float sourceValuesModifier) {
        this.sourceValuesModifier = sourceValuesModifier;
    }

    public void setMinResultValueRatio(Double minResultValueRatio) {
        this.minResultValueRatio = minResultValueRatio;
    }

    public void setMinResultValue(Float minResultValue) {
        this.minResultValue = minResultValue;
    }

    public void setMaxResultValueRatio(Double maxResultValueRatio) {
        this.maxResultValueRatio = maxResultValueRatio;
    }

    public void setMaxResultValue(Float maxResultValue) {
        this.maxResultValue = maxResultValue;
    }

    public void setPostAggregationFactor(Float postAggregationFactor) {
        this.postAggregationFactor = postAggregationFactor;
    }

    public void setFilterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
    }

    public void setGravitationExponent(Double gravitationExponent) {
        this.gravitationExponent = gravitationExponent;
    }

    public void setProbabilityDecay(Double probabilityDecay) {
        this.probabilityDecay = probabilityDecay;
    }

    public void setLogitBetaAttractionStrength(Double logitBetaAttractionStrength) {
        this.logitBetaAttractionStrength = logitBetaAttractionStrength;
    }

    public void setLogitBetaTravelTime(Double logitBetaTravelTime) {
        this.logitBetaTravelTime = logitBetaTravelTime;
    }

    public void setUseProbabilityBasedWeightedAverage(Boolean useProbabilityBasedWeightedAverage) {
        this.useProbabilityBasedWeightedAverage = useProbabilityBasedWeightedAverage;
    }

    public void setAggregationInputParameters(Map<String, AggregationInputParameters> aggregationInputParameters) {
        this.aggregationInputParameters = aggregationInputParameters;
    }

    public void setMathExpression(String mathExpression) {
        this.mathExpression = mathExpression;
    }

    public void setLearntMaxEdgeWeight(Integer learntMaxEdgeWeight) {
        this.learntMaxEdgeWeight = learntMaxEdgeWeight;
    }

    public AggregationConfiguration(MultiGraphAggregationType type, Boolean ignoreOutliers, Float outlierPenalty, Double minSourcesRatio, Integer minSourcesCount, Float sourceValuesLowerBound, Float sourceValuesUpperBound, Float sourceValuesModifier, Double minResultValueRatio, Float minResultValue, Double maxResultValueRatio, Float maxResultValue, Float postAggregationFactor, Set<String> filterValuesForSourceOrigins, Double gravitationExponent, Double probabilityDecay, Double logitBetaAttractionStrength, Double logitBetaTravelTime, Boolean useProbabilityBasedWeightedAverage, Map<String, AggregationInputParameters> aggregationInputParameters, String mathExpression, Integer learntMaxEdgeWeight) {
        this.type = type;
        this.ignoreOutliers = ignoreOutliers;
        this.outlierPenalty = outlierPenalty;
        this.minSourcesRatio = minSourcesRatio;
        this.minSourcesCount = minSourcesCount;
        this.sourceValuesLowerBound = sourceValuesLowerBound;
        this.sourceValuesUpperBound = sourceValuesUpperBound;
        this.sourceValuesModifier = sourceValuesModifier;
        this.minResultValueRatio = minResultValueRatio;
        this.minResultValue = minResultValue;
        this.maxResultValueRatio = maxResultValueRatio;
        this.maxResultValue = maxResultValue;
        this.postAggregationFactor = postAggregationFactor;
        this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
        this.gravitationExponent = gravitationExponent;
        this.probabilityDecay = probabilityDecay;
        this.logitBetaAttractionStrength = logitBetaAttractionStrength;
        this.logitBetaTravelTime = logitBetaTravelTime;
        this.useProbabilityBasedWeightedAverage = useProbabilityBasedWeightedAverage;
        this.aggregationInputParameters = aggregationInputParameters;
        this.mathExpression = mathExpression;
        this.learntMaxEdgeWeight = learntMaxEdgeWeight;
    }

    public AggregationConfiguration() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationConfiguration)) {
            return false;
        }
        AggregationConfiguration other = (AggregationConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ignoreOutliers = this.getIgnoreOutliers();
        Boolean other$ignoreOutliers = other.getIgnoreOutliers();
        if (this$ignoreOutliers == null ? other$ignoreOutliers != null : !((Object)this$ignoreOutliers).equals(other$ignoreOutliers)) {
            return false;
        }
        Float this$outlierPenalty = this.getOutlierPenalty();
        Float other$outlierPenalty = other.getOutlierPenalty();
        if (this$outlierPenalty == null ? other$outlierPenalty != null : !((Object)this$outlierPenalty).equals(other$outlierPenalty)) {
            return false;
        }
        Double this$minSourcesRatio = this.getMinSourcesRatio();
        Double other$minSourcesRatio = other.getMinSourcesRatio();
        if (this$minSourcesRatio == null ? other$minSourcesRatio != null : !((Object)this$minSourcesRatio).equals(other$minSourcesRatio)) {
            return false;
        }
        Integer this$minSourcesCount = this.getMinSourcesCount();
        Integer other$minSourcesCount = other.getMinSourcesCount();
        if (this$minSourcesCount == null ? other$minSourcesCount != null : !((Object)this$minSourcesCount).equals(other$minSourcesCount)) {
            return false;
        }
        Float this$sourceValuesLowerBound = this.getSourceValuesLowerBound();
        Float other$sourceValuesLowerBound = other.getSourceValuesLowerBound();
        if (this$sourceValuesLowerBound == null ? other$sourceValuesLowerBound != null : !((Object)this$sourceValuesLowerBound).equals(other$sourceValuesLowerBound)) {
            return false;
        }
        Float this$sourceValuesUpperBound = this.getSourceValuesUpperBound();
        Float other$sourceValuesUpperBound = other.getSourceValuesUpperBound();
        if (this$sourceValuesUpperBound == null ? other$sourceValuesUpperBound != null : !((Object)this$sourceValuesUpperBound).equals(other$sourceValuesUpperBound)) {
            return false;
        }
        Float this$sourceValuesModifier = this.getSourceValuesModifier();
        Float other$sourceValuesModifier = other.getSourceValuesModifier();
        if (this$sourceValuesModifier == null ? other$sourceValuesModifier != null : !((Object)this$sourceValuesModifier).equals(other$sourceValuesModifier)) {
            return false;
        }
        Double this$minResultValueRatio = this.getMinResultValueRatio();
        Double other$minResultValueRatio = other.getMinResultValueRatio();
        if (this$minResultValueRatio == null ? other$minResultValueRatio != null : !((Object)this$minResultValueRatio).equals(other$minResultValueRatio)) {
            return false;
        }
        Float this$minResultValue = this.getMinResultValue();
        Float other$minResultValue = other.getMinResultValue();
        if (this$minResultValue == null ? other$minResultValue != null : !((Object)this$minResultValue).equals(other$minResultValue)) {
            return false;
        }
        Double this$maxResultValueRatio = this.getMaxResultValueRatio();
        Double other$maxResultValueRatio = other.getMaxResultValueRatio();
        if (this$maxResultValueRatio == null ? other$maxResultValueRatio != null : !((Object)this$maxResultValueRatio).equals(other$maxResultValueRatio)) {
            return false;
        }
        Float this$maxResultValue = this.getMaxResultValue();
        Float other$maxResultValue = other.getMaxResultValue();
        if (this$maxResultValue == null ? other$maxResultValue != null : !((Object)this$maxResultValue).equals(other$maxResultValue)) {
            return false;
        }
        Float this$postAggregationFactor = this.getPostAggregationFactor();
        Float other$postAggregationFactor = other.getPostAggregationFactor();
        if (this$postAggregationFactor == null ? other$postAggregationFactor != null : !((Object)this$postAggregationFactor).equals(other$postAggregationFactor)) {
            return false;
        }
        Double this$gravitationExponent = this.getGravitationExponent();
        Double other$gravitationExponent = other.getGravitationExponent();
        if (this$gravitationExponent == null ? other$gravitationExponent != null : !((Object)this$gravitationExponent).equals(other$gravitationExponent)) {
            return false;
        }
        Double this$probabilityDecay = this.getProbabilityDecay();
        Double other$probabilityDecay = other.getProbabilityDecay();
        if (this$probabilityDecay == null ? other$probabilityDecay != null : !((Object)this$probabilityDecay).equals(other$probabilityDecay)) {
            return false;
        }
        Double this$logitBetaAttractionStrength = this.getLogitBetaAttractionStrength();
        Double other$logitBetaAttractionStrength = other.getLogitBetaAttractionStrength();
        if (this$logitBetaAttractionStrength == null ? other$logitBetaAttractionStrength != null : !((Object)this$logitBetaAttractionStrength).equals(other$logitBetaAttractionStrength)) {
            return false;
        }
        Double this$logitBetaTravelTime = this.getLogitBetaTravelTime();
        Double other$logitBetaTravelTime = other.getLogitBetaTravelTime();
        if (this$logitBetaTravelTime == null ? other$logitBetaTravelTime != null : !((Object)this$logitBetaTravelTime).equals(other$logitBetaTravelTime)) {
            return false;
        }
        Boolean this$useProbabilityBasedWeightedAverage = this.getUseProbabilityBasedWeightedAverage();
        Boolean other$useProbabilityBasedWeightedAverage = other.getUseProbabilityBasedWeightedAverage();
        if (this$useProbabilityBasedWeightedAverage == null ? other$useProbabilityBasedWeightedAverage != null : !((Object)this$useProbabilityBasedWeightedAverage).equals(other$useProbabilityBasedWeightedAverage)) {
            return false;
        }
        Integer this$learntMaxEdgeWeight = this.getLearntMaxEdgeWeight();
        Integer other$learntMaxEdgeWeight = other.getLearntMaxEdgeWeight();
        if (this$learntMaxEdgeWeight == null ? other$learntMaxEdgeWeight != null : !((Object)this$learntMaxEdgeWeight).equals(other$learntMaxEdgeWeight)) {
            return false;
        }
        MultiGraphAggregationType this$type = this.getType();
        MultiGraphAggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Set<String> this$filterValuesForSourceOrigins = this.getFilterValuesForSourceOrigins();
        Set<String> other$filterValuesForSourceOrigins = other.getFilterValuesForSourceOrigins();
        if (this$filterValuesForSourceOrigins == null ? other$filterValuesForSourceOrigins != null : !((Object)this$filterValuesForSourceOrigins).equals(other$filterValuesForSourceOrigins)) {
            return false;
        }
        Map<String, AggregationInputParameters> this$aggregationInputParameters = this.getAggregationInputParameters();
        Map<String, AggregationInputParameters> other$aggregationInputParameters = other.getAggregationInputParameters();
        if (this$aggregationInputParameters == null ? other$aggregationInputParameters != null : !((Object)this$aggregationInputParameters).equals(other$aggregationInputParameters)) {
            return false;
        }
        String this$mathExpression = this.getMathExpression();
        String other$mathExpression = other.getMathExpression();
        return !(this$mathExpression == null ? other$mathExpression != null : !this$mathExpression.equals(other$mathExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregationConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreOutliers = this.getIgnoreOutliers();
        result = result * 59 + ($ignoreOutliers == null ? 43 : ((Object)$ignoreOutliers).hashCode());
        Float $outlierPenalty = this.getOutlierPenalty();
        result = result * 59 + ($outlierPenalty == null ? 43 : ((Object)$outlierPenalty).hashCode());
        Double $minSourcesRatio = this.getMinSourcesRatio();
        result = result * 59 + ($minSourcesRatio == null ? 43 : ((Object)$minSourcesRatio).hashCode());
        Integer $minSourcesCount = this.getMinSourcesCount();
        result = result * 59 + ($minSourcesCount == null ? 43 : ((Object)$minSourcesCount).hashCode());
        Float $sourceValuesLowerBound = this.getSourceValuesLowerBound();
        result = result * 59 + ($sourceValuesLowerBound == null ? 43 : ((Object)$sourceValuesLowerBound).hashCode());
        Float $sourceValuesUpperBound = this.getSourceValuesUpperBound();
        result = result * 59 + ($sourceValuesUpperBound == null ? 43 : ((Object)$sourceValuesUpperBound).hashCode());
        Float $sourceValuesModifier = this.getSourceValuesModifier();
        result = result * 59 + ($sourceValuesModifier == null ? 43 : ((Object)$sourceValuesModifier).hashCode());
        Double $minResultValueRatio = this.getMinResultValueRatio();
        result = result * 59 + ($minResultValueRatio == null ? 43 : ((Object)$minResultValueRatio).hashCode());
        Float $minResultValue = this.getMinResultValue();
        result = result * 59 + ($minResultValue == null ? 43 : ((Object)$minResultValue).hashCode());
        Double $maxResultValueRatio = this.getMaxResultValueRatio();
        result = result * 59 + ($maxResultValueRatio == null ? 43 : ((Object)$maxResultValueRatio).hashCode());
        Float $maxResultValue = this.getMaxResultValue();
        result = result * 59 + ($maxResultValue == null ? 43 : ((Object)$maxResultValue).hashCode());
        Float $postAggregationFactor = this.getPostAggregationFactor();
        result = result * 59 + ($postAggregationFactor == null ? 43 : ((Object)$postAggregationFactor).hashCode());
        Double $gravitationExponent = this.getGravitationExponent();
        result = result * 59 + ($gravitationExponent == null ? 43 : ((Object)$gravitationExponent).hashCode());
        Double $probabilityDecay = this.getProbabilityDecay();
        result = result * 59 + ($probabilityDecay == null ? 43 : ((Object)$probabilityDecay).hashCode());
        Double $logitBetaAttractionStrength = this.getLogitBetaAttractionStrength();
        result = result * 59 + ($logitBetaAttractionStrength == null ? 43 : ((Object)$logitBetaAttractionStrength).hashCode());
        Double $logitBetaTravelTime = this.getLogitBetaTravelTime();
        result = result * 59 + ($logitBetaTravelTime == null ? 43 : ((Object)$logitBetaTravelTime).hashCode());
        Boolean $useProbabilityBasedWeightedAverage = this.getUseProbabilityBasedWeightedAverage();
        result = result * 59 + ($useProbabilityBasedWeightedAverage == null ? 43 : ((Object)$useProbabilityBasedWeightedAverage).hashCode());
        Integer $learntMaxEdgeWeight = this.getLearntMaxEdgeWeight();
        result = result * 59 + ($learntMaxEdgeWeight == null ? 43 : ((Object)$learntMaxEdgeWeight).hashCode());
        MultiGraphAggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Set<String> $filterValuesForSourceOrigins = this.getFilterValuesForSourceOrigins();
        result = result * 59 + ($filterValuesForSourceOrigins == null ? 43 : ((Object)$filterValuesForSourceOrigins).hashCode());
        Map<String, AggregationInputParameters> $aggregationInputParameters = this.getAggregationInputParameters();
        result = result * 59 + ($aggregationInputParameters == null ? 43 : ((Object)$aggregationInputParameters).hashCode());
        String $mathExpression = this.getMathExpression();
        result = result * 59 + ($mathExpression == null ? 43 : $mathExpression.hashCode());
        return result;
    }

    public String toString() {
        return "AggregationConfiguration(type=" + (Object)((Object)this.getType()) + ", ignoreOutliers=" + this.getIgnoreOutliers() + ", outlierPenalty=" + this.getOutlierPenalty() + ", minSourcesRatio=" + this.getMinSourcesRatio() + ", minSourcesCount=" + this.getMinSourcesCount() + ", sourceValuesLowerBound=" + this.getSourceValuesLowerBound() + ", sourceValuesUpperBound=" + this.getSourceValuesUpperBound() + ", sourceValuesModifier=" + this.getSourceValuesModifier() + ", minResultValueRatio=" + this.getMinResultValueRatio() + ", minResultValue=" + this.getMinResultValue() + ", maxResultValueRatio=" + this.getMaxResultValueRatio() + ", maxResultValue=" + this.getMaxResultValue() + ", postAggregationFactor=" + this.getPostAggregationFactor() + ", filterValuesForSourceOrigins=" + this.getFilterValuesForSourceOrigins() + ", gravitationExponent=" + this.getGravitationExponent() + ", probabilityDecay=" + this.getProbabilityDecay() + ", logitBetaAttractionStrength=" + this.getLogitBetaAttractionStrength() + ", logitBetaTravelTime=" + this.getLogitBetaTravelTime() + ", useProbabilityBasedWeightedAverage=" + this.getUseProbabilityBasedWeightedAverage() + ", aggregationInputParameters=" + this.getAggregationInputParameters() + ", mathExpression=" + this.getMathExpression() + ", learntMaxEdgeWeight=" + this.getLearntMaxEdgeWeight() + ")";
    }

    public static class AggregationConfigurationBuilder {
        private MultiGraphAggregationType type;
        private Boolean ignoreOutliers;
        private Float outlierPenalty;
        private Double minSourcesRatio;
        private Integer minSourcesCount;
        private Float sourceValuesLowerBound;
        private Float sourceValuesUpperBound;
        private Float sourceValuesModifier;
        private Double minResultValueRatio;
        private Float minResultValue;
        private Double maxResultValueRatio;
        private Float maxResultValue;
        private Double gravitationExponent;
        private Double probabilityDecay;
        private Double logitBetaAttractionStrength;
        private Double logitBetaTravelTime;
        private Boolean useProbabilityBasedWeightedAverage;
        private Float postAggregationFactor;
        private Set<String> filterValuesForSourceOrigins;
        private Map<String, AggregationInputParameters> aggregationInputParameters;
        private String mathExpression;
        private Integer learntMaxEdgeWeight;

        public AggregationConfigurationBuilder() {
        }

        public AggregationConfigurationBuilder(AggregationConfiguration toCopy) {
            this.type = toCopy.type;
            this.ignoreOutliers = toCopy.ignoreOutliers;
            this.outlierPenalty = toCopy.outlierPenalty;
            this.minSourcesRatio = toCopy.minSourcesRatio;
            this.minSourcesCount = toCopy.minSourcesCount;
            this.sourceValuesLowerBound = toCopy.sourceValuesLowerBound;
            this.sourceValuesUpperBound = toCopy.sourceValuesUpperBound;
            this.sourceValuesModifier = toCopy.sourceValuesModifier;
            this.minResultValueRatio = toCopy.minResultValueRatio;
            this.minResultValue = toCopy.minResultValue;
            this.maxResultValueRatio = toCopy.maxResultValueRatio;
            this.maxResultValue = toCopy.maxResultValue;
            this.filterValuesForSourceOrigins = Optional.ofNullable(toCopy.filterValuesForSourceOrigins).map(HashSet::new).orElse(null);
            this.gravitationExponent = toCopy.gravitationExponent;
            this.probabilityDecay = toCopy.probabilityDecay;
            this.logitBetaAttractionStrength = toCopy.logitBetaAttractionStrength;
            this.logitBetaTravelTime = toCopy.logitBetaTravelTime;
            this.useProbabilityBasedWeightedAverage = toCopy.useProbabilityBasedWeightedAverage;
            this.postAggregationFactor = toCopy.postAggregationFactor;
            this.aggregationInputParameters = Optional.ofNullable(toCopy.aggregationInputParameters).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AggregationInputParameters(((AggregationInputParameters)entry.getValue()).getInputFactor(), ((AggregationInputParameters)entry.getValue()).getGravitationPositiveInfluence(), ((AggregationInputParameters)entry.getValue()).getGravitationAttractionStrength(), ((AggregationInputParameters)entry.getValue()).getGravitationCompetingPositiveInfluence())))).orElse(null);
            this.mathExpression = toCopy.mathExpression;
            this.learntMaxEdgeWeight = toCopy.learntMaxEdgeWeight;
        }

        public AggregationConfigurationBuilder(TravelOptions travelOptions, boolean deepCopy) {
            this.type = travelOptions.getMultiGraphAggregationType();
            this.ignoreOutliers = travelOptions.getMultiGraphAggregationIgnoreOutliers();
            this.outlierPenalty = travelOptions.getMultiGraphAggregationOutlierPenalty();
            this.minSourcesRatio = travelOptions.getMultiGraphAggregationMinSourcesRatio();
            this.minSourcesCount = travelOptions.getMultiGraphAggregationMinSourcesCount();
            this.sourceValuesLowerBound = travelOptions.getMultiGraphAggregationSourceValuesLowerBound();
            this.sourceValuesUpperBound = travelOptions.getMultiGraphAggregationSourceValuesUpperBound();
            this.sourceValuesModifier = travelOptions.getMultiGraphAggregationSourceValuesModifier();
            this.minResultValueRatio = travelOptions.getMultiGraphAggregationMinResultValueRatio();
            this.minResultValue = travelOptions.getMultiGraphAggregationMinResultValue();
            this.maxResultValueRatio = travelOptions.getMultiGraphAggregationMaxResultValueRatio();
            this.maxResultValue = travelOptions.getMultiGraphAggregationMaxResultValue();
            this.postAggregationFactor = travelOptions.getMultiGraphAggregationPostAggregationFactor();
            this.filterValuesForSourceOrigins = !deepCopy ? travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins() : (Set)Optional.ofNullable(travelOptions.getMultiGraphAggregationFilterValuesForSourceOrigins()).map(HashSet::new).orElse(null);
            this.gravitationExponent = travelOptions.getMultiGraphAggregationGravitationExponent();
            this.probabilityDecay = travelOptions.getMultiGraphAggregationProbabilityDecay();
            this.logitBetaAttractionStrength = travelOptions.getMultiGraphAggregationLogitBetaAttractionStrength();
            this.logitBetaTravelTime = travelOptions.getMultiGraphAggregationLogitBetaTravelTime();
            this.useProbabilityBasedWeightedAverage = travelOptions.getMultiGraphAggregationUseProbabilityBasedWeightedAverage();
            this.aggregationInputParameters = !deepCopy ? travelOptions.getMultiGraphAggregationInputParameters() : (Map)Optional.ofNullable(travelOptions.getMultiGraphAggregationInputParameters()).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AggregationInputParameters(((AggregationInputParameters)entry.getValue()).getInputFactor(), ((AggregationInputParameters)entry.getValue()).getGravitationPositiveInfluence(), ((AggregationInputParameters)entry.getValue()).getGravitationAttractionStrength(), ((AggregationInputParameters)entry.getValue()).getGravitationCompetingPositiveInfluence())))).orElse(null);
            this.mathExpression = travelOptions.getMultiGraphAggregationMathExpression();
            this.learntMaxEdgeWeight = travelOptions.getMultiGraphAggregationLearntMaxEdgeWeight();
        }

        public AggregationConfigurationBuilder type(MultiGraphAggregationType type) {
            this.type = type;
            return this;
        }

        public AggregationConfigurationBuilder ignoreOutliers(Boolean ignoreOutliers) {
            this.ignoreOutliers = ignoreOutliers;
            return this;
        }

        public AggregationConfigurationBuilder outlierPenalty(Float outlierPenalty) {
            this.outlierPenalty = outlierPenalty;
            return this;
        }

        public AggregationConfigurationBuilder minSourcesRatio(Double minSourcesRatio) {
            this.minSourcesRatio = minSourcesRatio;
            return this;
        }

        public AggregationConfigurationBuilder minSourcesCount(Integer minSourcesCount) {
            this.minSourcesCount = minSourcesCount;
            return this;
        }

        public AggregationConfigurationBuilder sourceValuesLowerBound(Float sourceValuesLowerBound) {
            this.sourceValuesLowerBound = sourceValuesLowerBound;
            return this;
        }

        public AggregationConfigurationBuilder sourceValuesUpperBound(Float sourceValuesUpperBound) {
            this.sourceValuesUpperBound = sourceValuesUpperBound;
            return this;
        }

        public AggregationConfigurationBuilder sourceValuesModifier(Float sourceValuesModifier) {
            this.sourceValuesModifier = sourceValuesModifier;
            return this;
        }

        public AggregationConfigurationBuilder minResultValueRatio(Double minResultValueRatio) {
            this.minResultValueRatio = minResultValueRatio;
            return this;
        }

        public AggregationConfigurationBuilder minResultValue(Float minResultValue) {
            this.minResultValue = minResultValue;
            return this;
        }

        public AggregationConfigurationBuilder maxResultValueRatio(Double maxResultValueRatio) {
            this.maxResultValueRatio = maxResultValueRatio;
            return this;
        }

        public AggregationConfigurationBuilder maxResultValue(Float maxResultValue) {
            this.maxResultValue = maxResultValue;
            return this;
        }

        public AggregationConfigurationBuilder filterValuesForSourceOrigins(Set<String> filterValuesForSourceOrigins) {
            this.filterValuesForSourceOrigins = filterValuesForSourceOrigins;
            return this;
        }

        public AggregationConfigurationBuilder gravitationExponent(Double gravitationTravelTimeExponent) {
            this.gravitationExponent = gravitationTravelTimeExponent;
            return this;
        }

        public AggregationConfigurationBuilder probabilityDecay(Double probabilityDecay) {
            this.probabilityDecay = probabilityDecay;
            return this;
        }

        public AggregationConfigurationBuilder logitBetaAttractionStrength(Double logitBetaAttractionStrength) {
            this.logitBetaAttractionStrength = logitBetaAttractionStrength;
            return this;
        }

        public AggregationConfigurationBuilder logitBetaTravelTime(Double logitBetaTravelTime) {
            this.logitBetaTravelTime = logitBetaTravelTime;
            return this;
        }

        public AggregationConfigurationBuilder useProbabilityBasedWeightedAverage(Boolean useProbabilityBasedWeightedAverage) {
            this.useProbabilityBasedWeightedAverage = useProbabilityBasedWeightedAverage;
            return this;
        }

        public AggregationConfigurationBuilder aggregationInputParameters(Map<String, AggregationInputParameters> aggregationInputParameters) {
            this.aggregationInputParameters = aggregationInputParameters;
            return this;
        }

        public AggregationConfigurationBuilder postAggregationFactor(Float postAggregationFactor) {
            this.postAggregationFactor = postAggregationFactor;
            return this;
        }

        public AggregationConfigurationBuilder mathExpression(String mathExpression) {
            this.mathExpression = mathExpression;
            return this;
        }

        public AggregationConfigurationBuilder learntMaxEdgeWeight(Integer learntMaxEdgeWeight) {
            this.learntMaxEdgeWeight = learntMaxEdgeWeight;
            return this;
        }

        public AggregationConfiguration build() {
            return new AggregationConfiguration(this.type, this.ignoreOutliers, this.outlierPenalty, this.minSourcesRatio, this.minSourcesCount, this.sourceValuesLowerBound, this.sourceValuesUpperBound, this.sourceValuesModifier, this.minResultValueRatio, this.minResultValue, this.maxResultValueRatio, this.maxResultValue, this.postAggregationFactor, this.filterValuesForSourceOrigins, this.gravitationExponent, this.probabilityDecay, this.logitBetaAttractionStrength, this.logitBetaTravelTime, this.useProbabilityBasedWeightedAverage, this.aggregationInputParameters, this.mathExpression, this.learntMaxEdgeWeight);
        }
    }
}

