/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.response.OverpassResponse;
import com.targomo.client.api.statistic.PoiType;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverpassRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverpassRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private PoiType poiType;

    public OverpassRequest(TravelOptions travelOptions, Client client, PoiType poiType) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.poiType = poiType;
    }

    public OverpassRequest(TravelOptions travelOptions, PoiType poiTye) {
        this(travelOptions, ClientBuilder.newClient(), poiTye);
    }

    public OverpassRequest(Client client, TravelOptions travelOptions) {
        this(travelOptions, client, travelOptions.getOsmTypes().iterator().next());
    }

    public OverpassRequest(TravelOptions travelOptions) {
        this(travelOptions, ClientBuilder.newClient(), travelOptions.getOsmTypes().iterator().next());
    }

    public OverpassResponse get() throws TargomoClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getOverpassServiceUrl()).path("/api/interpreter");
        LOGGER.info("{}", (Object)target.getUri());
        if (this.travelOptions.getOverpassQuery() == null || this.travelOptions.getOverpassQuery().isEmpty()) {
            throw new TargomoClientException("Empty query");
        }
        Entity entity = Entity.entity((Object)this.travelOptions.getOverpassQuery(), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug("Executing overpass query to URI: '{}'", (Object)target.getUri());
        Response response = target.request().post(entity);
        return this.validateResponse(response, requestStart);
    }

    private OverpassResponse validateResponse(Response response, long requestStart) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            OverpassResponse overpassResponse = new OverpassResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart, this.poiType);
            LOGGER.info("Request complete in {}ms", (Object)overpassResponse.getRequestEnd());
            return overpassResponse;
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

