/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.geo.DefaultTargetCoordinate;
import com.targomo.client.api.response.esri.Candidate;
import com.targomo.client.api.response.esri.ErrorDescription;
import com.targomo.client.api.util.POJOUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GeocodingResponse
implements Iterable<Candidate> {
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();
    private final List<Candidate> candidates;
    private final ErrorDescription error;
    private final String completeJsonResponse;

    public GeocodingResponse(@JsonProperty(value="candidates") List<Candidate> candidates, @JsonProperty(value="error") ErrorDescription error, @JsonProperty(value="jsonString") String jsonString) {
        this.completeJsonResponse = jsonString;
        this.error = error;
        this.candidates = candidates;
    }

    public static GeocodingResponse createFromJson(String jsonString) {
        GeocodingResponse ret = null;
        try {
            ret = (GeocodingResponse)JSON_PARSER.readValue(jsonString, GeocodingResponse.class);
        }
        catch (IOException e) {
            throw new TargomoClientRuntimeException(e.getMessage(), e);
        }
        return new GeocodingResponse(ret.candidates, ret.error, jsonString);
    }

    public ErrorDescription getError() {
        return this.error;
    }

    public boolean wasErrorResponse() {
        return this.error != null;
    }

    public String getCompleteJsonResponseAsString() {
        return this.completeJsonResponse;
    }

    public DefaultTargetCoordinate getRepresentativeGeocodeOfRequest() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a coordination candidate.");
        }
        Candidate mostLikelyCandidate = this.candidates.get(0);
        return mostLikelyCandidate.getLocation();
    }

    public Candidate getRepresentativeCandidate() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a candidate.");
        }
        return this.candidates.get(0);
    }

    public String toString() {
        return POJOUtil.prettyPrintPOJO(this);
    }

    @Override
    public Iterator<Candidate> iterator() {
        return this.candidates.iterator();
    }

    public boolean isEmpty() {
        return this.candidates == null || this.candidates.isEmpty();
    }
}

