/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.targomo.client.api.enums.MultiGraphDomainType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public enum MultiGraphLayerType {
    IDENTITY("identity", false, MultiGraphDomainType.values()),
    TILE("tile", true, MultiGraphDomainType.EDGE, MultiGraphDomainType.NODE),
    HEXAGON("hexagon", true, MultiGraphDomainType.EDGE, MultiGraphDomainType.NODE),
    H3HEXAGON("h3hexagon", true, MultiGraphDomainType.values()),
    CUSTOM_GEOMETRIES("custom_geometries", false, MultiGraphDomainType.values());

    private final String key;
    private final boolean requiresFixedPrecisionOrTile;
    private final List<MultiGraphDomainType> supportedDomainTypes;

    private MultiGraphLayerType(String key, boolean requiresFixedPrecisionOrTile, MultiGraphDomainType ... supportedDomainTypes) {
        this.key = key;
        this.requiresFixedPrecisionOrTile = requiresFixedPrecisionOrTile;
        this.supportedDomainTypes = Arrays.asList(supportedDomainTypes);
    }

    @JsonCreator
    public static MultiGraphLayerType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphLayerType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphLayerType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public boolean isRequiresFixedPrecisionOrTile() {
        return this.requiresFixedPrecisionOrTile;
    }

    @JsonIgnore
    public List<MultiGraphDomainType> getSupportedDomainTypes() {
        return this.supportedDomainTypes;
    }
}

