/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;

public enum PathSerializerType {
    TRAVEL_TIME_PATH_SERIALIZER,
    COMPACT_PATH_SERIALIZER,
    GEO_JSON_PATH_SERIALIZER;


    public static PathSerializerType getPathSerializer(String key) throws TargomoClientException {
        switch (key) {
            case "travelTime": {
                return TRAVEL_TIME_PATH_SERIALIZER;
            }
            case "compact": {
                return COMPACT_PATH_SERIALIZER;
            }
            case "geojson": {
                return GEO_JSON_PATH_SERIALIZER;
            }
        }
        throw new TargomoClientException(String.format("No path serializer available for key '%s'.", key));
    }

    public String getPathSerializerName() throws TargomoClientRuntimeException {
        switch (this) {
            case COMPACT_PATH_SERIALIZER: {
                return "compact";
            }
            case GEO_JSON_PATH_SERIALIZER: {
                return "geojson";
            }
        }
        throw new TargomoClientRuntimeException(String.format("No polygon serializer name available for key '%s'.", new Object[]{this}));
    }
}

