/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;

public enum PolygonSerializerType {
    JSON_POLYGON_SERIALIZER,
    GEO_JSON_POLYGON_SERIALIZER;


    public static PolygonSerializerType getPolygonSerializer(String key) throws TargomoClientException {
        switch (key) {
            case "json": {
                return JSON_POLYGON_SERIALIZER;
            }
            case "geojson": {
                return GEO_JSON_POLYGON_SERIALIZER;
            }
        }
        throw new TargomoClientException(String.format("No polygon serializer available for key '%s'.", key));
    }

    public String getPolygonSerializerName() throws TargomoClientRuntimeException {
        switch (this) {
            case JSON_POLYGON_SERIALIZER: {
                return "json";
            }
            case GEO_JSON_POLYGON_SERIALIZER: {
                return "geojson";
            }
        }
        throw new TargomoClientRuntimeException(String.format("No polygon serializer name available for key '%s'.", new Object[]{this}));
    }
}

