/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum TravelType {
    UNSPECIFIED("unspecified"),
    WALK("walk"),
    BIKE("bike"),
    TRANSIT("transit"),
    WALKTRANSIT("walktransit"),
    BIKETRANSIT("biketransit"),
    FLY("fly"),
    CAR("car");

    private String key;

    private TravelType(String key) {
        this.key = key;
    }

    @JsonCreator
    public static TravelType fromString(String key) {
        return key == null ? null : Stream.of(TravelType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + TravelType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static TravelType parse(String travelType) {
        switch (travelType.toLowerCase()) {
            case "walk": {
                return WALK;
            }
            case "bike": {
                return BIKE;
            }
            case "car": {
                return CAR;
            }
            case "transit": {
                return TRANSIT;
            }
            case "walktransit": {
                return WALKTRANSIT;
            }
            case "biketransit": {
                return BIKETRANSIT;
            }
            case "fly": {
                return FLY;
            }
        }
        return UNSPECIFIED;
    }

    public boolean isTransit() {
        return this.toString().toLowerCase().contains("transit");
    }
}

