/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.response.statistics.StatisticGeometryValuesResult;
import com.targomo.client.api.util.JsonUtil;
import org.json.JSONObject;

public class StatisticsGeometryValuesResponse {
    private final long requestTimeMillis;
    private final long totalTimeMillis;
    private final TravelOptions travelOptions;
    private final StatisticGeometryValuesResult statisticGeometryValuesResult;

    public StatisticsGeometryValuesResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestTimeMillis = result.has("requestTime") ? JsonUtil.getLong(result, "requestTime") : -1L;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.statisticGeometryValuesResult = new StatisticGeometryValuesResult(travelOptions, result);
    }

    public StatisticsGeometryValuesResponse(TravelOptions travelOptions, String string, long roundTripTime, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestTimeMillis = roundTripTime;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.statisticGeometryValuesResult = null;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public StatisticGeometryValuesResult getStatisticGeometryValuesResult() {
        return this.statisticGeometryValuesResult;
    }
}

