/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response.statistics;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.util.JsonUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class StatisticGeometryValuesResult {
    private final Map<String, StatisticsGeometryValue> results;
    private final TravelOptions options;

    public StatisticGeometryValuesResult(TravelOptions options, JSONObject jsonResult) {
        this.options = options;
        this.results = this.parseStatisticsGeometryValues(jsonResult);
    }

    private Map<String, StatisticsGeometryValue> parseStatisticsGeometryValues(JSONObject jsonResult) {
        HashMap<String, StatisticsGeometryValue> values = new HashMap<String, StatisticsGeometryValue>();
        Iterator keysIterator = jsonResult.keys();
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            JSONObject obj = JsonUtil.getJSONObject(jsonResult, key);
            values.put(key, new StatisticsGeometryValue(JsonUtil.getString(obj, "aggregation"), JsonUtil.getInt(obj, "statisticId").shortValue(), JsonUtil.getDouble(obj, "value")));
        }
        return values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("\n  results: \n");
        builder.append("    ---------------\n");
        for (Map.Entry<String, StatisticsGeometryValue> result : this.results.entrySet()) {
            builder.append("    " + result.getKey() + ":" + String.format(" { aggregation: %s, statisticsID: %o, value: %f }", result.getValue().getAggregation(), result.getValue().getStatisticsID(), result.getValue().getValue()) + "\n");
            builder.append("    ---------------\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    public Map<String, StatisticsGeometryValue> getResults() {
        return this.results;
    }

    public TravelOptions getOptions() {
        return this.options;
    }

    public static class StatisticsGeometryValue {
        private final String aggregation;
        private final short statisticsID;
        private final double value;

        public StatisticsGeometryValue(String aggregation, short statisticsID, double value) {
            this.aggregation = aggregation;
            this.statisticsID = statisticsID;
            this.value = value;
        }

        public String getAggregation() {
            return this.aggregation;
        }

        public short getStatisticsID() {
            return this.statisticsID;
        }

        public double getValue() {
            return this.value;
        }
    }
}

