/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.util;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CurlUtil {
    public static String buildCurlRequest(String url, List<String> headers, String body) {
        String method = body == null || body.isEmpty() ? "GET" : "POST";
        return CurlUtil.buildCurlRequest(method, url, null, headers, body);
    }

    public static String buildCurlRequest(String method, String url, String queryString, List<String> headers, String body) {
        StringBuilder sb = new StringBuilder().append("curl --location -X ").append(method).append(" '").append(url);
        if (!StringUtils.isEmpty((CharSequence)queryString)) {
            sb.append("?").append(queryString);
        }
        sb.append("' \\\n");
        if (!CollectionUtils.isEmpty(headers)) {
            for (String header : headers) {
                sb.append("-H '").append(header).append("' \\\n");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)body)) {
            sb.append("--data-raw '").append(body).append("' \\\n");
        }
        return sb.append("--insecure --compressed").toString();
    }
}

