package com.targomo.client.api.quality.criterion;

import com.fasterxml.jackson.annotation.JsonValue;
import com.targomo.client.Constants;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum CriterionType {
    POI_COVERAGE_COUNT(Constants.CRITERION_TYPE_POI_COVERAGE_COUNT),
    POI_COVERAGE_DISTANCE(Constants.CRITERION_TYPE_POI_COVERAGE_DISTANCE),
    CLOSEST_POI_DISTANCE(Constants.CRITERION_TYPE_CLOSEST_POI_DISTANCE),
    CLOSEST_POI_ABSOLUTE_DISTANCE(Constants.CRITERION_TYPE_CLOSEST_POI_ABSOLUTE_DISTANCE),
    POI_COUNT_IN_ZONE(Constants.CRITERION_TYPE_POI_COUNT_IN_ZONE),
    STATISTICS_SUM(Constants.CRITERION_TYPE_STATISTICS_SUM),
    STATISTICS_MAX(Constants.CRITERION_TYPE_STATISTICS_MAX),
    STATISTICS_DISTANCE_AVERAGE(Constants.CRITERION_TYPE_STATISTICS_DISTANCE_AVERAGE),
    STATISTICS_DISTANCE(Constants.CRITERION_TYPE_STATISTICS_DISTANCE),
    STATISTICS_GRAVITATION_SUM(Constants.CRITERION_TYPE_GRAVITATION_SUM),
    STATISTICS_GRAVITATION_DISTANCE_AVERAGE(Constants.CRITERION_TYPE_GRAVITATION_DISTANCE_AVERAGE),
    STATISTICS_SUM_IN_ZONE(Constants.CRITERION_TYPE_STATISTICS_SUM_IN_ZONE),
    STATISTICS_ON_ENCLOSING_CELL(Constants.CRITERION_TYPE_STATISTICS_ON_ENCLOSING_CELL),
    POI_GRAVITATION_SUM(Constants.CRITERION_TYPE_POI_GRAVITATION_SUM),
    EDGE_STATISTICS(Constants.CRITERION_TYPE_EDGE_STATISTICS),
    EDGE_STATISTICS_REACHABILITY(Constants.CRITERION_TYPE_EDGE_STATISTICS_REACHABILITY),
    MATH_AGGREGATION(Constants.CRITERION_TYPE_MATH_AGGREGATION),
    STAYPOINT_COUNT(Constants.CRITERION_TYPE_STAYPOINT_COUNT),
    TRANSIT_STOPS_SUM(Constants.CRITERION_TYPE_TRANSIT_STOPS_SUM),
    TRANSIT_STOPS_DISTANCE(Constants.CRITERION_TYPE_TRANSIT_STOPS_DISTANCE),
    POLYGON_AREA(Constants.CRITERION_TYPE_POLYGON_AREA),
    CRITERION_REFERENCE(Constants.CRITERION_TYPE_REFERENCE);

    private final String name;

    @JsonValue
    public String getName() {
        return this.name;
    }
}
