/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.stream.Stream;

public enum Weekday {
    SUNDAY(0, 6),
    MONDAY(1, 0),
    TUESDAY(2, 1),
    WEDNESDAY(3, 2),
    THURSDAY(4, 3),
    FRIDAY(5, 4),
    SATURDAY(6, 5);

    public final int weekdaySunMon;
    public final int weekdayMonSun;

    private Weekday(int weekdaySunMon, int weekdayMonSun) {
        this.weekdaySunMon = weekdaySunMon;
        this.weekdayMonSun = weekdayMonSun;
    }

    @JsonCreator
    public static Weekday fromString(String key) {
        if (key == null) {
            return null;
        }
        return Stream.of(Weekday.values()).filter(enu -> enu.name().equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Weekday '%s' is not a valid day. Must be one of '%s'.", key, Arrays.asList(Weekday.values()))));
    }

    public static Weekday fromIntMonSun(int day) {
        return Stream.of(Weekday.values()).filter(enu -> enu.weekdayMonSun == day).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Weekday '%s' is not a valid day. Must be in range 0-6.", day)));
    }

    public static Weekday fromIntSunMon(int day) {
        return Stream.of(Weekday.values()).filter(enu -> enu.weekdaySunMon == day).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Weekday '%s' is not a valid day. Must be in range 0-6.", day)));
    }
}

