/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.TransitStation;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitStopsRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransitStopsRequest.class);
    private final Client client;
    private final TravelOptions travelOptions;
    private static final String CALLBACK = "callback";
    private final MultivaluedMap<String, Object> headers;

    public TransitStopsRequest(TravelOptions travelOptions) {
        this.headers = new MultivaluedHashMap();
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public TransitStopsRequest(Client client, TravelOptions travelOptions) {
        this.headers = new MultivaluedHashMap();
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public TransitStopsRequest(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = headers;
    }

    public Map<String, List<TransitStation>> get() throws TargomoClientException, JsonProcessingException {
        return this.get(null);
    }

    public Map<String, List<TransitStation>> get(Boolean filterEmptyNextStops) throws TargomoClientException, JsonProcessingException {
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/transit/stops").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()}).queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        if (filterEmptyNextStops != null) {
            target = target.queryParam("filterEmptyNextStops", new Object[]{filterEmptyNextStops});
        }
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug("Executing transit stops request to URI: '{}}'", (Object)target.getUri());
        Response response = target.request().headers(this.headers).post(entity);
        return this.validateResponse(response);
    }

    private Map<String, List<TransitStation>> validateResponse(Response response) throws TargomoClientException, JsonProcessingException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            TypeReference<Map<String, List<TransitStation>>> typeRef = new TypeReference<Map<String, List<TransitStation>>>(){};
            return (Map)new ObjectMapper().readValue((String)response.readEntity(String.class), (TypeReference)typeRef);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

