/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.quality.Location;
import com.targomo.client.api.quality.criterion.CriterionDefinition;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.ScoreResponse;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScoreRequest {
    private final Client client;
    private final Map<String, CriterionDefinition> criteria;
    private final List<Location> locations;
    private final List<Location> competitors;
    private final String serviceUrl;
    private final String apiKey;
    private final Boolean showDetails;
    private final Boolean forceRecalculate;
    private final Boolean cacheResult;
    private final MultivaluedMap<String, Object> headers;

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, MultivaluedMap<String, Object> headers) {
        this(ClientBuilder.newClient(), criteria, locations, Collections.emptyList(), serviceUrl, key, null, null, null, headers);
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations) {
        this(ClientBuilder.newClient(), criteria, locations, Collections.emptyList(), serviceUrl, key, null, null, null, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors) {
        this(ClientBuilder.newClient(), criteria, locations, competitors, serviceUrl, key, null, null, null, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors, boolean showDetails, boolean forceRecalculate, boolean cacheResult) {
        this(ClientBuilder.newClient(), criteria, locations, competitors, serviceUrl, key, showDetails, forceRecalculate, cacheResult, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, boolean showDetails, boolean forceRecalculate, boolean cacheResult) {
        this(ClientBuilder.newClient(), criteria, locations, Collections.emptyList(), serviceUrl, key, showDetails, forceRecalculate, cacheResult, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public ScoreRequest(String serviceUrl, String key, Map<String, CriterionDefinition> criteria, List<Location> locations, boolean showDetails, boolean forceRecalculate, boolean cacheResult, MultivaluedMap<String, Object> headers) {
        this(ClientBuilder.newClient(), criteria, locations, Collections.emptyList(), serviceUrl, key, showDetails, forceRecalculate, cacheResult, headers);
    }

    public ScoreRequest(Client client, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors, String serviceUrl, String key, boolean showDetails, boolean forceRecalculate, boolean cacheResult) {
        this(client, criteria, locations, competitors, serviceUrl, key, showDetails, forceRecalculate, cacheResult, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public ScoreResponse get() throws TargomoClientException {
        WebTarget request = this.client.target(this.serviceUrl).path("v1/scores").queryParam("apiKey", new Object[]{this.apiKey});
        if (this.showDetails != null) {
            request = request.queryParam("showDetails", new Object[]{this.showDetails});
        }
        if (this.forceRecalculate != null) {
            request = request.queryParam("forceRecalculate", new Object[]{this.forceRecalculate});
        }
        if (this.cacheResult != null) {
            request = request.queryParam("cacheResult", new Object[]{this.cacheResult});
        }
        String config = RequestConfigurator.getConfig(this.criteria, this.locations, this.competitors);
        Response response = request.request().headers(this.headers).post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return ScoreRequest.validateResponse(response);
    }

    public static ScoreResponse validateResponse(Response response) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String message;
            JSONObject data;
            JSONObject result = JsonUtil.parseString(IOUtil.getResultString(response));
            JSONArray errors = new JSONArray();
            try {
                data = result.getJSONObject("data");
                message = result.getString("message");
                if (result.has("errors")) {
                    errors = result.getJSONArray("errors");
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            DateTime timestamp = DateTime.now();
            return new ScoreResponse(data, message, errors, timestamp);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }

    public ScoreRequest(Client client, Map<String, CriterionDefinition> criteria, List<Location> locations, List<Location> competitors, String serviceUrl, String apiKey, Boolean showDetails, Boolean forceRecalculate, Boolean cacheResult, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.criteria = criteria;
        this.locations = locations;
        this.competitors = competitors;
        this.serviceUrl = serviceUrl;
        this.apiKey = apiKey;
        this.showDetails = showDetails;
        this.forceRecalculate = forceRecalculate;
        this.cacheResult = cacheResult;
        this.headers = headers;
    }
}

