/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.geo;

import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.geo.AbstractGeometry;
import com.targomo.client.api.pojo.LocationProperties;
import com.targomo.client.api.util.SerializationUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="source_geometry")
public class DefaultSourceGeometry
extends AbstractGeometry {
    @Id
    @Column(name="identifier")
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long identifier;
    @Column(name="travel_types")
    private List<TravelType> travelTypes;

    private DefaultSourceGeometry() {
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, List<TravelType> travelTypes, boolean routeFromCentroid, LocationProperties locationProperties) {
        super(id, crs, geojson, routeFromCentroid, locationProperties);
        this.travelTypes = travelTypes;
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType, boolean routeFromCentroid, LocationProperties locationProperties) {
        this(id, geojson, crs, travelType == null ? Collections.emptyList() : Collections.singletonList(travelType), routeFromCentroid, locationProperties);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType, LocationProperties locationProperties) {
        this(id, geojson, crs, travelType, true, locationProperties);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType) {
        this(id, geojson, crs, travelType, null);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, TravelType travelType, boolean routeFromCentroid) {
        this(id, geojson, crs, travelType, routeFromCentroid, null);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs) {
        this(id, geojson, crs, null, null);
    }

    public DefaultSourceGeometry(String id, String geojson, int crs, boolean routeFromCentroid) {
        this(id, geojson, crs, Collections.emptyList(), routeFromCentroid, null);
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long id) {
        this.identifier = id;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" { id: ");
        builder.append(this.getId());
        builder.append(", data: ");
        builder.append(this.getData());
        builder.append(", crs: ");
        builder.append(this.getCrs());
        builder.append(", routeFromCentroid: ");
        builder.append(this.isRouteFromCentroid());
        builder.append(", travelType: ");
        builder.append(SerializationUtil.travelTypeListToString(this.travelTypes));
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultSourceGeometry that = (DefaultSourceGeometry)o;
        return Objects.equals(this.travelTypes, that.travelTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.travelTypes != null ? this.travelTypes.hashCode() : 0);
        return result;
    }

    @Override
    public void setTravelTypes(List<TravelType> travelTypes) {
        this.travelTypes = travelTypes;
    }

    @Override
    public List<TravelType> getTravelTypes() {
        return this.travelTypes;
    }
}

