/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.response.BoundingBoxResponse;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundingBoxRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundingBoxRequest.class);
    private final Client client;
    private final MultivaluedMap<String, Object> headers;
    TravelOptions travelOptions;

    public BoundingBoxRequest(Client client, TravelOptions travelOptions, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.headers = headers;
        this.travelOptions = travelOptions;
    }

    public BoundingBoxRequest(TravelOptions travelOptions) {
        this(ClientBuilder.newClient(), travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public BoundingBoxRequest(Client client, TravelOptions travelOptions) {
        this(client, travelOptions, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    public BoundingBoxResponse get() throws TargomoClientException {
        long startTimeMillis = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/boundingbox").queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()}).queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug("Executing reachability request to URI: '{}}'", (Object)target.getUri());
        Response response = target.request().headers(this.headers).post(entity);
        long roundTripTimeMillis = System.currentTimeMillis() - startTimeMillis;
        return this.parseResponse(response, roundTripTimeMillis);
    }

    private BoundingBoxResponse parseResponse(Response response, long roundTripTimeMillis) throws TargomoClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String message;
            String responseStr = (String)response.readEntity(String.class);
            JSONObject json = JsonUtil.parseString(responseStr);
            String code = json.has("code") ? JsonUtil.getString(json, "code") : null;
            String string = message = json.has("message") ? JsonUtil.getString(json, "message") : null;
            if (code != null && !StringUtils.equals((CharSequence)code, (CharSequence)"ok")) {
                String msg = "Boundingbox request returned an error";
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    msg = msg + ": " + message;
                }
                throw new TargomoClientException(String.format("Status: %s: %s", code, msg), response.getStatus());
            }
            Double minX = json.has("minX") ? JsonUtil.getDouble(json, "minX") : null;
            Double maxX = json.has("maxX") ? JsonUtil.getDouble(json, "maxX") : null;
            Double minY = json.has("minY") ? JsonUtil.getDouble(json, "minY") : null;
            Double maxY = json.has("maxY") ? JsonUtil.getDouble(json, "maxY") : null;
            return new BoundingBoxResponse(minX, maxX, minY, maxY, roundTripTimeMillis);
        }
        throw new TargomoClientException((String)response.readEntity(String.class), response.getStatus());
    }
}

