/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.enums.Format;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.util.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PointOfInterestResponse {
    private final TravelOptions travelOptions;
    private final JSONObject result;
    private final long requestEnd;
    private final Map<String, Integer> edgeWeights;

    public PointOfInterestResponse(TravelOptions travelOptions, JSONObject result, boolean resultContainsEdgeWeights, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestEnd = System.currentTimeMillis() - requestStart;
        this.result = result;
        this.edgeWeights = new HashMap<String, Integer>();
        if (resultContainsEdgeWeights) {
            this.mapResults();
        }
    }

    public void mapResults() {
        if (Format.GEOJSON.equals((Object)this.travelOptions.getFormat())) {
            JSONArray jsonArray = JsonUtil.getJsonArray(this.result, "features");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject target = JsonUtil.getJSONObject(jsonArray, i);
                JSONObject properties = JsonUtil.getJSONObject(target, "properties");
                String trgId = JsonUtil.getString(properties, "id");
                this.addEdgeWeight(trgId, JsonUtil.getInt(properties, "edgeWeight"));
            }
        } else if (Format.JSON.equals((Object)this.travelOptions.getFormat())) {
            Iterator keysIterator = this.result.keys();
            while (keysIterator.hasNext()) {
                JSONObject obj = JsonUtil.getJSONObject(this.result, (String)keysIterator.next());
                this.addEdgeWeight(JsonUtil.getString(obj, "id"), JsonUtil.getInt(obj, "edgeWeight"));
            }
        } else {
            throw new TargomoClientRuntimeException("Unknown format given: " + (Object)((Object)this.travelOptions.getFormat()));
        }
    }

    public void addEdgeWeight(String targetId, Integer travelTime) {
        this.edgeWeights.put(targetId, travelTime);
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public Map<String, Integer> getEdgeWeights() {
        return this.edgeWeights;
    }

    public JSONObject getResult() {
        return this.result;
    }

    public HashMap<String, POI> getResultAsMap() throws IOException {
        return (HashMap)new ObjectMapper().readValue(this.result.toString(), POIResponse.class);
    }

    static class POIResponse
    extends HashMap<String, POI> {
        POIResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class POI {
        String type;
        String id;
        double lat;
        double lng;
        Map<String, String> tags;
        String osmType;
        int edgeWeight;
        List<String> groupIds;
        List<String> clusterIds;
        String closestSource;
        boolean bounded;

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public void setLng(double lng) {
            this.lng = lng;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public void setOsmType(String osmType) {
            this.osmType = osmType;
        }

        public void setEdgeWeight(int edgeWeight) {
            this.edgeWeight = edgeWeight;
        }

        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        public void setClusterIds(List<String> clusterIds) {
            this.clusterIds = clusterIds;
        }

        public void setClosestSource(String closestSource) {
            this.closestSource = closestSource;
        }

        public void setBounded(boolean bounded) {
            this.bounded = bounded;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public double getLat() {
            return this.lat;
        }

        public double getLng() {
            return this.lng;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public String getOsmType() {
            return this.osmType;
        }

        public int getEdgeWeight() {
            return this.edgeWeight;
        }

        public List<String> getGroupIds() {
            return this.groupIds;
        }

        public List<String> getClusterIds() {
            return this.clusterIds;
        }

        public String getClosestSource() {
            return this.closestSource;
        }

        public boolean isBounded() {
            return this.bounded;
        }

        public String toString() {
            return "PointOfInterestResponse.POI(type=" + this.getType() + ", id=" + this.getId() + ", lat=" + this.getLat() + ", lng=" + this.getLng() + ", tags=" + this.getTags() + ", osmType=" + this.getOsmType() + ", edgeWeight=" + this.getEdgeWeight() + ", groupIds=" + this.getGroupIds() + ", clusterIds=" + this.getClusterIds() + ", closestSource=" + this.getClosestSource() + ", bounded=" + this.isBounded() + ")";
        }
    }
}

