/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import com.targomo.client.api.geo.Coordinate;
import com.targomo.client.api.pojo.TravelWeight;
import com.targomo.client.api.response.ResponseCode;
import com.targomo.client.api.util.JsonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class TimeResponse {
    private static final TravelWeight EMPTY_TRAVELWEIGHT = new TravelWeight(-1, -1);
    private final ResponseCode code;
    private final long requestTimeMillis;
    private final long totalTimeMillis;
    private final TravelOptions travelOptions;
    private final String message;
    private final Map<Coordinate, Map<Coordinate, TravelWeight>> travelWeights = new HashMap<Coordinate, Map<Coordinate, TravelWeight>>();
    private Map<Coordinate, Map<Coordinate, Integer>> travelTimes = null;
    private Map<Coordinate, Map<Coordinate, Integer>> travelDistances = null;

    public TimeResponse(TravelOptions travelOptions, JSONObject result, long requestStart) throws ResponseErrorException {
        this.travelOptions = travelOptions;
        this.code = ResponseCode.fromString(JsonUtil.getString(result, "code"));
        this.requestTimeMillis = result.has("requestTime") ? JsonUtil.getLong(result, "requestTime") : -1L;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        String string = this.message = result.has("message") ? JsonUtil.getString(result, "message") : "";
        if (this.code != ResponseCode.OK) {
            String msg = "Time request returned an error";
            if (!StringUtils.isEmpty((CharSequence)this.message)) {
                msg = msg + ": " + this.message;
            }
            throw new ResponseErrorException(this.code, msg);
        }
        this.mapResults(result);
    }

    public TimeResponse(TravelOptions travelOptions, ResponseCode code, long requestTime, long requestStart) {
        this.travelOptions = travelOptions;
        this.code = code;
        this.requestTimeMillis = requestTime;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.message = "";
    }

    public void mapResults(JSONObject result) {
        if (this.travelOptions == null) {
            throw new TargomoClientRuntimeException("Unsupported call");
        }
        this.mapResults(this.travelOptions, result);
    }

    public void mapResults(TravelOptions travelOptions, JSONObject result) {
        JSONArray jsonArray = JsonUtil.getJsonArray(result, "data");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject source = JsonUtil.getJSONObject(jsonArray, i);
            String srcId = JsonUtil.getString(source, "id");
            JSONArray targets = JsonUtil.getJsonArray(source, "targets");
            this.travelWeights.putIfAbsent(travelOptions.getSource(srcId), new HashMap());
            for (int j = 0; j < targets.length(); ++j) {
                JSONObject target = JsonUtil.getJSONObject(targets, j);
                String trgId = JsonUtil.getString(target, "id");
                this.addTravelWeight(travelOptions.getSource(srcId), travelOptions.getTarget(trgId), JsonUtil.getInt(target, "travelTime"), JsonUtil.getInt(target, "length"));
            }
        }
    }

    public void addTravelWeight(Coordinate source, Coordinate target, Integer travelTime, Integer length) {
        this.travelWeights.putIfAbsent(source, new HashMap());
        this.travelWeights.get(source).put(target, new TravelWeight(length, travelTime));
    }

    public Integer getTravelTime(Coordinate source, Coordinate target) {
        return this.getTravelWeight(source, target).getTravelTime();
    }

    public Integer getLength(Coordinate source, Coordinate target) {
        return this.getTravelWeight(source, target).getTravelDistance();
    }

    public TravelWeight getTravelWeight(Coordinate source, Coordinate target) {
        return this.travelWeights.getOrDefault(source, Collections.emptyMap()).getOrDefault(target, EMPTY_TRAVELWEIGHT);
    }

    public ResponseCode getCode() {
        return this.code;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public Map<Coordinate, Map<Coordinate, TravelWeight>> getTravelWeights() {
        return this.travelWeights;
    }

    public Map<Coordinate, Map<Coordinate, Integer>> getTravelTimes() {
        if (this.travelTimes == null) {
            this.travelTimes = new HashMap<Coordinate, Map<Coordinate, Integer>>();
            this.travelWeights.entrySet().forEach(entry -> this.travelTimes.put((Coordinate)entry.getKey(), ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TravelWeight)e.getValue()).getTravelTime()))));
        }
        return this.travelTimes;
    }

    public Map<Coordinate, Map<Coordinate, Integer>> getLengths() {
        if (this.travelDistances == null) {
            this.travelDistances = new HashMap<Coordinate, Map<Coordinate, Integer>>();
            this.travelWeights.entrySet().forEach(entry -> this.travelDistances.put((Coordinate)entry.getKey(), ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TravelWeight)e.getValue()).getTravelDistance()))));
        }
        return this.travelDistances;
    }

    public long getTotalTime() {
        return this.totalTimeMillis;
    }
}

