/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.targomo.client.api.enums.TravelType;
import com.targomo.client.api.enums.Weekday;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RoutingOptions {
    private Integer maxEdgeWeight;
    private TravelType travelType;
    private Map<String, Double> travelTimeFactors;
    private Boolean reverse;
    private Boolean rushHour;
    private Integer time;
    private Integer date;
    private Weekday weekday;
    private Integer frame;
    private Integer arrivalOrDepartureDuration;
    private Boolean elevationEnabled;
    private Double bikeSpeed;
    private Double bikeDownhill;
    private Double bikeUphill;
    private Double walkSpeed;
    private Double walkDownhill;
    private Double walkUphill;
    private Boolean allowPrivateAndServiceRoads;
    private Integer trafficJunctionPenalty;
    private Integer trafficSignalPenalty;
    private Integer trafficLeftTurnPenalty;
    private Integer trafficRightTurnPenalty;
    private Integer maxTransfers;
    private Integer maxWalkingTimeFromSource;
    private Integer maxWalkingTimeToTarget;
    private List<Integer> avoidTransitRouteTypes;
    private Integer maxSnapDistance;
    private List<Integer> excludeEdgeClassesFromSnapping;
    private Boolean useAreaSnapping;
    private Integer snapRadius;
    private Boolean includeSnapDistance;
    private Boolean includeSnapDistanceForTargets;

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxEdgeWeight, this.travelType.ordinal(), this.travelTimeFactors, this.reverse, this.rushHour, this.time, this.date, this.weekday, this.frame, this.arrivalOrDepartureDuration, this.elevationEnabled, this.bikeSpeed, this.bikeDownhill, this.bikeUphill, this.walkSpeed, this.walkDownhill, this.walkUphill, this.allowPrivateAndServiceRoads, this.trafficJunctionPenalty, this.trafficSignalPenalty, this.trafficLeftTurnPenalty, this.trafficRightTurnPenalty, this.maxTransfers, this.maxWalkingTimeFromSource, this.maxWalkingTimeToTarget, this.avoidTransitRouteTypes, this.maxSnapDistance, this.excludeEdgeClassesFromSnapping, this.useAreaSnapping, this.snapRadius, this.includeSnapDistance, this.includeSnapDistanceForTargets});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingOptions that = (RoutingOptions)o;
        return Objects.equals(this.maxEdgeWeight, that.maxEdgeWeight) && this.travelType == that.travelType && Objects.equals(this.travelTimeFactors, that.travelTimeFactors) && Objects.equals(this.reverse, that.reverse) && Objects.equals(this.rushHour, that.rushHour) && Objects.equals(this.time, that.time) && Objects.equals(this.date, that.date) && Objects.equals((Object)this.weekday, (Object)that.weekday) && Objects.equals(this.frame, that.frame) && Objects.equals(this.arrivalOrDepartureDuration, that.arrivalOrDepartureDuration) && Objects.equals(this.elevationEnabled, that.elevationEnabled) && Objects.equals(this.bikeSpeed, that.bikeSpeed) && Objects.equals(this.bikeDownhill, that.bikeDownhill) && Objects.equals(this.bikeUphill, that.bikeUphill) && Objects.equals(this.walkSpeed, that.walkSpeed) && Objects.equals(this.walkDownhill, that.walkDownhill) && Objects.equals(this.walkUphill, that.walkUphill) && Objects.equals(this.allowPrivateAndServiceRoads, that.allowPrivateAndServiceRoads) && Objects.equals(this.trafficJunctionPenalty, that.trafficJunctionPenalty) && Objects.equals(this.trafficSignalPenalty, that.trafficSignalPenalty) && Objects.equals(this.trafficLeftTurnPenalty, that.trafficLeftTurnPenalty) && Objects.equals(this.trafficRightTurnPenalty, that.trafficRightTurnPenalty) && Objects.equals(this.maxTransfers, that.maxTransfers) && Objects.equals(this.maxWalkingTimeFromSource, that.maxWalkingTimeFromSource) && Objects.equals(this.maxWalkingTimeToTarget, that.maxWalkingTimeToTarget) && Objects.equals(this.avoidTransitRouteTypes, that.avoidTransitRouteTypes) && Objects.equals(this.maxSnapDistance, that.maxSnapDistance) && Objects.equals(this.excludeEdgeClassesFromSnapping, that.excludeEdgeClassesFromSnapping) && Objects.equals(this.useAreaSnapping, that.useAreaSnapping) && Objects.equals(this.snapRadius, that.snapRadius) && Objects.equals(this.includeSnapDistance, that.includeSnapDistance) && Objects.equals(this.includeSnapDistanceForTargets, that.includeSnapDistanceForTargets);
    }

    public static RoutingOptionsBuilder builder() {
        return new RoutingOptionsBuilder();
    }

    public Integer getMaxEdgeWeight() {
        return this.maxEdgeWeight;
    }

    public TravelType getTravelType() {
        return this.travelType;
    }

    public Map<String, Double> getTravelTimeFactors() {
        return this.travelTimeFactors;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public Boolean getRushHour() {
        return this.rushHour;
    }

    public Integer getTime() {
        return this.time;
    }

    public Integer getDate() {
        return this.date;
    }

    public Weekday getWeekday() {
        return this.weekday;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public Integer getArrivalOrDepartureDuration() {
        return this.arrivalOrDepartureDuration;
    }

    public Boolean getElevationEnabled() {
        return this.elevationEnabled;
    }

    public Double getBikeSpeed() {
        return this.bikeSpeed;
    }

    public Double getBikeDownhill() {
        return this.bikeDownhill;
    }

    public Double getBikeUphill() {
        return this.bikeUphill;
    }

    public Double getWalkSpeed() {
        return this.walkSpeed;
    }

    public Double getWalkDownhill() {
        return this.walkDownhill;
    }

    public Double getWalkUphill() {
        return this.walkUphill;
    }

    public Boolean getAllowPrivateAndServiceRoads() {
        return this.allowPrivateAndServiceRoads;
    }

    public Integer getTrafficJunctionPenalty() {
        return this.trafficJunctionPenalty;
    }

    public Integer getTrafficSignalPenalty() {
        return this.trafficSignalPenalty;
    }

    public Integer getTrafficLeftTurnPenalty() {
        return this.trafficLeftTurnPenalty;
    }

    public Integer getTrafficRightTurnPenalty() {
        return this.trafficRightTurnPenalty;
    }

    public Integer getMaxTransfers() {
        return this.maxTransfers;
    }

    public Integer getMaxWalkingTimeFromSource() {
        return this.maxWalkingTimeFromSource;
    }

    public Integer getMaxWalkingTimeToTarget() {
        return this.maxWalkingTimeToTarget;
    }

    public List<Integer> getAvoidTransitRouteTypes() {
        return this.avoidTransitRouteTypes;
    }

    public Integer getMaxSnapDistance() {
        return this.maxSnapDistance;
    }

    public List<Integer> getExcludeEdgeClassesFromSnapping() {
        return this.excludeEdgeClassesFromSnapping;
    }

    public Boolean getUseAreaSnapping() {
        return this.useAreaSnapping;
    }

    public Integer getSnapRadius() {
        return this.snapRadius;
    }

    public Boolean getIncludeSnapDistance() {
        return this.includeSnapDistance;
    }

    public Boolean getIncludeSnapDistanceForTargets() {
        return this.includeSnapDistanceForTargets;
    }

    public void setMaxEdgeWeight(Integer maxEdgeWeight) {
        this.maxEdgeWeight = maxEdgeWeight;
    }

    public void setTravelType(TravelType travelType) {
        this.travelType = travelType;
    }

    public void setTravelTimeFactors(Map<String, Double> travelTimeFactors) {
        this.travelTimeFactors = travelTimeFactors;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public void setRushHour(Boolean rushHour) {
        this.rushHour = rushHour;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public void setDate(Integer date) {
        this.date = date;
    }

    public void setWeekday(Weekday weekday) {
        this.weekday = weekday;
    }

    public void setFrame(Integer frame) {
        this.frame = frame;
    }

    public void setArrivalOrDepartureDuration(Integer arrivalOrDepartureDuration) {
        this.arrivalOrDepartureDuration = arrivalOrDepartureDuration;
    }

    public void setElevationEnabled(Boolean elevationEnabled) {
        this.elevationEnabled = elevationEnabled;
    }

    public void setBikeSpeed(Double bikeSpeed) {
        this.bikeSpeed = bikeSpeed;
    }

    public void setBikeDownhill(Double bikeDownhill) {
        this.bikeDownhill = bikeDownhill;
    }

    public void setBikeUphill(Double bikeUphill) {
        this.bikeUphill = bikeUphill;
    }

    public void setWalkSpeed(Double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public void setWalkDownhill(Double walkDownhill) {
        this.walkDownhill = walkDownhill;
    }

    public void setWalkUphill(Double walkUphill) {
        this.walkUphill = walkUphill;
    }

    public void setAllowPrivateAndServiceRoads(Boolean allowPrivateAndServiceRoads) {
        this.allowPrivateAndServiceRoads = allowPrivateAndServiceRoads;
    }

    public void setTrafficJunctionPenalty(Integer trafficJunctionPenalty) {
        this.trafficJunctionPenalty = trafficJunctionPenalty;
    }

    public void setTrafficSignalPenalty(Integer trafficSignalPenalty) {
        this.trafficSignalPenalty = trafficSignalPenalty;
    }

    public void setTrafficLeftTurnPenalty(Integer trafficLeftTurnPenalty) {
        this.trafficLeftTurnPenalty = trafficLeftTurnPenalty;
    }

    public void setTrafficRightTurnPenalty(Integer trafficRightTurnPenalty) {
        this.trafficRightTurnPenalty = trafficRightTurnPenalty;
    }

    public void setMaxTransfers(Integer maxTransfers) {
        this.maxTransfers = maxTransfers;
    }

    public void setMaxWalkingTimeFromSource(Integer maxWalkingTimeFromSource) {
        this.maxWalkingTimeFromSource = maxWalkingTimeFromSource;
    }

    public void setMaxWalkingTimeToTarget(Integer maxWalkingTimeToTarget) {
        this.maxWalkingTimeToTarget = maxWalkingTimeToTarget;
    }

    public void setAvoidTransitRouteTypes(List<Integer> avoidTransitRouteTypes) {
        this.avoidTransitRouteTypes = avoidTransitRouteTypes;
    }

    public void setMaxSnapDistance(Integer maxSnapDistance) {
        this.maxSnapDistance = maxSnapDistance;
    }

    public void setExcludeEdgeClassesFromSnapping(List<Integer> excludeEdgeClassesFromSnapping) {
        this.excludeEdgeClassesFromSnapping = excludeEdgeClassesFromSnapping;
    }

    public void setUseAreaSnapping(Boolean useAreaSnapping) {
        this.useAreaSnapping = useAreaSnapping;
    }

    public void setSnapRadius(Integer snapRadius) {
        this.snapRadius = snapRadius;
    }

    public void setIncludeSnapDistance(Boolean includeSnapDistance) {
        this.includeSnapDistance = includeSnapDistance;
    }

    public void setIncludeSnapDistanceForTargets(Boolean includeSnapDistanceForTargets) {
        this.includeSnapDistanceForTargets = includeSnapDistanceForTargets;
    }

    public String toString() {
        return "RoutingOptions(maxEdgeWeight=" + this.getMaxEdgeWeight() + ", travelType=" + (Object)((Object)this.getTravelType()) + ", travelTimeFactors=" + this.getTravelTimeFactors() + ", reverse=" + this.getReverse() + ", rushHour=" + this.getRushHour() + ", time=" + this.getTime() + ", date=" + this.getDate() + ", weekday=" + (Object)((Object)this.getWeekday()) + ", frame=" + this.getFrame() + ", arrivalOrDepartureDuration=" + this.getArrivalOrDepartureDuration() + ", elevationEnabled=" + this.getElevationEnabled() + ", bikeSpeed=" + this.getBikeSpeed() + ", bikeDownhill=" + this.getBikeDownhill() + ", bikeUphill=" + this.getBikeUphill() + ", walkSpeed=" + this.getWalkSpeed() + ", walkDownhill=" + this.getWalkDownhill() + ", walkUphill=" + this.getWalkUphill() + ", allowPrivateAndServiceRoads=" + this.getAllowPrivateAndServiceRoads() + ", trafficJunctionPenalty=" + this.getTrafficJunctionPenalty() + ", trafficSignalPenalty=" + this.getTrafficSignalPenalty() + ", trafficLeftTurnPenalty=" + this.getTrafficLeftTurnPenalty() + ", trafficRightTurnPenalty=" + this.getTrafficRightTurnPenalty() + ", maxTransfers=" + this.getMaxTransfers() + ", maxWalkingTimeFromSource=" + this.getMaxWalkingTimeFromSource() + ", maxWalkingTimeToTarget=" + this.getMaxWalkingTimeToTarget() + ", avoidTransitRouteTypes=" + this.getAvoidTransitRouteTypes() + ", maxSnapDistance=" + this.getMaxSnapDistance() + ", excludeEdgeClassesFromSnapping=" + this.getExcludeEdgeClassesFromSnapping() + ", useAreaSnapping=" + this.getUseAreaSnapping() + ", snapRadius=" + this.getSnapRadius() + ", includeSnapDistance=" + this.getIncludeSnapDistance() + ", includeSnapDistanceForTargets=" + this.getIncludeSnapDistanceForTargets() + ")";
    }

    public RoutingOptions() {
    }

    public RoutingOptions(Integer maxEdgeWeight, TravelType travelType, Map<String, Double> travelTimeFactors, Boolean reverse, Boolean rushHour, Integer time, Integer date, Weekday weekday, Integer frame, Integer arrivalOrDepartureDuration, Boolean elevationEnabled, Double bikeSpeed, Double bikeDownhill, Double bikeUphill, Double walkSpeed, Double walkDownhill, Double walkUphill, Boolean allowPrivateAndServiceRoads, Integer trafficJunctionPenalty, Integer trafficSignalPenalty, Integer trafficLeftTurnPenalty, Integer trafficRightTurnPenalty, Integer maxTransfers, Integer maxWalkingTimeFromSource, Integer maxWalkingTimeToTarget, List<Integer> avoidTransitRouteTypes, Integer maxSnapDistance, List<Integer> excludeEdgeClassesFromSnapping, Boolean useAreaSnapping, Integer snapRadius, Boolean includeSnapDistance, Boolean includeSnapDistanceForTargets) {
        this.maxEdgeWeight = maxEdgeWeight;
        this.travelType = travelType;
        this.travelTimeFactors = travelTimeFactors;
        this.reverse = reverse;
        this.rushHour = rushHour;
        this.time = time;
        this.date = date;
        this.weekday = weekday;
        this.frame = frame;
        this.arrivalOrDepartureDuration = arrivalOrDepartureDuration;
        this.elevationEnabled = elevationEnabled;
        this.bikeSpeed = bikeSpeed;
        this.bikeDownhill = bikeDownhill;
        this.bikeUphill = bikeUphill;
        this.walkSpeed = walkSpeed;
        this.walkDownhill = walkDownhill;
        this.walkUphill = walkUphill;
        this.allowPrivateAndServiceRoads = allowPrivateAndServiceRoads;
        this.trafficJunctionPenalty = trafficJunctionPenalty;
        this.trafficSignalPenalty = trafficSignalPenalty;
        this.trafficLeftTurnPenalty = trafficLeftTurnPenalty;
        this.trafficRightTurnPenalty = trafficRightTurnPenalty;
        this.maxTransfers = maxTransfers;
        this.maxWalkingTimeFromSource = maxWalkingTimeFromSource;
        this.maxWalkingTimeToTarget = maxWalkingTimeToTarget;
        this.avoidTransitRouteTypes = avoidTransitRouteTypes;
        this.maxSnapDistance = maxSnapDistance;
        this.excludeEdgeClassesFromSnapping = excludeEdgeClassesFromSnapping;
        this.useAreaSnapping = useAreaSnapping;
        this.snapRadius = snapRadius;
        this.includeSnapDistance = includeSnapDistance;
        this.includeSnapDistanceForTargets = includeSnapDistanceForTargets;
    }

    public static class RoutingOptionsBuilder {
        private Integer maxEdgeWeight;
        private TravelType travelType;
        private Map<String, Double> travelTimeFactors;
        private Boolean reverse;
        private Boolean rushHour;
        private Integer time;
        private Integer date;
        private Weekday weekday;
        private Integer frame;
        private Integer arrivalOrDepartureDuration;
        private Boolean elevationEnabled;
        private Double bikeSpeed;
        private Double bikeDownhill;
        private Double bikeUphill;
        private Double walkSpeed;
        private Double walkDownhill;
        private Double walkUphill;
        private Boolean allowPrivateAndServiceRoads;
        private Integer trafficJunctionPenalty;
        private Integer trafficSignalPenalty;
        private Integer trafficLeftTurnPenalty;
        private Integer trafficRightTurnPenalty;
        private Integer maxTransfers;
        private Integer maxWalkingTimeFromSource;
        private Integer maxWalkingTimeToTarget;
        private List<Integer> avoidTransitRouteTypes;
        private Integer maxSnapDistance;
        private List<Integer> excludeEdgeClassesFromSnapping;
        private Boolean useAreaSnapping;
        private Integer snapRadius;
        private Boolean includeSnapDistance;
        private Boolean includeSnapDistanceForTargets;

        RoutingOptionsBuilder() {
        }

        public RoutingOptionsBuilder maxEdgeWeight(Integer maxEdgeWeight) {
            this.maxEdgeWeight = maxEdgeWeight;
            return this;
        }

        public RoutingOptionsBuilder travelType(TravelType travelType) {
            this.travelType = travelType;
            return this;
        }

        public RoutingOptionsBuilder travelTimeFactors(Map<String, Double> travelTimeFactors) {
            this.travelTimeFactors = travelTimeFactors;
            return this;
        }

        public RoutingOptionsBuilder reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public RoutingOptionsBuilder rushHour(Boolean rushHour) {
            this.rushHour = rushHour;
            return this;
        }

        public RoutingOptionsBuilder time(Integer time) {
            this.time = time;
            return this;
        }

        public RoutingOptionsBuilder date(Integer date) {
            this.date = date;
            return this;
        }

        public RoutingOptionsBuilder weekday(Weekday weekday) {
            this.weekday = weekday;
            return this;
        }

        public RoutingOptionsBuilder frame(Integer frame) {
            this.frame = frame;
            return this;
        }

        public RoutingOptionsBuilder arrivalOrDepartureDuration(Integer arrivalOrDepartureDuration) {
            this.arrivalOrDepartureDuration = arrivalOrDepartureDuration;
            return this;
        }

        public RoutingOptionsBuilder elevationEnabled(Boolean elevationEnabled) {
            this.elevationEnabled = elevationEnabled;
            return this;
        }

        public RoutingOptionsBuilder bikeSpeed(Double bikeSpeed) {
            this.bikeSpeed = bikeSpeed;
            return this;
        }

        public RoutingOptionsBuilder bikeDownhill(Double bikeDownhill) {
            this.bikeDownhill = bikeDownhill;
            return this;
        }

        public RoutingOptionsBuilder bikeUphill(Double bikeUphill) {
            this.bikeUphill = bikeUphill;
            return this;
        }

        public RoutingOptionsBuilder walkSpeed(Double walkSpeed) {
            this.walkSpeed = walkSpeed;
            return this;
        }

        public RoutingOptionsBuilder walkDownhill(Double walkDownhill) {
            this.walkDownhill = walkDownhill;
            return this;
        }

        public RoutingOptionsBuilder walkUphill(Double walkUphill) {
            this.walkUphill = walkUphill;
            return this;
        }

        public RoutingOptionsBuilder allowPrivateAndServiceRoads(Boolean allowPrivateAndServiceRoads) {
            this.allowPrivateAndServiceRoads = allowPrivateAndServiceRoads;
            return this;
        }

        public RoutingOptionsBuilder trafficJunctionPenalty(Integer trafficJunctionPenalty) {
            this.trafficJunctionPenalty = trafficJunctionPenalty;
            return this;
        }

        public RoutingOptionsBuilder trafficSignalPenalty(Integer trafficSignalPenalty) {
            this.trafficSignalPenalty = trafficSignalPenalty;
            return this;
        }

        public RoutingOptionsBuilder trafficLeftTurnPenalty(Integer trafficLeftTurnPenalty) {
            this.trafficLeftTurnPenalty = trafficLeftTurnPenalty;
            return this;
        }

        public RoutingOptionsBuilder trafficRightTurnPenalty(Integer trafficRightTurnPenalty) {
            this.trafficRightTurnPenalty = trafficRightTurnPenalty;
            return this;
        }

        public RoutingOptionsBuilder maxTransfers(Integer maxTransfers) {
            this.maxTransfers = maxTransfers;
            return this;
        }

        public RoutingOptionsBuilder maxWalkingTimeFromSource(Integer maxWalkingTimeFromSource) {
            this.maxWalkingTimeFromSource = maxWalkingTimeFromSource;
            return this;
        }

        public RoutingOptionsBuilder maxWalkingTimeToTarget(Integer maxWalkingTimeToTarget) {
            this.maxWalkingTimeToTarget = maxWalkingTimeToTarget;
            return this;
        }

        public RoutingOptionsBuilder avoidTransitRouteTypes(List<Integer> avoidTransitRouteTypes) {
            this.avoidTransitRouteTypes = avoidTransitRouteTypes;
            return this;
        }

        public RoutingOptionsBuilder maxSnapDistance(Integer maxSnapDistance) {
            this.maxSnapDistance = maxSnapDistance;
            return this;
        }

        public RoutingOptionsBuilder excludeEdgeClassesFromSnapping(List<Integer> excludeEdgeClassesFromSnapping) {
            this.excludeEdgeClassesFromSnapping = excludeEdgeClassesFromSnapping;
            return this;
        }

        public RoutingOptionsBuilder useAreaSnapping(Boolean useAreaSnapping) {
            this.useAreaSnapping = useAreaSnapping;
            return this;
        }

        public RoutingOptionsBuilder snapRadius(Integer snapRadius) {
            this.snapRadius = snapRadius;
            return this;
        }

        public RoutingOptionsBuilder includeSnapDistance(Boolean includeSnapDistance) {
            this.includeSnapDistance = includeSnapDistance;
            return this;
        }

        public RoutingOptionsBuilder includeSnapDistanceForTargets(Boolean includeSnapDistanceForTargets) {
            this.includeSnapDistanceForTargets = includeSnapDistanceForTargets;
            return this;
        }

        public RoutingOptions build() {
            return new RoutingOptions(this.maxEdgeWeight, this.travelType, this.travelTimeFactors, this.reverse, this.rushHour, this.time, this.date, this.weekday, this.frame, this.arrivalOrDepartureDuration, this.elevationEnabled, this.bikeSpeed, this.bikeDownhill, this.bikeUphill, this.walkSpeed, this.walkDownhill, this.walkUphill, this.allowPrivateAndServiceRoads, this.trafficJunctionPenalty, this.trafficSignalPenalty, this.trafficLeftTurnPenalty, this.trafficRightTurnPenalty, this.maxTransfers, this.maxWalkingTimeFromSource, this.maxWalkingTimeToTarget, this.avoidTransitRouteTypes, this.maxSnapDistance, this.excludeEdgeClassesFromSnapping, this.useAreaSnapping, this.snapRadius, this.includeSnapDistance, this.includeSnapDistanceForTargets);
        }

        public String toString() {
            return "RoutingOptions.RoutingOptionsBuilder(maxEdgeWeight=" + this.maxEdgeWeight + ", travelType=" + (Object)((Object)this.travelType) + ", travelTimeFactors=" + this.travelTimeFactors + ", reverse=" + this.reverse + ", rushHour=" + this.rushHour + ", time=" + this.time + ", date=" + this.date + ", weekday=" + (Object)((Object)this.weekday) + ", frame=" + this.frame + ", arrivalOrDepartureDuration=" + this.arrivalOrDepartureDuration + ", elevationEnabled=" + this.elevationEnabled + ", bikeSpeed=" + this.bikeSpeed + ", bikeDownhill=" + this.bikeDownhill + ", bikeUphill=" + this.bikeUphill + ", walkSpeed=" + this.walkSpeed + ", walkDownhill=" + this.walkDownhill + ", walkUphill=" + this.walkUphill + ", allowPrivateAndServiceRoads=" + this.allowPrivateAndServiceRoads + ", trafficJunctionPenalty=" + this.trafficJunctionPenalty + ", trafficSignalPenalty=" + this.trafficSignalPenalty + ", trafficLeftTurnPenalty=" + this.trafficLeftTurnPenalty + ", trafficRightTurnPenalty=" + this.trafficRightTurnPenalty + ", maxTransfers=" + this.maxTransfers + ", maxWalkingTimeFromSource=" + this.maxWalkingTimeFromSource + ", maxWalkingTimeToTarget=" + this.maxWalkingTimeToTarget + ", avoidTransitRouteTypes=" + this.avoidTransitRouteTypes + ", maxSnapDistance=" + this.maxSnapDistance + ", excludeEdgeClassesFromSnapping=" + this.excludeEdgeClassesFromSnapping + ", useAreaSnapping=" + this.useAreaSnapping + ", snapRadius=" + this.snapRadius + ", includeSnapDistance=" + this.includeSnapDistance + ", includeSnapDistanceForTargets=" + this.includeSnapDistanceForTargets + ")";
        }
    }
}

