/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.exception.TargomoClientException;
import com.targomo.client.api.request.config.RequestConfigurator;
import com.targomo.client.api.request.ssl.SslClientGenerator;
import com.targomo.client.api.response.PolygonResponse;
import com.targomo.client.api.response.ResponseCode;
import com.targomo.client.api.util.IOUtil;
import com.targomo.client.api.util.JsonUtil;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class PolygonRequest {
    private Client client;
    private TravelOptions travelOptions;
    private String method;
    private MultivaluedMap<String, Object> headers;

    public PolygonRequest(Client client) {
        this.client = client;
        this.headers = new MultivaluedHashMap();
    }

    public PolygonRequest() {
        this(SslClientGenerator.initClient());
    }

    public PolygonRequest(TravelOptions travelOptions) {
        this();
        this.travelOptions = travelOptions;
    }

    public PolygonRequest(TravelOptions travelOptions, String method) {
        this();
        this.travelOptions = travelOptions;
        this.method = method;
    }

    public PolygonRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.headers = new MultivaluedHashMap();
    }

    public PolygonRequest(Client client, TravelOptions travelOptions, String method) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.method = method;
        this.headers = new MultivaluedHashMap();
    }

    public PolygonRequest(Client client, TravelOptions travelOptions, String method, MultivaluedMap<String, Object> headers) {
        this.client = client;
        this.travelOptions = travelOptions;
        this.method = method;
        this.headers = headers;
    }

    public void setTravelOptions(TravelOptions options) {
        this.travelOptions = options;
    }

    public PolygonResponse get() throws TargomoClientException, ResponseErrorException {
        Response response;
        long startTimeMillis = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path("v1/polygon").queryParam("cb", new Object[]{"callback"}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("interServiceKey", new Object[]{this.travelOptions.getInterServiceKey()}).queryParam("interServiceRequest", new Object[]{this.travelOptions.getInterServiceRequestType()});
        String config = RequestConfigurator.getConfig(this.travelOptions);
        if ("GET".equals(this.method)) {
            request = request.queryParam("cfg", new Object[]{IOUtil.encode(config)});
            response = request.request().headers(this.headers).get();
        } else if ("POST".equals(this.method)) {
            response = request.request().headers(this.headers).post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        } else {
            throw new TargomoClientException("HTTP Method not supported: " + this.method);
        }
        long roundTripTimeMillis = System.currentTimeMillis() - startTimeMillis;
        return this.validateResponse(response, roundTripTimeMillis);
    }

    private PolygonResponse validateResponse(Response response, long roundTripTimeMillis) throws TargomoClientException, ResponseErrorException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String message;
            String resultString = IOUtil.getResultString(response);
            long startParsing = System.currentTimeMillis();
            JSONObject result = JsonUtil.parseString(resultString);
            long parseTime = System.currentTimeMillis() - startParsing;
            ResponseCode responseCode = ResponseCode.fromString(JsonUtil.getString(result, "code"));
            String string = message = result.has("message") ? JsonUtil.getString(result, "message") : "";
            if (responseCode != ResponseCode.OK) {
                String msg = "Polygon request returned an error";
                if (!StringUtils.isEmpty((CharSequence)message)) {
                    msg = msg + ": " + message;
                }
                throw new TargomoClientException(String.format("Status: %s: %s (%s)", new Object[]{response.getStatus(), msg, responseCode}), response.getStatus());
            }
            return new PolygonResponse(this.travelOptions, result, responseCode, JsonUtil.getLong(result, "requestTime"), roundTripTimeMillis, parseTime);
        }
        throw new TargomoClientException(String.format("Status: %s: %s", response.getStatus(), response.readEntity(String.class)), response.getStatus());
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

