/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.request.config.builder;

import java.util.List;
import java.util.stream.Collectors;

public final class JSONBuilder {
    private JSONBuilder() {
    }

    public static StringBuilder beginJson(StringBuilder builder) {
        return builder.append("{");
    }

    public static StringBuilder appendString(StringBuilder builder, String key, Object value) {
        return builder.append("\"").append(key).append("\":\"").append(value).append("\",");
    }

    public static StringBuilder append(StringBuilder builder, String key, Object value) {
        return builder.append("\"").append(key).append("\":").append(value).append(",");
    }

    public static <T> StringBuilder appendStringList(StringBuilder builder, String key, List<T> list) {
        return JSONBuilder.append(builder, key, list.stream().map(val -> "\"" + val.toString() + "\"").collect(Collectors.toList()));
    }

    public static StringBuilder appendAndEnd(StringBuilder builder, String key, Object value) {
        return builder.append("\"").append(key).append("\":").append(value).append("}");
    }
}

