/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.ResponseErrorException;
import com.targomo.client.api.response.ResponseCode;
import com.targomo.client.api.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReachabilityResponse {
    private final ResponseCode code;
    private final long requestTimeMillis;
    private final long totalTimeMillis;
    private final TravelOptions travelOptions;
    private final String message;
    private final Map<String, Integer> travelTimes = new HashMap<String, Integer>();
    private final Map<String, String> closestSourceId = new HashMap<String, String>();

    public ReachabilityResponse(TravelOptions travelOptions, JSONObject result, long requestStart) throws ResponseErrorException {
        this.travelOptions = travelOptions;
        this.code = ResponseCode.fromString(JsonUtil.getString(result, "code"));
        this.requestTimeMillis = result.has("requestTime") ? JsonUtil.getLong(result, "requestTime") : -1L;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        String string = this.message = result.has("message") ? JsonUtil.getString(result, "message") : "";
        if (this.code != ResponseCode.OK) {
            String msg = "Reachability request returned an error";
            if (!StringUtils.isEmpty((CharSequence)this.message)) {
                msg = msg + ": " + this.message;
            }
            throw new ResponseErrorException(this.code, msg);
        }
        this.mapResults(result);
    }

    public ReachabilityResponse(TravelOptions travelOptions, ResponseCode code, long requestTime, long requestStart) {
        this.travelOptions = travelOptions;
        this.code = code;
        this.requestTimeMillis = requestTime;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.message = "";
    }

    public void mapResults(JSONObject result) {
        JSONArray jsonArray = JsonUtil.getJsonArray(result, "data");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject target = JsonUtil.getJSONObject(jsonArray, i);
            String trgId = JsonUtil.getString(target, "id");
            this.addTravelTime(trgId, JsonUtil.getInt(target, "travelTime"));
            if (!target.has("source")) continue;
            this.addClosestSource(trgId, JsonUtil.getString(target, "source"));
        }
    }

    public void addTravelTime(String targetId, Integer travelTime) {
        this.travelTimes.put(targetId, travelTime);
    }

    public void addClosestSource(String targetId, String closestSourceId) {
        this.closestSourceId.put(targetId, closestSourceId);
    }

    public ResponseCode getCode() {
        return this.code;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public Map<String, Integer> getTravelTimes() {
        return this.travelTimes;
    }

    public Map<String, String> getClosestSourceIds() {
        return this.closestSourceId;
    }

    public long getTotalTime() {
        return this.totalTimeMillis;
    }

    public String getClosestSourceForTarget(String targetId) {
        return this.closestSourceId.get(targetId);
    }
}

