/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum MultiGraphAggregationType {
    NONE("none", false, false, false, false),
    ONE("one", false, false, false, false),
    MINIMUM("min", true, false, false, false),
    MAXIMUM("max", true, false, false, false),
    SUM("sum", true, false, false, false),
    MEAN("mean", true, false, false, false),
    MEDIAN("median", true, false, false, false),
    NEAREST("nearest", false, false, false, false),
    COUNT("count", true, false, false, false),
    ROUTING_UNION("routing_union", false, false, true, false),
    MATH("math", false, false, false, false),
    GRAVITATION_HUFF("gravitation_huff", true, true, false, false),
    LOGIT("logit", true, true, false, false),
    GRAVITATION_HUFF_OPTIMIZED("gravitation_huff_optimized", false, true, false, true),
    LOGIT_OPTIMIZED("logit_optimized", false, true, false, true);

    private final String key;
    private final boolean mayIgnoreOutliers;
    private final boolean requiresGravitationParameters;
    private final boolean aggregationInRouting;
    private final boolean optimizedProbabilityAggregation;

    private MultiGraphAggregationType(String key, boolean mayIgnoreOutliers, boolean requiresGravitationParameters, boolean aggregationInRouting, boolean optimizedProbabilityAggregation) {
        this.key = key;
        this.mayIgnoreOutliers = mayIgnoreOutliers;
        this.aggregationInRouting = aggregationInRouting;
        this.requiresGravitationParameters = requiresGravitationParameters;
        this.optimizedProbabilityAggregation = optimizedProbabilityAggregation;
    }

    @JsonCreator
    public static MultiGraphAggregationType fromString(String key) {
        return key == null ? null : Stream.of(MultiGraphAggregationType.values()).filter(enu -> enu.key.equalsIgnoreCase(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid " + MultiGraphAggregationType.class.getSimpleName() + " specified: " + key + " doesn't exist"));
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    @JsonIgnore
    public boolean isAggregationInRouting() {
        return this.aggregationInRouting;
    }

    @JsonIgnore
    public boolean isOptimizedProbabilityAggregation() {
        return this.optimizedProbabilityAggregation;
    }

    @JsonIgnore
    public boolean mayIgnoreOutliers() {
        return this.mayIgnoreOutliers;
    }

    @JsonIgnore
    public boolean requiresGravitationParameters() {
        return this.requiresGravitationParameters;
    }
}

