/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PointOfInterestGravitationResponse {
    private static final String ALL_FIELD = "all";
    private final TravelOptions travelOptions;
    private final JSONObject result;
    private final long requestEnd;
    private GravitationResult gravitationResult;

    public PointOfInterestGravitationResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestEnd = System.currentTimeMillis() - requestStart;
        this.result = result;
        this.parseResults();
    }

    public void parseResults() {
        try {
            TypeReference<HashMap<String, Float>> typeRef = new TypeReference<HashMap<String, Float>>(){};
            Map resultMap = (Map)new ObjectMapper().readValue(this.result.toString(), (TypeReference)typeRef);
            Float all = (Float)resultMap.get(ALL_FIELD);
            resultMap.remove(ALL_FIELD);
            this.gravitationResult = new GravitationResult(all, resultMap);
        }
        catch (JsonProcessingException e) {
            throw new TargomoClientRuntimeException("Couldn't parse POI gravitation analysis response", e);
        }
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public JSONObject getResult() {
        return this.result;
    }

    public long getRequestEnd() {
        return this.requestEnd;
    }

    public GravitationResult getGravitationResult() {
        return this.gravitationResult;
    }

    public static class GravitationResult {
        private final Float all;
        private final Map<String, Float> clusters;

        public Float getAll() {
            return this.all;
        }

        public Map<String, Float> getClusters() {
            return this.clusters;
        }

        public GravitationResult(Float all, Map<String, Float> clusters) {
            this.all = all;
            this.clusters = clusters;
        }

        public String toString() {
            return "PointOfInterestGravitationResponse.GravitationResult(all=" + this.getAll() + ", clusters=" + this.getClusters() + ")";
        }
    }
}

